# AsposeCellsCloud::Object::Shape 

## Load the model package
```perl
use AsposeCellsCloud::Object::Shape;
```

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**Name** | **string** | Gets and sets the name of the shape. |
**MsoDrawingType** | **string** | Gets mso drawing type. |
**AutoShapeType** | **string** | Gets and sets the auto shape type. |
**Placement** | **string** | Represents the way the drawing object is attached to the cells below it.                        The property controls the placement of an object on a worksheet. |
**UpperLeftRow** | **int** | Represents upper left corner row index. |
**Top** | **int** | Represents the vertical offset of shape from its top row, in unit of pixels. |
**UpperLeftColumn** | **int** | Represents upper left corner column index. |
**Left** | **int** | Represents the horizontal offset of shape from its left column, in unit of pixels. |
**LowerRightRow** | **int** | Represents lower right corner row index. |
**Bottom** | **int** | Represents the width of the shape's vertical offset from its lower bottom corner row, in unit of pixels. |
**LowerRightColumn** | **int** | Represents lower right corner column index. |
**Right** | **int** | Represents the width of the shape's horizontal  offset from its lower right corner column, in unit of pixels. |
**Width** | **int** | Represents the width of shape, in unit of pixels. |
**Height** | **int** | Represents the height of shape, in unit of pixel. |
**X** | **int** | Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels. |
**Y** | **int** | Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels. |
**RotationAngle** | **double** | Gets and sets the rotation of the shape. |
**HtmlText** | **string** | Gets and sets the html string which contains data and some formats in this textbox. |
**Text** | **string** | Represents the string in this TextBox object. |
**AlternativeText** | **string** | Returns or sets the descriptive (alternative) text string of the  object. |
**TextHorizontalAlignment** | **string** | Gets and sets the text horizontal alignment type of the shape. |
**TextHorizontalOverflow** | **string** | Gets and sets the text horizontal overflow type of the shape which contains text. |
**TextOrientationType** | **string** | Gets and sets the text orientation type of the shape. |
**TextVerticalAlignment** | **string** | Gets and sets the text vertical alignment type of the shape. |
**TextVerticalOverflow** | **string** | Gets and sets the text vertical overflow type of the shape which contains text. |
**IsGroup** | **boolean** | Indicates whether the shape is a group. |
**IsHidden** | **boolean** | Indicates whether the object is visible. |
**IsLockAspectRatio** | **boolean** | True means that don't allow changes in aspect ratio. |
**IsLocked** | **boolean** | True if the object is locked, False if the object can be modified when the sheet is protected. |
**IsPrintable** | **boolean** | True if the object is printable |
**IsTextWrapped** | **boolean** | Gets and sets the text wrapped type of the shape which contains text. |
**IsWordArt** | **boolean** | Indicates whether this shape is a word art. |
**LinkedCell** | **string** | Gets or sets the worksheet range linked to the control's value. |
**ZOrderPosition** | **int** | Returns the position of a shape in the z-order. |
**Font** | **Font** | Represents the font of shape. |
**Hyperlink** | **string** | Gets the hyperlink of the shape. |
**link** | **Link** |  |  

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)

