/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.compact.CompactSyntaxConstants;
import com.thaiopensource.relaxng.parse.compact.CompactSyntaxTokenManager;
import com.thaiopensource.relaxng.parse.compact.EscapeSyntaxException;
import com.thaiopensource.relaxng.parse.compact.JavaCharStream;
import com.thaiopensource.relaxng.parse.compact.ParseException;
import com.thaiopensource.relaxng.parse.compact.Token;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.Ref;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactSyntax<Pattern, NameClass, Location, ElementAnnotation, CommentListImpl extends CommentList<Location>, AnnotationsImpl extends Annotations<Location, ElementAnnotation, CommentListImpl>>
implements Context,
CompactSyntaxConstants {
    private static final int IN_ELEMENT = 0;
    private static final int IN_ATTRIBUTE = 1;
    private static final int IN_ANY_NAME = 2;
    private static final int IN_NS_NAME = 4;
    private String defaultNamespace = SchemaBuilder.INHERIT_NS;
    private String compatibilityPrefix = null;
    private SchemaBuilder<Pattern, NameClass, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> sb;
    private String sourceUri;
    private ErrorHandler eh;
    private final Map<String, String> namespaceMap = new HashMap<String, String>();
    private final Map<String, String> datatypesMap = new HashMap<String, String>();
    private boolean hadError = false;
    private static final Localizer localizer = new Localizer(CompactSyntax.class);
    private final Set<String> attributeNames = new HashSet<String>();
    private boolean annotationsIncludeElements = false;
    private CommentListImpl topLevelComments;
    private Token lastCommentSourceToken = null;
    public CompactSyntaxTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[71];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public CompactSyntax(Reader reader, String string, SchemaBuilder<Pattern, NameClass, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> schemaBuilder, ErrorHandler errorHandler) {
        this(reader);
        this.sourceUri = string;
        this.sb = schemaBuilder;
        this.eh = errorHandler;
        this.topLevelComments = schemaBuilder.makeCommentList();
    }

    Pattern parse(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope) throws IllegalSchemaException {
        try {
            Pattern Pattern2 = this.Input(scope);
            if (!this.hadError) {
                return Pattern2;
            }
        }
        catch (ParseException parseException) {
            this.error("syntax_error", parseException.currentToken.next);
        }
        catch (EscapeSyntaxException escapeSyntaxException) {
            this.reportEscapeSyntaxException(escapeSyntaxException);
        }
        throw new IllegalSchemaException();
    }

    Pattern parseInclude(IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> includedGrammar) throws IllegalSchemaException {
        try {
            Pattern Pattern2 = this.IncludedGrammar(includedGrammar);
            if (!this.hadError) {
                return Pattern2;
            }
        }
        catch (ParseException parseException) {
            this.error("syntax_error", parseException.currentToken.next);
        }
        catch (EscapeSyntaxException escapeSyntaxException) {
            this.reportEscapeSyntaxException(escapeSyntaxException);
        }
        throw new IllegalSchemaException();
    }

    private void checkNsName(int n, LocatedString locatedString) {
        if ((n & 4) != 0) {
            this.error("ns_name_except_contains_ns_name", locatedString.getToken());
        }
    }

    private void checkAnyName(int n, Token token) {
        if ((n & 4) != 0) {
            this.error("ns_name_except_contains_any_name", token);
        }
        if ((n & 2) != 0) {
            this.error("any_name_except_contains_any_name", token);
        }
    }

    private void error(String string, Token token) {
        this.doError(localizer.message(string), token);
    }

    private void error(String string, String string2, Token token) {
        this.doError(localizer.message(string, string2), token);
    }

    private void error(String string, String string2, String string3, Token token) {
        this.doError(localizer.message(string, string2, string3), token);
    }

    private void doError(String string, Token token) {
        this.hadError = true;
        if (this.eh != null) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setLineNumber(token.beginLine);
            locatorImpl.setColumnNumber(token.beginColumn);
            locatorImpl.setSystemId(this.sourceUri);
            try {
                this.eh.error(new SAXParseException(string, locatorImpl));
            }
            catch (SAXException sAXException) {
                throw new BuildException(sAXException);
            }
        }
    }

    private void reportEscapeSyntaxException(EscapeSyntaxException escapeSyntaxException) {
        if (this.eh != null) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setLineNumber(escapeSyntaxException.getLineNumber());
            locatorImpl.setColumnNumber(escapeSyntaxException.getColumnNumber());
            locatorImpl.setSystemId(this.sourceUri);
            try {
                this.eh.error(new SAXParseException(localizer.message(escapeSyntaxException.getKey()), locatorImpl));
            }
            catch (SAXException sAXException) {
                throw new BuildException(sAXException);
            }
        }
    }

    private static String unquote(String string) {
        if (string.length() >= 6 && string.charAt(0) == string.charAt(1)) {
            string = string.replace('\u0000', '\n');
            return string.substring(3, string.length() - 3);
        }
        return string.substring(1, string.length() - 1);
    }

    Location makeLocation(Token token) {
        return this.sb.makeLocation(this.sourceUri, token.beginLine, token.beginColumn);
    }

    String getCompatibilityPrefix() {
        if (this.compatibilityPrefix == null) {
            this.compatibilityPrefix = "a";
            while (this.namespaceMap.get(this.compatibilityPrefix) != null) {
                this.compatibilityPrefix = this.compatibilityPrefix + "a";
            }
        }
        return this.compatibilityPrefix;
    }

    @Override
    public String resolveNamespacePrefix(String string) {
        String string2 = this.namespaceMap.get(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }

    @Override
    public Set<String> prefixes() {
        return this.namespaceMap.keySet();
    }

    @Override
    public String getBaseUri() {
        return this.sourceUri;
    }

    @Override
    public boolean isUnparsedEntity(String string) {
        return false;
    }

    @Override
    public boolean isNotation(String string) {
        return false;
    }

    @Override
    public Context copy() {
        return this;
    }

    private Context getContext() {
        return this;
    }

    private CommentListImpl getComments() {
        return this.getComments(this.getTopLevelComments());
    }

    private CommentListImpl getTopLevelComments() {
        CommentListImpl CommentListImpl2 = this.topLevelComments;
        this.topLevelComments = null;
        return CommentListImpl2;
    }

    private void noteTopLevelComments() {
        this.topLevelComments = this.getComments(this.topLevelComments);
    }

    private void topLevelComments(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection) {
        grammarSection.topLevelComment(this.getComments(null));
    }

    private CommentListImpl getComments(CommentListImpl CommentListImpl2) {
        Token token = this.getToken(1);
        if (this.lastCommentSourceToken != token) {
            if (this.lastCommentSourceToken == null) {
                this.lastCommentSourceToken = this.token;
            }
            do {
                this.lastCommentSourceToken = this.lastCommentSourceToken.next;
                Token token2 = this.lastCommentSourceToken.specialToken;
                if (token2 == null) continue;
                while (token2.specialToken != null) {
                    token2 = token2.specialToken;
                }
                if (CommentListImpl2 == null) {
                    CommentListImpl2 = this.sb.makeCommentList();
                }
                while (token2 != null) {
                    String string = CompactSyntax.mungeComment(token2.image);
                    Location Location = this.makeLocation(token2);
                    if (token2.next != null && token2.next.kind == 44) {
                        StringBuffer stringBuffer = new StringBuffer(string);
                        do {
                            token2 = token2.next;
                            stringBuffer.append('\n');
                            stringBuffer.append(CompactSyntax.mungeComment(token2.image));
                        } while (token2.next != null && token2.next.kind == 44);
                        string = stringBuffer.toString();
                    }
                    CommentListImpl2.addComment(string, Location);
                    token2 = token2.next;
                }
            } while (this.lastCommentSourceToken != token);
        }
        return CommentListImpl2;
    }

    private Pattern afterPatternComments(Pattern Pattern2) {
        Object CL = this.getComments(null);
        if (CL == null) {
            return Pattern2;
        }
        return this.sb.commentAfterPattern(Pattern2, CL);
    }

    private NameClass afterNameClassComments(NameClass NameClass2) {
        Object CL = this.getComments(null);
        if (CL == null) {
            return NameClass2;
        }
        return this.sb.commentAfterNameClass(NameClass2, CL);
    }

    private static String mungeComment(String string) {
        int n;
        for (n = string.indexOf(35) + 1; n < string.length() && string.charAt(n) == '#'; ++n) {
        }
        if (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return string.substring(n);
    }

    private AnnotationsImpl getCommentsAsAnnotations() {
        CommentListImpl CommentListImpl2 = this.getComments();
        if (CommentListImpl2 == null) {
            return null;
        }
        return this.sb.makeAnnotations(CommentListImpl2, this.getContext());
    }

    private AnnotationsImpl addCommentsToChildAnnotations(AnnotationsImpl AnnotationsImpl2) {
        CommentListImpl CommentListImpl2 = this.getComments();
        if (CommentListImpl2 == null) {
            return AnnotationsImpl2;
        }
        if (AnnotationsImpl2 == null) {
            AnnotationsImpl2 = this.sb.makeAnnotations(null, this.getContext());
        }
        AnnotationsImpl2.addComment(CommentListImpl2);
        return AnnotationsImpl2;
    }

    private AnnotationsImpl addCommentsToLeadingAnnotations(AnnotationsImpl AnnotationsImpl2) {
        CommentListImpl CommentListImpl2 = this.getComments();
        if (CommentListImpl2 == null) {
            return AnnotationsImpl2;
        }
        if (AnnotationsImpl2 == null) {
            return this.sb.makeAnnotations(CommentListImpl2, this.getContext());
        }
        AnnotationsImpl2.addLeadingComment(CommentListImpl2);
        return AnnotationsImpl2;
    }

    private AnnotationsImpl getTopLevelCommentsAsAnnotations() {
        CommentListImpl CommentListImpl2 = this.getTopLevelComments();
        if (CommentListImpl2 == null) {
            return null;
        }
        return this.sb.makeAnnotations(CommentListImpl2, this.getContext());
    }

    private void clearAttributeList() {
        this.attributeNames.clear();
    }

    private void addAttribute(Annotations<Location, ElementAnnotation, CommentListImpl> annotations, String string, String string2, String string3, String string4, Token token) {
        String string5 = string + "#" + string2;
        if (this.attributeNames.contains(string5)) {
            this.error("duplicate_attribute", string, string2, token);
        } else {
            this.attributeNames.add(string5);
            annotations.addAttribute(string, string2, string3, string4, this.makeLocation(token));
        }
    }

    private void checkExcept(Token[] tokenArray) {
        if (tokenArray[0] != null) {
            this.error("except_missing_parentheses", tokenArray[0]);
        }
    }

    private String lookupPrefix(String string, Token token) {
        String string2 = this.namespaceMap.get(string);
        if (string2 == null) {
            this.error("undeclared_prefix", string, token);
            return "#error";
        }
        return string2;
    }

    private String lookupDatatype(String string, Token token) {
        String string2 = this.datatypesMap.get(string);
        if (string2 == null) {
            this.error("undeclared_prefix", string, token);
            return "";
        }
        return string2;
    }

    public final Pattern Input(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope) throws ParseException {
        Pattern Pattern2;
        this.Preamble();
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            Pattern2 = this.TopLevelGrammar(scope);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 10: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 28: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 40: 
                case 43: 
                case 54: 
                case 55: 
                case 57: 
                case 58: {
                    Pattern2 = this.Expr(true, scope, null, null);
                    Pattern2 = this.afterPatternComments(Pattern2);
                    this.jj_consume_token(0);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return Pattern2;
    }

    public final void TopLevelLookahead() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(1);
                break;
            }
            case 54: 
            case 55: {
                this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break block0;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: 
            case 6: 
            case 7: {
                this.LookaheadGrammarKeyword();
                break;
            }
            case 1: {
                this.LookaheadBody();
                this.LookaheadAfterAnnotations();
                break;
            }
            case 40: 
            case 43: {
                this.LookaheadDocumentation();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.LookaheadBody();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                this.LookaheadAfterAnnotations();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadAfterAnnotations() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: 
            case 6: 
            case 7: {
                this.LookaheadGrammarKeyword();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadGrammarKeyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadDocumentation() throws ParseException {
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(41);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: 
                case 43: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[9] = this.jj_gen;
    }

    public final void LookaheadBody() throws ParseException {
        block12: {
            this.jj_consume_token(1);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: {
                        this.jj_consume_token(57);
                        continue block11;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: {
                        this.UnprefixedName();
                        continue block11;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        continue block11;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        continue block11;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        continue block11;
                    }
                    case 1: {
                        this.LookaheadBody();
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(9);
    }

    public final Pattern IncludedGrammar(IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> includedGrammar) throws ParseException {
        AnnotationsImpl AnnotationsImpl2;
        this.Preamble();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            AnnotationsImpl2 = this.GrammarBody(includedGrammar, includedGrammar, this.getTopLevelCommentsAsAnnotations());
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 10: 
                case 40: 
                case 43: {
                    AnnotationsImpl2 = this.AnnotationsImpl();
                    this.jj_consume_token(10);
                    this.jj_consume_token(11);
                    AnnotationsImpl2 = this.GrammarBody(includedGrammar, includedGrammar, AnnotationsImpl2);
                    this.topLevelComments(includedGrammar);
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        Pattern Pattern2 = this.afterPatternComments(includedGrammar.endIncludedGrammar(this.sb.makeLocation(this.sourceUri, 1, 1), AnnotationsImpl2));
        this.jj_consume_token(0);
        return Pattern2;
    }

    public final Pattern TopLevelGrammar(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope) throws ParseException {
        AnnotationsImpl AnnotationsImpl2 = this.getTopLevelCommentsAsAnnotations();
        Grammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammar = this.sb.makeGrammar(scope);
        AnnotationsImpl2 = this.GrammarBody(grammar, grammar, AnnotationsImpl2);
        Pattern Pattern2 = this.afterPatternComments(grammar.endGrammar(this.sb.makeLocation(this.sourceUri, 1, 1), AnnotationsImpl2));
        this.jj_consume_token(0);
        return Pattern2;
    }

    public final void Preamble() throws ParseException {
        block9: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: {
                        this.NamespaceDecl();
                        continue block7;
                    }
                    case 16: {
                        this.DatatypesDecl();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.namespaceMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        if (this.datatypesMap.get("xsd") == null) {
            this.datatypesMap.put("xsd", "http://www.w3.org/2001/XMLSchema-datatypes");
        }
    }

    public final void NamespaceDecl() throws ParseException {
        LocatedString locatedString = null;
        boolean bl = false;
        this.noteTopLevelComments();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                locatedString = this.UnprefixedName();
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                bl = true;
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: {
                        locatedString = this.UnprefixedName();
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(2);
        String string = this.NamespaceName();
        if (bl) {
            this.defaultNamespace = string;
        }
        if (locatedString != null) {
            if (locatedString.getString().equals("xmlns")) {
                this.error("xmlns_prefix", locatedString.getToken());
            } else if (locatedString.getString().equals("xml")) {
                if (!string.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.error("xml_prefix_bad_uri", locatedString.getToken());
                }
            } else if (string.equals("http://www.w3.org/XML/1998/namespace")) {
                this.error("xml_uri_bad_prefix", locatedString.getToken());
            } else {
                if (string.equals("http://relaxng.org/ns/compatibility/annotations/1.0")) {
                    this.compatibilityPrefix = locatedString.getString();
                }
                this.namespaceMap.put(locatedString.getString(), string);
            }
        }
    }

    public final String NamespaceName() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                string = this.Literal();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                string = SchemaBuilder.INHERIT_NS;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final void DatatypesDecl() throws ParseException {
        this.noteTopLevelComments();
        this.jj_consume_token(16);
        LocatedString locatedString = this.UnprefixedName();
        this.jj_consume_token(2);
        String string = this.Literal();
        this.datatypesMap.put(locatedString.getString(), string);
    }

    public final Pattern AnnotatedPrimaryExpr(boolean bl, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, Token[] tokenArray) throws ParseException {
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        Pattern Pattern2 = this.PrimaryExpr(bl, scope, AnnotationsImpl2, tokenArray);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            Token token = this.jj_consume_token(59);
            ElementAnnotation ElementAnnotation = this.AnnotationElement(false);
            if (bl) {
                this.error("top_level_follow_annotation", token);
                continue;
            }
            Pattern2 = this.sb.annotateAfterPattern(Pattern2, ElementAnnotation);
        }
        return Pattern2;
    }

    public final Pattern PrimaryExpr(boolean bl, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2, Token[] tokenArray) throws ParseException {
        Pattern Pattern2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                Pattern2 = this.ElementExpr(scope, AnnotationsImpl2);
                break;
            }
            case 27: {
                Pattern2 = this.AttributeExpr(scope, AnnotationsImpl2);
                break;
            }
            case 10: {
                Pattern2 = this.GrammarExpr(scope, AnnotationsImpl2);
                break;
            }
            case 33: {
                Pattern2 = this.ExternalRefExpr(scope, AnnotationsImpl2);
                break;
            }
            case 31: {
                Pattern2 = this.ListExpr(scope, AnnotationsImpl2);
                break;
            }
            case 32: {
                Pattern2 = this.MixedExpr(scope, AnnotationsImpl2);
                break;
            }
            case 28: {
                Pattern2 = this.ParenExpr(bl, scope, AnnotationsImpl2);
                break;
            }
            case 54: 
            case 55: {
                Pattern2 = this.IdentifierExpr(scope, AnnotationsImpl2);
                break;
            }
            case 34: {
                Pattern2 = this.ParentExpr(scope, AnnotationsImpl2);
                break;
            }
            case 35: 
            case 36: 
            case 57: {
                Pattern2 = this.DataExpr(bl, scope, AnnotationsImpl2, tokenArray);
                break;
            }
            case 58: {
                Pattern2 = this.ValueExpr(bl, AnnotationsImpl2);
                break;
            }
            case 18: {
                Pattern2 = this.TextExpr(AnnotationsImpl2);
                break;
            }
            case 17: {
                Pattern2 = this.EmptyExpr(AnnotationsImpl2);
                break;
            }
            case 19: {
                Pattern2 = this.NotAllowedExpr(AnnotationsImpl2);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Pattern2;
    }

    public final Pattern EmptyExpr(AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(17);
        return this.sb.makeEmpty(this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern TextExpr(AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(18);
        return this.sb.makeText(this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern NotAllowedExpr(AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(19);
        return this.sb.makeNotAllowed(this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern Expr(boolean bl, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, Token token, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        boolean[] blArray = new boolean[1];
        Token[] tokenArray = new Token[1];
        Pattern Pattern2 = this.UnaryExpr(bl, scope, blArray, tokenArray);
        arrayList.add(Pattern2);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.checkExcept(tokenArray);
                        block17: while (true) {
                            token = this.jj_consume_token(20);
                            Pattern2 = this.UnaryExpr(bl, scope, null, tokenArray);
                            arrayList.add(Pattern2);
                            this.checkExcept(tokenArray);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 20: {
                                    continue block17;
                                }
                            }
                            break;
                        }
                        this.jj_la1[20] = this.jj_gen;
                        Pattern2 = this.sb.makeChoice(arrayList, this.makeLocation(token), AnnotationsImpl2);
                        break block0;
                    }
                    case 21: {
                        block18: while (true) {
                            token = this.jj_consume_token(21);
                            Pattern2 = this.UnaryExpr(bl, scope, null, tokenArray);
                            arrayList.add(Pattern2);
                            this.checkExcept(tokenArray);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        this.jj_la1[21] = this.jj_gen;
                        Pattern2 = this.sb.makeInterleave(arrayList, this.makeLocation(token), AnnotationsImpl2);
                        break block0;
                    }
                    case 22: {
                        block19: while (true) {
                            token = this.jj_consume_token(22);
                            Pattern2 = this.UnaryExpr(bl, scope, null, tokenArray);
                            arrayList.add(Pattern2);
                            this.checkExcept(tokenArray);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 22: {
                                    continue block19;
                                }
                            }
                            break;
                        }
                        this.jj_la1[22] = this.jj_gen;
                        Pattern2 = this.sb.makeGroup(arrayList, this.makeLocation(token), AnnotationsImpl2);
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (arrayList.size() == 1 && AnnotationsImpl2 != null) {
            Pattern2 = blArray[0] ? this.sb.annotatePattern(Pattern2, AnnotationsImpl2) : this.sb.makeGroup(arrayList, this.makeLocation(token), AnnotationsImpl2);
        }
        return Pattern2;
    }

    public final Pattern UnaryExpr(boolean bl, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, boolean[] blArray, Token[] tokenArray) throws ParseException {
        Pattern Pattern2 = this.AnnotatedPrimaryExpr(bl, scope, tokenArray);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: 
            case 24: 
            case 25: {
                Token token;
                if (blArray != null) {
                    blArray[0] = true;
                }
                Pattern2 = this.afterPatternComments(Pattern2);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        token = this.jj_consume_token(23);
                        this.checkExcept(tokenArray);
                        Pattern2 = this.sb.makeOneOrMore(Pattern2, this.makeLocation(token), null);
                        break;
                    }
                    case 24: {
                        token = this.jj_consume_token(24);
                        this.checkExcept(tokenArray);
                        Pattern2 = this.sb.makeOptional(Pattern2, this.makeLocation(token), null);
                        break;
                    }
                    case 25: {
                        token = this.jj_consume_token(25);
                        this.checkExcept(tokenArray);
                        Pattern2 = this.sb.makeZeroOrMore(Pattern2, this.makeLocation(token), null);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 59: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block0;
                        }
                    }
                    token = this.jj_consume_token(59);
                    ElementAnnotation ElementAnnotation = this.AnnotationElement(false);
                    if (bl) {
                        this.error("top_level_follow_annotation", token);
                        continue;
                    }
                    Pattern2 = this.sb.annotateAfterPattern(Pattern2, ElementAnnotation);
                }
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        return Pattern2;
    }

    public final Pattern ElementExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(26);
        NameClass NameClass2 = this.NameClass(0, null);
        this.jj_consume_token(11);
        Pattern Pattern2 = this.Expr(false, scope, null, null);
        Pattern2 = this.afterPatternComments(Pattern2);
        this.jj_consume_token(12);
        return this.sb.makeElement(NameClass2, Pattern2, this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern AttributeExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(27);
        NameClass NameClass2 = this.NameClass(1, null);
        this.jj_consume_token(11);
        Pattern Pattern2 = this.Expr(false, scope, null, null);
        Pattern2 = this.afterPatternComments(Pattern2);
        this.jj_consume_token(12);
        return this.sb.makeAttribute(NameClass2, Pattern2, this.makeLocation(token), AnnotationsImpl2);
    }

    public final NameClass NameClass(int n, Ref<AnnotationsImpl> ref) throws ParseException {
        NameClass NameClass2;
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: 
            case 57: {
                NameClass2 = this.PrimaryNameClass(n, AnnotationsImpl2);
                NameClass2 = this.AnnotateAfter(NameClass2);
                NameClass2 = this.NameClassAlternatives(n, NameClass2, ref);
                break;
            }
            case 25: {
                NameClass2 = this.AnyNameExceptClass(n, AnnotationsImpl2, ref);
                break;
            }
            case 56: {
                NameClass2 = this.NsNameExceptClass(n, AnnotationsImpl2, ref);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return NameClass2;
    }

    public final NameClass AnnotateAfter(NameClass NameClass2) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(59);
            ElementAnnotation ElementAnnotation = this.AnnotationElement(false);
            NameClass2 = this.sb.annotateAfterNameClass(NameClass2, ElementAnnotation);
        }
        return NameClass2;
    }

    public final NameClass NameClassAlternatives(int n, NameClass NameClass2, Ref<AnnotationsImpl> ref) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Annotations annotations;
                Token token;
                ArrayList<NameClass> arrayList = new ArrayList<NameClass>();
                arrayList.add(NameClass2);
                block6: while (true) {
                    token = this.jj_consume_token(20);
                    NameClass2 = this.BasicNameClass(n);
                    NameClass2 = this.AnnotateAfter(NameClass2);
                    arrayList.add(NameClass2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[30] = this.jj_gen;
                if (ref == null) {
                    annotations = null;
                } else {
                    annotations = (Annotations)ref.get();
                    ref.clear();
                }
                NameClass2 = this.sb.makeNameClassChoice(arrayList, this.makeLocation(token), annotations);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        return NameClass2;
    }

    public final NameClass BasicNameClass(int n) throws ParseException {
        NameClass NameClass2;
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: 
            case 57: {
                NameClass2 = this.PrimaryNameClass(n, AnnotationsImpl2);
                break;
            }
            case 25: 
            case 56: {
                NameClass2 = this.OpenNameClass(n, AnnotationsImpl2);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return NameClass2;
    }

    public final NameClass PrimaryNameClass(int n, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        NameClass NameClass2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                NameClass2 = this.UnprefixedNameClass(n, AnnotationsImpl2);
                break;
            }
            case 57: {
                NameClass2 = this.PrefixedNameClass(AnnotationsImpl2);
                break;
            }
            case 28: {
                NameClass2 = this.ParenNameClass(n, AnnotationsImpl2);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return NameClass2;
    }

    public final NameClass OpenNameClass(int n, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                LocatedString locatedString = this.NsName();
                this.checkNsName(n, locatedString);
                return this.sb.makeNsName(locatedString.getString(), locatedString.getLocation(), AnnotationsImpl2);
            }
            case 25: {
                Token token = this.jj_consume_token(25);
                this.checkAnyName(n, token);
                return this.sb.makeAnyName(this.makeLocation(token), AnnotationsImpl2);
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NameClass UnprefixedNameClass(int n, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        LocatedString locatedString = this.UnprefixedName();
        String string = (n & 1) == 1 ? "" : this.defaultNamespace;
        return this.sb.makeName(string, locatedString.getString(), null, locatedString.getLocation(), AnnotationsImpl2);
    }

    public final NameClass PrefixedNameClass(AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(57);
        String string = token.image;
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        return this.sb.makeName(this.lookupPrefix(string2, token), string.substring(n + 1), string2, this.makeLocation(token), AnnotationsImpl2);
    }

    public final NameClass NsNameExceptClass(int n, AnnotationsImpl AnnotationsImpl2, Ref<AnnotationsImpl> ref) throws ParseException {
        NameClass NameClass2;
        LocatedString locatedString = this.NsName();
        this.checkNsName(n, locatedString);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                NameClass2 = this.ExceptNameClass(n | 4);
                NameClass2 = this.sb.makeNsName(locatedString.getString(), NameClass2, locatedString.getLocation(), AnnotationsImpl2);
                NameClass2 = this.AnnotateAfter(NameClass2);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                NameClass2 = this.sb.makeNsName(locatedString.getString(), locatedString.getLocation(), AnnotationsImpl2);
                NameClass2 = this.AnnotateAfter(NameClass2);
                NameClass2 = this.NameClassAlternatives(n, NameClass2, ref);
            }
        }
        return NameClass2;
    }

    public final LocatedString NsName() throws ParseException {
        Token token = this.jj_consume_token(56);
        String string = token.image;
        String string2 = string.substring(0, string.length() - 2);
        return new LocatedString(this.lookupPrefix(string2, token), token);
    }

    public final NameClass AnyNameExceptClass(int n, AnnotationsImpl AnnotationsImpl2, Ref<AnnotationsImpl> ref) throws ParseException {
        NameClass NameClass2;
        Token token = this.jj_consume_token(25);
        this.checkAnyName(n, token);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                NameClass2 = this.ExceptNameClass(n | 2);
                NameClass2 = this.sb.makeAnyName(NameClass2, this.makeLocation(token), AnnotationsImpl2);
                NameClass2 = this.AnnotateAfter(NameClass2);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                NameClass2 = this.sb.makeAnyName(this.makeLocation(token), AnnotationsImpl2);
                NameClass2 = this.AnnotateAfter(NameClass2);
                NameClass2 = this.NameClassAlternatives(n, NameClass2, ref);
            }
        }
        return NameClass2;
    }

    public final NameClass ParenNameClass(int n, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Ref<AnnotationsImpl> ref = new Ref<AnnotationsImpl>(AnnotationsImpl2);
        Token token = this.jj_consume_token(28);
        NameClass NameClass2 = this.NameClass(n, ref);
        NameClass2 = this.afterNameClassComments(NameClass2);
        this.jj_consume_token(29);
        if (ref.get() != null) {
            NameClass2 = this.sb.makeNameClassChoice(Collections.singletonList(NameClass2), this.makeLocation(token), (Annotations)ref.get());
        }
        return NameClass2;
    }

    public final NameClass ExceptNameClass(int n) throws ParseException {
        this.jj_consume_token(30);
        NameClass NameClass2 = this.BasicNameClass(n);
        return NameClass2;
    }

    public final Pattern ListExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(31);
        this.jj_consume_token(11);
        Pattern Pattern2 = this.Expr(false, scope, null, null);
        Pattern2 = this.afterPatternComments(Pattern2);
        this.jj_consume_token(12);
        return this.sb.makeList(Pattern2, this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern MixedExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(32);
        this.jj_consume_token(11);
        Pattern Pattern2 = this.Expr(false, scope, null, null);
        Pattern2 = this.afterPatternComments(Pattern2);
        this.jj_consume_token(12);
        return this.sb.makeMixed(Pattern2, this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern GrammarExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(10);
        Grammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammar = this.sb.makeGrammar(scope);
        this.jj_consume_token(11);
        AnnotationsImpl2 = this.GrammarBody(grammar, grammar, AnnotationsImpl2);
        this.topLevelComments(grammar);
        this.jj_consume_token(12);
        return grammar.endGrammar(this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern ParenExpr(boolean bl, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(28);
        Pattern Pattern2 = this.Expr(bl, scope, token, AnnotationsImpl2);
        Pattern2 = this.afterPatternComments(Pattern2);
        this.jj_consume_token(29);
        return Pattern2;
    }

    public final AnnotationsImpl GrammarBody(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        while (this.jj_2_3(2)) {
            ElementAnnotation ElementAnnotation = this.AnnotationElementNotKeyword();
            if (AnnotationsImpl2 == null) {
                AnnotationsImpl2 = this.sb.makeAnnotations(null, this.getContext());
            }
            AnnotationsImpl2.addElement(ElementAnnotation);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block4;
                }
            }
            this.GrammarComponent(grammarSection, scope);
        }
        return AnnotationsImpl2;
    }

    public final void GrammarComponent(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope) throws ParseException {
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 54: 
            case 55: {
                this.Definition(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            case 7: {
                this.Include(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            case 6: {
                this.Div(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_4(2)) {
            ElementAnnotation ElementAnnotation = this.AnnotationElementNotKeyword();
            grammarSection.topLevelAnnotation(ElementAnnotation);
        }
    }

    public final void Definition(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                this.Define(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            case 5: {
                this.Start(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Start(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(5);
        GrammarSection.Combine combine = this.AssignOp();
        Pattern Pattern2 = this.Expr(false, scope, null, null);
        grammarSection.define("#start", combine, Pattern2, this.makeLocation(token), AnnotationsImpl2);
    }

    public final void Define(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        LocatedString locatedString = this.Identifier();
        GrammarSection.Combine combine = this.AssignOp();
        Pattern Pattern2 = this.Expr(false, scope, null, null);
        grammarSection.define(locatedString.getString(), combine, Pattern2, locatedString.getLocation(), AnnotationsImpl2);
    }

    public final GrammarSection.Combine AssignOp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                return null;
            }
            case 4: {
                this.jj_consume_token(4);
                return GrammarSection.COMBINE_CHOICE;
            }
            case 3: {
                this.jj_consume_token(3);
                return GrammarSection.COMBINE_INTERLEAVE;
            }
        }
        this.jj_la1[40] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Include(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Include<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> include = grammarSection.makeInclude();
        Token token = this.jj_consume_token(7);
        String string = this.Literal();
        String string2 = this.Inherit();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                AnnotationsImpl2 = this.IncludeBody(include, scope, AnnotationsImpl2);
                this.topLevelComments(include);
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        try {
            include.endInclude(string, this.sourceUri, string2, this.makeLocation(token), AnnotationsImpl2);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            // empty catch block
        }
    }

    public final AnnotationsImpl IncludeBody(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        while (this.jj_2_5(2)) {
            ElementAnnotation ElementAnnotation = this.AnnotationElementNotKeyword();
            if (AnnotationsImpl2 == null) {
                AnnotationsImpl2 = this.sb.makeAnnotations(null, this.getContext());
            }
            AnnotationsImpl2.addElement(ElementAnnotation);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block4;
                }
            }
            this.IncludeComponent(grammarSection, scope);
        }
        return AnnotationsImpl2;
    }

    public final void IncludeComponent(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope) throws ParseException {
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 54: 
            case 55: {
                this.Definition(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            case 6: {
                this.IncludeDiv(grammarSection, scope, AnnotationsImpl2);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_6(2)) {
            ElementAnnotation ElementAnnotation = this.AnnotationElementNotKeyword();
            grammarSection.topLevelAnnotation(ElementAnnotation);
        }
    }

    public final void Div(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Div<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> div = grammarSection.makeDiv();
        Token token = this.jj_consume_token(6);
        this.jj_consume_token(11);
        AnnotationsImpl2 = this.GrammarBody(div, scope, AnnotationsImpl2);
        this.topLevelComments(div);
        this.jj_consume_token(12);
        div.endDiv(this.makeLocation(token), AnnotationsImpl2);
    }

    public final void IncludeDiv(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Div<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> div = grammarSection.makeDiv();
        Token token = this.jj_consume_token(6);
        this.jj_consume_token(11);
        AnnotationsImpl2 = this.IncludeBody(div, scope, AnnotationsImpl2);
        this.topLevelComments(div);
        this.jj_consume_token(12);
        div.endDiv(this.makeLocation(token), AnnotationsImpl2);
    }

    public final Pattern ExternalRefExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        Token token = this.jj_consume_token(33);
        String string = this.Literal();
        String string2 = this.Inherit();
        try {
            return this.sb.makeExternalRef(string, this.sourceUri, string2, scope, this.makeLocation(token), AnnotationsImpl2);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            return this.sb.makeErrorPattern();
        }
    }

    public final String Inherit() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.jj_consume_token(2);
                string = this.Prefix();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (string == null) {
            string = this.defaultNamespace;
        }
        return string;
    }

    public final Pattern ParentExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        this.jj_consume_token(34);
        AnnotationsImpl2 = this.addCommentsToChildAnnotations(AnnotationsImpl2);
        LocatedString locatedString = this.Identifier();
        return scope.makeParentRef(locatedString.getString(), locatedString.getLocation(), AnnotationsImpl2);
    }

    public final Pattern IdentifierExpr(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        LocatedString locatedString = this.Identifier();
        return scope.makeRef(locatedString.getString(), locatedString.getLocation(), AnnotationsImpl2);
    }

    public final Pattern ValueExpr(boolean bl, AnnotationsImpl AnnotationsImpl2) throws ParseException {
        LocatedString locatedString = this.LocatedLiteral();
        if (bl && this.annotationsIncludeElements) {
            this.error("top_level_follow_annotation", locatedString.getToken());
            AnnotationsImpl2 = null;
        }
        return this.sb.makeValue("", "token", locatedString.getString(), this.getContext(), this.defaultNamespace, locatedString.getLocation(), AnnotationsImpl2);
    }

    public final Pattern DataExpr(boolean bl, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, AnnotationsImpl AnnotationsImpl2, Token[] tokenArray) throws ParseException {
        String string = null;
        String string2 = null;
        Object p = null;
        Token token = this.DatatypeName();
        String string3 = token.image;
        Location Location = this.makeLocation(token);
        int n = string3.indexOf(58);
        if (n < 0) {
            string = "";
        } else {
            String string4 = string3.substring(0, n);
            string = this.lookupDatatype(string4, token);
            string3 = string3.substring(n + 1);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                string2 = this.Literal();
                if (bl && this.annotationsIncludeElements) {
                    this.error("top_level_follow_annotation", token);
                    AnnotationsImpl2 = null;
                }
                return this.sb.makeValue(string, string3, string2, this.getContext(), this.defaultNamespace, Location, AnnotationsImpl2);
            }
        }
        this.jj_la1[48] = this.jj_gen;
        DataPatternBuilder<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> dataPatternBuilder = this.sb.makeDataPatternBuilder(string, string3, Location);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.Params(dataPatternBuilder);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        p = this.Except(scope, tokenArray);
                        break block3;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        p = this.Except(scope, tokenArray);
                        break block3;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
            }
        }
        return (Pattern)(p == null ? dataPatternBuilder.makePattern(Location, AnnotationsImpl2) : dataPatternBuilder.makePattern(p, Location, AnnotationsImpl2));
    }

    public final Token DatatypeName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 57: {
                token = this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final LocatedString Identifier() throws ParseException {
        LocatedString locatedString;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                Token token = this.jj_consume_token(54);
                locatedString = new LocatedString(token.image, token);
                break;
            }
            case 55: {
                Token token = this.jj_consume_token(55);
                locatedString = new LocatedString(token.image.substring(1), token);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return locatedString;
    }

    public final String Prefix() throws ParseException {
        String string;
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                token = this.jj_consume_token(54);
                string = token.image;
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                string = token.image.substring(1);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                token = this.Keyword();
                string = token.image;
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.lookupPrefix(string, token);
    }

    public final LocatedString UnprefixedName() throws ParseException {
        LocatedString locatedString;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                locatedString = this.Identifier();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                Token token = this.Keyword();
                locatedString = new LocatedString(token.image, token);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return locatedString;
    }

    public final void Params(DataPatternBuilder<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> dataPatternBuilder) throws ParseException {
        this.jj_consume_token(11);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.Param(dataPatternBuilder);
        }
        this.jj_consume_token(12);
    }

    public final void Param(DataPatternBuilder<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> dataPatternBuilder) throws ParseException {
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        LocatedString locatedString = this.UnprefixedName();
        this.jj_consume_token(2);
        AnnotationsImpl2 = this.addCommentsToLeadingAnnotations(AnnotationsImpl2);
        String string = this.Literal();
        dataPatternBuilder.addParam(locatedString.getString(), string, this.getContext(), this.defaultNamespace, locatedString.getLocation(), AnnotationsImpl2);
    }

    public final Pattern Except(Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, Token[] tokenArray) throws ParseException {
        Token[] tokenArray2 = new Token[1];
        Token token = this.jj_consume_token(30);
        AnnotationsImpl AnnotationsImpl2 = this.AnnotationsImpl();
        Pattern Pattern2 = this.PrimaryExpr(false, scope, AnnotationsImpl2, tokenArray2);
        this.checkExcept(tokenArray2);
        tokenArray[0] = token;
        return Pattern2;
    }

    public final ElementAnnotation Documentation() throws ParseException {
        Token token;
        CommentListImpl CommentListImpl2 = this.getComments();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder("http://relaxng.org/ns/compatibility/annotations/1.0", "documentation", this.getCompatibilityPrefix(), this.makeLocation(token), CommentListImpl2, this.getContext());
        elementAnnotationBuilder.addText(CompactSyntax.mungeComment(token.image), this.makeLocation(token), null);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block7;
                }
            }
            token = this.jj_consume_token(41);
            elementAnnotationBuilder.addText("\n" + CompactSyntax.mungeComment(token.image), this.makeLocation(token), null);
        }
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final AnnotationsImpl AnnotationsImpl() throws ParseException {
        ElementAnnotation ElementAnnotation;
        CommentListImpl CommentListImpl2 = this.getComments();
        Annotations annotations = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 43: {
                annotations = (Annotations)this.sb.makeAnnotations(CommentListImpl2, this.getContext());
                block12: while (true) {
                    ElementAnnotation = this.Documentation();
                    annotations.addElement(ElementAnnotation);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 40: 
                        case 43: {
                            continue block12;
                        }
                    }
                    break;
                }
                this.jj_la1[56] = this.jj_gen;
                CommentListImpl2 = this.getComments();
                if (CommentListImpl2 == null) break;
                annotations.addLeadingComment(CommentListImpl2);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                if (annotations == null) {
                    annotations = this.sb.makeAnnotations(CommentListImpl2, this.getContext());
                }
                this.clearAttributeList();
                this.annotationsIncludeElements = false;
                while (this.jj_2_7(2)) {
                    this.PrefixedAnnotationAttribute(annotations, false);
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 26: 
                        case 27: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 54: 
                        case 55: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                            break block14;
                        }
                    }
                    ElementAnnotation = this.AnnotationElement(false);
                    annotations.addElement(ElementAnnotation);
                    this.annotationsIncludeElements = true;
                }
                annotations.addComment(this.getComments());
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        if (annotations == null && CommentListImpl2 != null) {
            annotations = this.sb.makeAnnotations(CommentListImpl2, this.getContext());
        }
        return (AnnotationsImpl)annotations;
    }

    public final void AnnotationAttribute(Annotations<Location, ElementAnnotation, CommentListImpl> annotations) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.PrefixedAnnotationAttribute(annotations, true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                this.UnprefixedAnnotationAttribute(annotations);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PrefixedAnnotationAttribute(Annotations<Location, ElementAnnotation, CommentListImpl> annotations, boolean bl) throws ParseException {
        Token token = this.jj_consume_token(57);
        this.jj_consume_token(2);
        String string = this.Literal();
        String string2 = token.image;
        int n = string2.indexOf(58);
        String string3 = string2.substring(0, n);
        String string4 = this.lookupPrefix(string3, token);
        if (string4 == SchemaBuilder.INHERIT_NS) {
            this.error("inherited_annotation_namespace", token);
        } else if (string4.length() == 0 && !bl) {
            this.error("unqualified_annotation_attribute", token);
        } else if (string4.equals("http://relaxng.org/ns/structure/1.0") && !bl) {
            this.error("relax_ng_namespace", token);
        } else if (string4.equals("http://www.w3.org/2000/xmlns")) {
            this.error("xmlns_annotation_attribute_uri", token);
        } else {
            if (string4.length() == 0) {
                string3 = null;
            }
            this.addAttribute(annotations, string4, string2.substring(n + 1), string3, string, token);
        }
    }

    public final void UnprefixedAnnotationAttribute(Annotations<Location, ElementAnnotation, CommentListImpl> annotations) throws ParseException {
        LocatedString locatedString = this.UnprefixedName();
        this.jj_consume_token(2);
        String string = this.Literal();
        if (locatedString.getString().equals("xmlns")) {
            this.error("xmlns_annotation_attribute", locatedString.getToken());
        } else {
            this.addAttribute(annotations, "", locatedString.getString(), null, string, locatedString.getToken());
        }
    }

    public final ElementAnnotation AnnotationElement(boolean bl) throws ParseException {
        ElementAnnotation ElementAnnotation;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                ElementAnnotation = this.PrefixedAnnotationElement(bl);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                ElementAnnotation = this.UnprefixedAnnotationElement();
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ElementAnnotation;
    }

    public final ElementAnnotation AnnotationElementNotKeyword() throws ParseException {
        ElementAnnotation ElementAnnotation;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                ElementAnnotation = this.PrefixedAnnotationElement(false);
                break;
            }
            case 54: 
            case 55: {
                ElementAnnotation = this.IdentifierAnnotationElement();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ElementAnnotation;
    }

    public final ElementAnnotation PrefixedAnnotationElement(boolean bl) throws ParseException {
        CommentListImpl CommentListImpl2 = this.getComments();
        Token token = this.jj_consume_token(57);
        String string = token.image;
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        String string3 = this.lookupPrefix(string2, token);
        if (string3 == SchemaBuilder.INHERIT_NS) {
            this.error("inherited_annotation_namespace", token);
            string3 = "";
        } else if (!bl && string3.equals("http://relaxng.org/ns/structure/1.0")) {
            this.error("relax_ng_namespace", token);
            string3 = "";
        } else if (string3.length() == 0) {
            string2 = null;
        }
        ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder(string3, string.substring(n + 1), string2, this.makeLocation(token), CommentListImpl2, this.getContext());
        this.AnnotationElementContent(elementAnnotationBuilder);
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final ElementAnnotation UnprefixedAnnotationElement() throws ParseException {
        CommentListImpl CommentListImpl2 = this.getComments();
        LocatedString locatedString = this.UnprefixedName();
        ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder("", locatedString.getString(), null, locatedString.getLocation(), CommentListImpl2, this.getContext());
        this.AnnotationElementContent(elementAnnotationBuilder);
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final ElementAnnotation IdentifierAnnotationElement() throws ParseException {
        CommentListImpl CommentListImpl2 = this.getComments();
        LocatedString locatedString = this.Identifier();
        ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder("", locatedString.getString(), null, locatedString.getLocation(), CommentListImpl2, this.getContext());
        this.AnnotationElementContent(elementAnnotationBuilder);
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final void AnnotationElementContent(ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> elementAnnotationBuilder) throws ParseException {
        block13: {
            this.jj_consume_token(1);
            this.clearAttributeList();
            while (this.jj_2_8(2)) {
                this.AnnotationAttribute(elementAnnotationBuilder);
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.AnnotationElementLiteral(elementAnnotationBuilder);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[64] = this.jj_gen;
                                    continue block11;
                                }
                            }
                            this.jj_consume_token(8);
                            this.AnnotationElementLiteral(elementAnnotationBuilder);
                        }
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: {
                        ElementAnnotation ElementAnnotation = this.AnnotationElement(true);
                        elementAnnotationBuilder.addElement(ElementAnnotation);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[65] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        elementAnnotationBuilder.addComment(this.getComments());
        this.jj_consume_token(9);
    }

    public final void AnnotationElementLiteral(ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> elementAnnotationBuilder) throws ParseException {
        CommentListImpl CommentListImpl2 = this.getComments();
        Token token = this.jj_consume_token(58);
        elementAnnotationBuilder.addText(CompactSyntax.unquote(token.image), this.makeLocation(token), CommentListImpl2);
    }

    public final String Literal() throws ParseException {
        Token token = this.jj_consume_token(58);
        String string = CompactSyntax.unquote(token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                StringBuffer stringBuffer = new StringBuffer(string);
                block6: while (true) {
                    this.jj_consume_token(8);
                    token = this.jj_consume_token(58);
                    stringBuffer.append(CompactSyntax.unquote(token.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[66] = this.jj_gen;
                string = stringBuffer.toString();
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        return string;
    }

    public final LocatedString LocatedLiteral() throws ParseException {
        Token token = this.jj_consume_token(58);
        String string = CompactSyntax.unquote(token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                StringBuffer stringBuffer = new StringBuffer(string);
                block6: while (true) {
                    this.jj_consume_token(8);
                    Token token2 = this.jj_consume_token(58);
                    stringBuffer.append(CompactSyntax.unquote(token2.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[68] = this.jj_gen;
                string = stringBuffer.toString();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        return new LocatedString(string, token);
    }

    public final Token Keyword() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                token = this.jj_consume_token(26);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            case 5: {
                token = this.jj_consume_token(5);
                break;
            }
            case 7: {
                token = this.jj_consume_token(7);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    private boolean jj_3R_49() {
        if (this.jj_3R_57()) {
            return true;
        }
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_40() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_48() {
        if (this.jj_3R_41()) {
            return true;
        }
        return this.jj_3R_56();
    }

    private boolean jj_3_3() {
        return this.jj_3R_29();
    }

    private boolean jj_3_6() {
        return this.jj_3R_29();
    }

    private boolean jj_3_2() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_58() {
        return this.jj_3R_57();
    }

    private boolean jj_3_5() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_62() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(27)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(13)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(31)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(32)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(10)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(17)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(18)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(34)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(33)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(19)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(5)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(7)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(14)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(15)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(35)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(36)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(16)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(6)) {
                                                                                    return true;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_60() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_57() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = token;
            if (this.jj_3R_61()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_46() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_52() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(57)) {
            this.jj_scanpos = token;
            if (this.jj_3R_58()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(2)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(58)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(8)) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_59()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        Token token;
        if (this.jj_scan_token(1)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_52());
        this.jj_scanpos = token;
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_31() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = token;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_39() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_55() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(43)) {
                return true;
            }
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(41));
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_45() {
        Token token;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_55());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3_7() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_42() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(6)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(7)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_54() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_44() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = token;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        if (this.jj_3R_41()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(2)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(3)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(4)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_41() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = token;
            if (this.jj_3R_51()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_47() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_3R_56();
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_45()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_44();
    }

    private boolean jj_3R_35() {
        if (this.jj_3R_43()) {
            return true;
        }
        return this.jj_3R_44();
    }

    private boolean jj_3R_34() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_33() {
        if (this.jj_3R_41()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(2)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(3)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(4)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_scan_token(1);
    }

    private boolean jj_3R_28() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = token;
            if (this.jj_3R_33()) {
                this.jj_scanpos = token;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_36()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_38() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_59() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_37() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_29() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = token;
            if (this.jj_3R_38()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        return this.jj_3R_31();
    }

    private boolean jj_3_4() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(1);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-1676803070, 30, 2, 226, 28, 224, 224, 0, 0, 0, -1945115162, -1945115162, 1026, 90112, 90112, -1945115424, 24576, 32768, 0, -1676803072, 0x100000, 0x200000, 0x400000, 0x700000, 0x700000, 0x3800000, 0, 0x3800000, -1643125536, 0, 0x100000, 0x100000, -1643125536, -1676679968, 0x2000000, 0x40000000, 0x40000000, 226, 224, 32, 28, 2048, 98, 96, 32768, 0x40000000, 0x40000000, 2048, 0, 0, 0, -1945115424, -1945115424, -1945115422, 0, 0, 0, 0, -1945115424, 2, -1945115424, -1945115424, 0, -1945115424, 256, -1945115424, 256, 256, 256, 256, -1945115424};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{113248543, 0, 0, 46139648, 0, 0xC00000, 0, 2304, 512, 2304, 113246239, 113246239, 2304, 0, 0, 12582943, 0, 0x4000000, 0x8000000, 113246239, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 62914591, 0x8000000, 0, 0, 62914591, 46137375, 0x1000000, 0, 0, 0xC00900, 0xC00000, 0xC00000, 0, 0, 0xC00900, 0xC00000, 0, 0, 0, 0, 0x4000000, 33554456, 0xC00000, 12582943, 12582943, 12585247, 2304, 512, 2304, 2304, 46137375, 0, 46137375, 46137375, 0x2C00000, 113246239, 0, 113246239, 0, 0, 0, 0, 31};
    }

    public CompactSyntax(InputStream inputStream) {
        this(inputStream, null);
    }

    public CompactSyntax(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new CompactSyntaxTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 71; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 71; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public CompactSyntax(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new CompactSyntaxTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 71; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 71; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public CompactSyntax(CompactSyntaxTokenManager compactSyntaxTokenManager) {
        int n;
        this.token_source = compactSyntaxTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 71; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(CompactSyntaxTokenManager compactSyntaxTokenManager) {
        int n;
        this.token_source = compactSyntaxTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 71; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[61];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 71; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 61; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        CompactSyntax.jj_la1_init_0();
        CompactSyntax.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LocatedString {
        private final String str;
        private final Token tok;

        LocatedString(String string, Token token) {
            this.str = string;
            this.tok = token;
        }

        String getString() {
            return this.str;
        }

        Location getLocation() {
            return CompactSyntax.this.makeLocation(this.tok);
        }

        Token getToken() {
            return this.tok;
        }
    }
}

