use strict;
use warnings;

package Task::Badge::Depot;

# ABSTRACT: All Badge::Depot badges
our $AUTHORITY = 'cpan:CSSON'; # AUTHORITY
our $VERSION = '0.0102';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::Badge::Depot - All Badge::Depot badges



=begin html

<p>
<img src="https://img.shields.io/badge/perl-5.10+-blue.svg" alt="Requires Perl 5.10+" />
<a href="https://travis-ci.org/Csson/p5-Task-Badge-Depot"><img src="https://api.travis-ci.org/Csson/p5-Task-Badge-Depot.svg?branch=master" alt="Travis status" /></a>
<a href="http://cpants.cpanauthors.org/dist/Task-Badge-Depot-0.0102"><img src="https://badgedepot.code301.com/badge/kwalitee/Task-Badge-Depot/0.0102" alt="Distribution kwalitee" /></a>
<a href="http://matrix.cpantesters.org/?dist=Task-Badge-Depot%200.0102"><img src="https://badgedepot.code301.com/badge/cpantesters/Task-Badge-Depot/0.0102" alt="CPAN Testers result" /></a>
</p>

=end html

=head1 VERSION

Version 0.0102, released 2016-02-22.

=head1 TASK CONTENTS

=head2 Badge::Depot, with badges

=head3 L<Badge::Depot> 0.0104

=head3 L<Badge::Depot::Plugin::Coverage> 0.0101

=head3 L<Badge::Depot::Plugin::Cpantesters> 0.0101

=head3 L<Badge::Depot::Plugin::Gratipay> 0.0102

=head3 L<Badge::Depot::Plugin::Kwalitee> 0.0101

=head3 L<Badge::Depot::Plugin::Perl> 0.0103

=head3 L<Badge::Depot::Plugin::Travis> 0.0202

=head1 SOURCE

L<https://github.com/Csson/p5-Task-Badge-Depot>

=head1 HOMEPAGE

L<https://metacpan.org/release/Task-Badge-Depot>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
