package Amazon::MWS::Enumeration::Schedule;

use strict;
use warnings;

use base qw(Amazon::MWS::Enumeration);

__PACKAGE__->define qw(
    _15_MINUTES_
    _30_MINUTES_
    _1_HOUR_
    _2_HOURS_
    _4_HOURS_
    _8_HOURS_
    _12_HOURS_
    _1_DAY_
    _2_DAYS_
    _72_HOURS_
    _7_DAYS_
    _14_DAYS_
    _15_DAYS_
    _30_DAYS_
    _NEVER_
);

1;

__END__

=head1 NAME

Amazon::MWS::Enumeration::Schedule

=head1 CONSTANTS

=over 4

=item _15_MINUTES_

=item _30_MINUTES_

=item _1_HOUR_

=item _2_HOURS_

=item _4_HOURS_

=item _8_HOURS_

=item _12_HOURS_

=item _1_DAY_

=item _2_DAYS_

=item _72_HOURS_

=item _7_DAYS_

=item _14_DAYS_

=item _15_DAYS_

=item _30_DAYS_

=item _NEVER_

=back

=head1 SEE ALSO

L<Amazon::MWS::Enumeration>

=head1 AUTHOR

Paul Driver C<< frodwith@cpan.org >>

=head1 LICENCE AND COPYRIGHT

Copyright (c) 2009, Plain Black Corporation L<http://plainblack.com>.
All rights reserved

This module is free software; you can redistribute it and/or modify it under
the same terms as Perl itself.  See L<perlartistic>.
