/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.speciation.CalibrationPoints;
import dr.evomodel.speciation.UltrametricSpeciationModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.special.Gamma;

public class BirthDeathGernhard08Model
extends UltrametricSpeciationModel
implements Citable {
    public static final String BIRTH_DEATH_MODEL = "birthDeathModel";
    private Parameter relativeDeathRateParameter;
    private Parameter birthDiffRateParameter;
    private Parameter sampleProbability;
    private TreeType type;
    private boolean conditionalOnRoot;

    public BirthDeathGernhard08Model(Parameter parameter, Parameter parameter2, Parameter parameter3, TreeType treeType, Units.Type type) {
        this(BIRTH_DEATH_MODEL, parameter, parameter2, parameter3, treeType, type, false);
    }

    public BirthDeathGernhard08Model(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, TreeType treeType, Units.Type type, boolean bl) {
        super(string, type);
        this.birthDiffRateParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.relativeDeathRateParameter = parameter2;
        if (parameter2 != null) {
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        }
        this.sampleProbability = parameter3;
        if (parameter3 != null) {
            this.addVariable(parameter3);
            parameter3.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        }
        this.conditionalOnRoot = bl;
        if (bl && parameter3 != null) {
            throw new IllegalArgumentException("Not supported: birth death prior conditional on root with sampling probability.");
        }
        this.type = treeType;
    }

    @Override
    public boolean isYule() {
        return this.relativeDeathRateParameter == null && this.sampleProbability == null && !this.conditionalOnRoot;
    }

    @Override
    public double getMarginal(Tree tree, CalibrationPoints calibrationPoints) {
        return calibrationPoints.getCorrection(tree, this.getR());
    }

    public double getR() {
        return this.birthDiffRateParameter.getParameterValue(0);
    }

    public double getA() {
        return this.relativeDeathRateParameter != null ? this.relativeDeathRateParameter.getParameterValue(0) : 0.0;
    }

    public double getRho() {
        return this.sampleProbability != null ? this.sampleProbability.getParameterValue(0) : 1.0;
    }

    private double logCoeff(int n) {
        switch (this.type) {
            case UNSCALED: {
                break;
            }
            case TIMESONLY: {
                return Gamma.logGamma(n + 1);
            }
            case ORIENTED: {
                return Math.log(n);
            }
            case LABELED: {
                double d = (double)(n - 1) * Math.log(2.0);
                if (!this.conditionalOnRoot) {
                    return d - Gamma.logGamma(n);
                }
                return d - Math.log(n - 1) - Gamma.logGamma(n + 1);
            }
        }
        return 0.0;
    }

    @Override
    public double logTreeProbability(int n) {
        double d = this.logCoeff(n);
        if (!this.conditionalOnRoot) {
            d += (double)(n - 1) * Math.log(this.getR() * this.getRho()) + (double)n * Math.log(1.0 - this.getA());
        }
        return d;
    }

    @Override
    public double logNodeProbability(Tree tree, NodeRef nodeRef) {
        double d;
        double d2 = tree.getNodeHeight(nodeRef);
        double d3 = this.getR();
        double d4 = -d3 * d2;
        double d5 = this.getA();
        if (!this.conditionalOnRoot) {
            double d6 = this.getRho();
            double d7 = Math.log(d6 + (1.0 - d6 - d5) * Math.exp(d4));
            double d8 = -2.0 * d7 + d4;
            if (tree.getRoot() == nodeRef) {
                d8 += d4 - d7;
            }
            return d8;
        }
        if (tree.getRoot() != nodeRef) {
            double d9 = Math.log(1.0 - d5 * Math.exp(d4));
            d = -2.0 * d9 + d4;
        } else {
            double d10 = 1.0 - d5;
            double d11 = Math.exp(-d4);
            d = d11 != 1.0 ? (double)(tree.getTaxonCount() - 2) * Math.log(d3 * d10 * (1.0 + d10 / (d11 - 1.0))) : (double)(tree.getTaxonCount() - 2) * Math.log(d10 * (d3 + d10 / d2));
        }
        return d;
    }

    @Override
    public boolean includeExternalNodesInLikelihoodCalculation() {
        return false;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Gernhard 2008 Birth Death Tree Model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(new Citation(new Author[]{new Author("T", "Gernhard")}, "The conditioned reconstructed process", 2008, "Journal of Theoretical Biology", 253, 769, 778, "10.1016/j.jtbi.2008.04.005"));
    }

    public static enum TreeType {
        UNSCALED,
        TIMESONLY,
        ORIENTED,
        LABELED;

    }
}

