/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.DemographicFunction;
import jebl.evolution.coalescent.IntervalList;
import jebl.evolution.coalescent.Intervals;
import jebl.evolution.trees.RootedTree;
import jebl.math.Binomial;
import jebl.math.MultivariateFunction;
import jebl.math.OrthogonalHints;

public class Coalescent
implements MultivariateFunction {
    private final DemographicFunction demographicFunction;
    private final IntervalList intervals;

    public Coalescent(RootedTree tree, DemographicFunction demographicFunction) {
        this(new Intervals(tree), demographicFunction);
    }

    public Coalescent(IntervalList intervals, DemographicFunction demographicFunction) {
        this.intervals = intervals;
        this.demographicFunction = demographicFunction;
    }

    public double calculateLogLikelihood() {
        return Coalescent.calculateLogLikelihood(this.intervals, this.demographicFunction);
    }

    public static final double calculateLogLikelihood(IntervalList intervals, DemographicFunction demographicFunction) {
        double logL = 0.0;
        double startTime = 0.0;
        int n = intervals.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            double duration = intervals.getInterval(i);
            double finishTime = startTime + duration;
            double intervalArea = demographicFunction.getIntegral(startTime, finishTime);
            int lineageCount = intervals.getLineageCount(i);
            logL = intervals.getIntervalType(i) == IntervalList.IntervalType.COALESCENT ? (logL += -Math.log(demographicFunction.getDemographic(finishTime)) - Binomial.choose2(lineageCount) * intervalArea) : (logL += -(Binomial.choose2(lineageCount) * intervalArea));
            startTime = finishTime;
        }
        return logL;
    }

    public static final double calculateAnalyticalLogLikelihood(IntervalList intervals) {
        if (!intervals.isCoalescentOnly()) {
            throw new IllegalArgumentException("Can only calculate analytical likelihood for pure coalescent intervals");
        }
        double lambda = Coalescent.getLambda(intervals);
        int n = intervals.getSampleCount();
        double logL = 0.0;
        logL = Math.log(1.0 / Math.pow(lambda, n - 1));
        return logL;
    }

    private static final double getLambda(IntervalList intervals) {
        double lambda = 0.0;
        for (int i = 0; i < intervals.getIntervalCount(); ++i) {
            lambda += intervals.getInterval(i) * (double)intervals.getLineageCount(i);
        }
        return lambda /= 2.0;
    }

    public double evaluate(double[] argument) {
        for (int i = 0; i < argument.length; ++i) {
            this.demographicFunction.setArgument(i, argument[i]);
        }
        return this.calculateLogLikelihood();
    }

    public int getNumArguments() {
        return this.demographicFunction.getArgumentCount();
    }

    public double getLowerBound(int n) {
        return this.demographicFunction.getLowerBound(n);
    }

    public double getUpperBound(int n) {
        return this.demographicFunction.getUpperBound(n);
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }
}

