/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.ejml.UtilEjml;
import org.ejml.data.CMatrix;
import org.ejml.data.CMatrixRMaj;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixIterator;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.data.SingularMatrixException;
import org.ejml.data.ZMatrix;
import org.ejml.data.ZMatrixRMaj;
import org.ejml.equation.Equation;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.AutomaticSimpleMatrixConvert;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleOperations;
import org.ejml.simple.SimpleSVD;
import org.ejml.simple.ops.SimpleOperations_CDRM;
import org.ejml.simple.ops.SimpleOperations_DDRM;
import org.ejml.simple.ops.SimpleOperations_FDRM;
import org.ejml.simple.ops.SimpleOperations_SPARSE;
import org.ejml.simple.ops.SimpleOperations_ZDRM;

public abstract class SimpleBase<T extends SimpleBase<T>>
implements Serializable {
    static final long serialVersionUID = 2342556642L;
    protected Matrix mat;
    protected SimpleOperations ops;
    protected AutomaticSimpleMatrixConvert convertType = new AutomaticSimpleMatrixConvert();

    public SimpleBase(int numRows, int numCols) {
        this.setMatrix((Matrix)new DMatrixRMaj(numRows, numCols));
    }

    protected SimpleBase() {
    }

    protected abstract T createMatrix(int var1, int var2, MatrixType var3);

    protected abstract T wrapMatrix(Matrix var1);

    public <T extends Matrix> T getMatrix() {
        return (T)this.mat;
    }

    public DMatrixRMaj getDDRM() {
        return (DMatrixRMaj)this.mat;
    }

    public FMatrixRMaj getFDRM() {
        return (FMatrixRMaj)this.mat;
    }

    public ZMatrixRMaj getZDRM() {
        return (ZMatrixRMaj)this.mat;
    }

    public CMatrixRMaj getCDRM() {
        return (CMatrixRMaj)this.mat;
    }

    public DMatrixSparseCSC getDSCC() {
        return (DMatrixSparseCSC)this.mat;
    }

    public FMatrixSparseCSC getFSCC() {
        return (FMatrixSparseCSC)this.mat;
    }

    protected static SimpleOperations lookupOps(MatrixType type) {
        switch (type) {
            case DDRM: {
                return new SimpleOperations_DDRM();
            }
            case FDRM: {
                return new SimpleOperations_FDRM();
            }
            case ZDRM: {
                return new SimpleOperations_ZDRM();
            }
            case CDRM: {
                return new SimpleOperations_CDRM();
            }
            case DSCC: {
                return new SimpleOperations_SPARSE();
            }
        }
        throw new RuntimeException("Unknown Matrix Type. " + type);
    }

    public T transpose() {
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows(), this.mat.getType());
        this.ops.transpose(this.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T mult(T B) {
        this.convertType.specify(new SimpleBase[]{this, B});
        Object A = this.convertType.convert(this);
        B = this.convertType.convert((SimpleBase)B);
        T ret = ((SimpleBase)A).createMatrix(this.mat.getNumRows(), ((SimpleBase)B).getMatrix().getNumCols(), ((SimpleBase)A).getType());
        ((SimpleBase)A).ops.mult(((SimpleBase)A).mat, ((SimpleBase)B).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T kron(T B) {
        this.convertType.specify(new SimpleBase[]{this, B});
        Object A = this.convertType.convert(this);
        B = this.convertType.convert((SimpleBase)B);
        T ret = ((SimpleBase)A).createMatrix(this.mat.getNumRows() * ((SimpleBase)B).numRows(), this.mat.getNumCols() * ((SimpleBase)B).numCols(), ((SimpleBase)A).getType());
        ((SimpleBase)A).ops.kron(((SimpleBase)A).mat, ((SimpleBase)B).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T plus(T B) {
        this.convertType.specify(new SimpleBase[]{this, B});
        Object A = this.convertType.convert(this);
        B = this.convertType.convert((SimpleBase)B);
        T ret = ((SimpleBase)A).createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), ((SimpleBase)A).getType());
        ((SimpleBase)A).ops.plus(((SimpleBase)A).mat, ((SimpleBase)B).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T minus(T B) {
        this.convertType.specify(new SimpleBase[]{this, B});
        Object A = this.convertType.convert(this);
        B = this.convertType.convert((SimpleBase)B);
        T ret = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.minus(((SimpleBase)A).mat, ((SimpleBase)B).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T minus(double b) {
        T ret = this.createLike();
        this.ops.minus(this.mat, b, ((SimpleBase)ret).mat);
        return ret;
    }

    public T plus(double b) {
        T ret = this.createLike();
        this.ops.plus(this.mat, b, ((SimpleBase)ret).mat);
        return ret;
    }

    public T plus(double beta, T B) {
        this.convertType.specify(new SimpleBase[]{this, B});
        Object A = this.convertType.convert(this);
        B = this.convertType.convert((SimpleBase)B);
        T ret = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.plus(((SimpleBase)A).mat, beta, ((SimpleBase)B).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public double dot(T v) {
        this.convertType.specify(new SimpleBase[]{this, v});
        Object A = this.convertType.convert(this);
        v = this.convertType.convert((SimpleBase)v);
        if (!this.isVector()) {
            throw new IllegalArgumentException("'this' matrix is not a vector.");
        }
        if (!((SimpleBase)v).isVector()) {
            throw new IllegalArgumentException("'v' matrix is not a vector.");
        }
        return ((SimpleBase)A).ops.dot(((SimpleBase)A).mat, ((SimpleBase)v).getMatrix());
    }

    public boolean isVector() {
        return this.mat.getNumRows() == 1 || this.mat.getNumCols() == 1;
    }

    public T scale(double val) {
        T ret = this.createLike();
        this.ops.scale(this.mat, val, ((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T divide(double val) {
        T ret = this.createLike();
        this.ops.divide(this.mat, val, ((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T invert() {
        T ret = this.createLike();
        if (!this.ops.invert(this.mat, ((SimpleBase)ret).mat)) {
            throw new SingularMatrixException();
        }
        if (this.ops.hasUncountable(((SimpleBase)ret).mat)) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return ret;
    }

    public T pseudoInverse() {
        T ret = this.createLike();
        this.ops.pseudoInverse(this.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T solve(T b) {
        this.convertType.specify(new SimpleBase[]{this, b});
        Object A = this.convertType.convert(this);
        b = this.convertType.convert((SimpleBase)b);
        T x = ((SimpleBase)A).createMatrix(this.mat.getNumCols(), ((SimpleBase)b).getMatrix().getNumCols(), ((SimpleBase)A).getType());
        if (!((SimpleBase)A).ops.solve(((SimpleBase)A).mat, ((SimpleBase)x).mat, ((SimpleBase)b).mat)) {
            throw new SingularMatrixException();
        }
        if (((SimpleBase)A).ops.hasUncountable(((SimpleBase)x).mat)) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return x;
    }

    public void set(T a) {
        if (((SimpleBase)a).getType() == this.getType()) {
            this.mat.set(((SimpleBase)a).getMatrix());
        } else {
            this.setMatrix(((SimpleBase)a).mat.copy());
        }
    }

    public void fill(double val) {
        this.ops.fill(this.mat, val);
    }

    public void zero() {
        this.fill(0.0);
    }

    public double normF() {
        return this.ops.normF(this.mat);
    }

    public double conditionP2() {
        return this.ops.conditionP2(this.mat);
    }

    public double determinant() {
        double ret = this.ops.determinant(this.mat);
        if (UtilEjml.isUncountable((double)ret)) {
            return 0.0;
        }
        return ret;
    }

    public double trace() {
        return this.ops.trace(this.mat);
    }

    public void reshape(int numRows, int numCols) {
        if (this.mat.getType().isFixed()) {
            throw new IllegalArgumentException("Can't reshape a fixed sized matrix");
        }
        ((ReshapeMatrix)this.mat).reshape(numRows, numCols);
    }

    public void set(int row, int col, double value) {
        this.ops.set(this.mat, row, col, value);
    }

    public void set(int index, double value) {
        if (this.mat.getType() == MatrixType.DDRM) {
            ((DMatrixRMaj)this.mat).set(index, value);
        } else if (this.mat.getType() == MatrixType.FDRM) {
            ((FMatrixRMaj)this.mat).set(index, (float)value);
        } else {
            throw new RuntimeException("Not supported yet for this matrix type");
        }
    }

    public void set(int row, int col, double real, double imaginary) {
        if (imaginary == 0.0) {
            this.set(row, col, real);
        } else {
            this.ops.set(this.mat, row, col, real, imaginary);
        }
    }

    public void setRow(int row, int startColumn, double ... values) {
        this.ops.setRow(this.mat, row, startColumn, values);
    }

    public void setColumn(int column, int startRow, double ... values) {
        this.ops.setColumn(this.mat, column, startRow, values);
    }

    public double get(int row, int col) {
        return this.ops.get(this.mat, row, col);
    }

    public double get(int index) {
        MatrixType type = this.mat.getType();
        if (type.isReal()) {
            if (type.getBits() == 64) {
                return ((DMatrixRMaj)this.mat).data[index];
            }
            return ((FMatrixRMaj)this.mat).data[index];
        }
        throw new IllegalArgumentException("Complex matrix. Call get(int,Complex64F) instead");
    }

    public void get(int row, int col, Complex_F64 output) {
        this.ops.get(this.mat, row, col, output);
    }

    public int getIndex(int row, int col) {
        return row * this.mat.getNumCols() + col;
    }

    public DMatrixIterator iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new DMatrixIterator((DMatrixD1)((DMatrixRMaj)this.mat), rowMajor, minRow, minCol, maxRow, maxCol);
    }

    public T copy() {
        T ret = this.createLike();
        ((SimpleBase)ret).getMatrix().set(this.getMatrix());
        return ret;
    }

    public int numRows() {
        return this.mat.getNumRows();
    }

    public int numCols() {
        return this.mat.getNumCols();
    }

    public int getNumElements() {
        return this.mat.getNumCols() * this.mat.getNumRows();
    }

    public void print() {
        this.ops.print(System.out, this.mat);
    }

    public void print(int numChar, int precision) {
        switch (this.mat.getType()) {
            case DDRM: {
                MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat), (int)numChar, (int)precision);
                break;
            }
            case FDRM: {
                MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat), (int)numChar, (int)precision);
                break;
            }
            case ZDRM: {
                MatrixIO.print((PrintStream)System.out, (ZMatrix)((ZMatrixRMaj)this.mat), (int)numChar, (int)precision);
                break;
            }
            case CDRM: {
                MatrixIO.print((PrintStream)System.out, (CMatrix)((CMatrixRMaj)this.mat), (int)numChar, (int)precision);
                break;
            }
            case DSCC: {
                MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixSparseCSC)this.mat), (int)numChar, (int)precision);
                break;
            }
            case FSCC: {
                MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixSparseCSC)this.mat), (int)numChar, (int)precision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown matrix type");
            }
        }
    }

    public void print(String format) {
        switch (this.mat.getType()) {
            case DDRM: {
                MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat), (String)format);
                break;
            }
            case FDRM: {
                MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat), (String)format);
                break;
            }
            case ZDRM: {
                MatrixIO.print((PrintStream)System.out, (ZMatrix)((ZMatrixRMaj)this.mat), (String)format);
                break;
            }
            case CDRM: {
                MatrixIO.print((PrintStream)System.out, (CMatrix)((CMatrixRMaj)this.mat), (String)format);
                break;
            }
            case DSCC: {
                MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixSparseCSC)this.mat), (String)format);
                break;
            }
            case FSCC: {
                MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixSparseCSC)this.mat), (String)format);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown matrix type");
            }
        }
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(stream);
        switch (this.mat.getType()) {
            case DDRM: {
                MatrixIO.print((PrintStream)p, (DMatrix)((DMatrixRMaj)this.mat));
                break;
            }
            case FDRM: {
                MatrixIO.print((PrintStream)p, (FMatrix)((FMatrixRMaj)this.mat));
                break;
            }
            case ZDRM: {
                MatrixIO.print((PrintStream)p, (ZMatrix)((ZMatrixRMaj)this.mat));
                break;
            }
            case CDRM: {
                MatrixIO.print((PrintStream)p, (CMatrix)((CMatrixRMaj)this.mat));
                break;
            }
            case DSCC: {
                MatrixIO.print((PrintStream)p, (DMatrix)((DMatrixSparseCSC)this.mat));
                break;
            }
            case FSCC: {
                MatrixIO.print((PrintStream)p, (FMatrix)((FMatrixSparseCSC)this.mat));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown matrix type");
            }
        }
        return stream.toString();
    }

    public T extractMatrix(int y0, int y1, int x0, int x1) {
        if (y0 == Integer.MAX_VALUE) {
            y0 = this.mat.getNumRows();
        }
        if (y1 == Integer.MAX_VALUE) {
            y1 = this.mat.getNumRows();
        }
        if (x0 == Integer.MAX_VALUE) {
            x0 = this.mat.getNumCols();
        }
        if (x1 == Integer.MAX_VALUE) {
            x1 = this.mat.getNumCols();
        }
        T ret = this.createMatrix(y1 - y0, x1 - x0, this.mat.getType());
        this.ops.extract(this.mat, y0, y1, x0, x1, ((SimpleBase)ret).mat, 0, 0);
        return ret;
    }

    public T extractVector(boolean extractRow, int element) {
        if (extractRow) {
            return this.extractMatrix(element, element + 1, 0, Integer.MAX_VALUE);
        }
        return this.extractMatrix(0, Integer.MAX_VALUE, element, element + 1);
    }

    public T diag() {
        return this.wrapMatrix(this.ops.diag(this.mat));
    }

    public boolean isIdentical(T a, double tol) {
        if (((SimpleBase)a).getType() != this.getType()) {
            return false;
        }
        return this.ops.isIdentical(this.mat, ((SimpleBase)a).mat, tol);
    }

    public boolean hasUncountable() {
        return this.ops.hasUncountable(this.mat);
    }

    public SimpleSVD<T> svd() {
        return new SimpleSVD(this.mat, false);
    }

    public SimpleSVD<T> svd(boolean compact) {
        return new SimpleSVD(this.mat, compact);
    }

    public SimpleEVD<T> eig() {
        return new SimpleEVD(this.mat);
    }

    public void insertIntoThis(int insertRow, int insertCol, T B) {
        this.convertType.specify(new SimpleBase[]{this, B});
        B = this.convertType.convert((SimpleBase)B);
        if (this.convertType.commonType == this.getType()) {
            this.insert(((SimpleBase)B).mat, this.mat, insertRow, insertCol);
        } else {
            Object A = this.convertType.convert(this);
            ((SimpleBase)A).insert(((SimpleBase)B).mat, ((SimpleBase)A).mat, insertRow, insertCol);
            this.setMatrix(((SimpleBase)A).mat);
        }
    }

    void insert(Matrix src, Matrix dst, int destY0, int destX0) {
        this.ops.extract(src, 0, src.getNumRows(), 0, src.getNumCols(), dst, destY0, destX0);
    }

    public T combine(int insertRow, int insertCol, T B) {
        T ret;
        this.convertType.specify(new SimpleBase[]{this, B});
        Object A = this.convertType.convert(this);
        B = this.convertType.convert((SimpleBase)B);
        if (insertRow == Integer.MAX_VALUE) {
            insertRow = this.mat.getNumRows();
        }
        if (insertCol == Integer.MAX_VALUE) {
            insertCol = this.mat.getNumCols();
        }
        int maxRow = insertRow + ((SimpleBase)B).numRows();
        int maxCol = insertCol + ((SimpleBase)B).numCols();
        if (maxRow > this.mat.getNumRows() || maxCol > this.mat.getNumCols()) {
            int M = Math.max(maxRow, this.mat.getNumRows());
            int N = Math.max(maxCol, this.mat.getNumCols());
            ret = ((SimpleBase)A).createMatrix(M, N, ((SimpleBase)A).getType());
            ((SimpleBase)ret).insertIntoThis(0, 0, A);
        } else {
            ret = ((SimpleBase)A).copy();
        }
        ((SimpleBase)ret).insertIntoThis(insertRow, insertCol, B);
        return ret;
    }

    public double elementMaxAbs() {
        return this.ops.elementMaxAbs(this.mat);
    }

    public double elementSum() {
        return this.ops.elementSum(this.mat);
    }

    public T elementMult(T b) {
        this.convertType.specify(new SimpleBase[]{this, b});
        Object A = this.convertType.convert(this);
        b = this.convertType.convert((SimpleBase)b);
        T c = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.elementMult(((SimpleBase)A).mat, ((SimpleBase)b).mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementDiv(T b) {
        this.convertType.specify(new SimpleBase[]{this, b});
        Object A = this.convertType.convert(this);
        b = this.convertType.convert((SimpleBase)b);
        T c = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.elementDiv(((SimpleBase)A).mat, ((SimpleBase)b).mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementPower(T b) {
        this.convertType.specify(new SimpleBase[]{this, b});
        Object A = this.convertType.convert(this);
        b = this.convertType.convert((SimpleBase)b);
        T c = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.elementPower(((SimpleBase)A).mat, ((SimpleBase)b).mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementPower(double b) {
        T c = this.createLike();
        this.ops.elementPower(this.mat, b, ((SimpleBase)c).mat);
        return c;
    }

    public T elementExp() {
        T c = this.createLike();
        this.ops.elementExp(this.mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementLog() {
        T c = this.createLike();
        this.ops.elementLog(this.mat, ((SimpleBase)c).mat);
        return c;
    }

    public T negative() {
        T A = this.copy();
        this.ops.changeSign(((SimpleBase)A).mat);
        return A;
    }

    public void equation(String equation, Object ... variables) {
        if (variables.length >= 25) {
            throw new IllegalArgumentException("Too many variables!  At most 25");
        }
        if (!(this.mat instanceof DMatrixRMaj)) {
            return;
        }
        Equation eq = new Equation();
        String nameThis = "A";
        int offset = 0;
        if (variables.length > 0 && variables[0] instanceof String) {
            nameThis = (String)variables[0];
            offset = 1;
            if (variables.length % 2 != 1) {
                throw new IllegalArgumentException("Expected and odd length for variables");
            }
        } else if (variables.length % 2 != 0) {
            throw new IllegalArgumentException("Expected and even length for variables");
        }
        eq.alias((DMatrixRMaj)this.mat, nameThis);
        for (int i = offset; i < variables.length; i += 2) {
            if (!(variables[i + 1] instanceof String)) {
                throw new IllegalArgumentException("String expected at variables index " + i);
            }
            Object o = variables[i];
            String name = (String)variables[i + 1];
            if (SimpleBase.class.isAssignableFrom(o.getClass())) {
                eq.alias(((SimpleBase)o).getDDRM(), name);
                continue;
            }
            if (o instanceof DMatrixRMaj) {
                eq.alias((DMatrixRMaj)o, name);
                continue;
            }
            if (o instanceof Double) {
                eq.alias((Double)o, name);
                continue;
            }
            if (o instanceof Integer) {
                eq.alias((Integer)o, name);
                continue;
            }
            String type = o == null ? "null" : o.getClass().getSimpleName();
            throw new IllegalArgumentException("Variable type not supported by Equation! " + type);
        }
        if (!equation.contains("=")) {
            equation = nameThis + " = " + equation;
        }
        eq.process(equation);
    }

    public void saveToFileBinary(String fileName) throws IOException {
        MatrixIO.saveBin((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    public static SimpleMatrix loadBinary(String fileName) throws IOException {
        DMatrix mat = MatrixIO.loadBin((String)fileName);
        if (mat instanceof DMatrixRMaj) {
            return SimpleMatrix.wrap((Matrix)((DMatrixRMaj)mat));
        }
        return SimpleMatrix.wrap((Matrix)new DMatrixRMaj(mat));
    }

    public void saveToFileCSV(String fileName) throws IOException {
        MatrixIO.saveDenseCSV((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    public T loadCSV(String fileName) throws IOException {
        DMatrix mat = MatrixIO.loadCSV((String)fileName, (boolean)true);
        T ret = this.createMatrix(1, 1, mat.getType());
        ((SimpleBase)ret).setMatrix((Matrix)mat);
        return ret;
    }

    public boolean isInBounds(int row, int col) {
        return row >= 0 && col >= 0 && row < this.mat.getNumRows() && col < this.mat.getNumCols();
    }

    public void printDimensions() {
        System.out.println("[rows = " + this.numRows() + " , cols = " + this.numCols() + " ]");
    }

    public int bits() {
        return this.mat.getType().getBits();
    }

    public T concatColumns(SimpleBase ... matrices) {
        this.convertType.specify0(this, matrices);
        Object A = this.convertType.convert(this);
        int numCols = ((SimpleBase)A).numCols();
        int numRows = ((SimpleBase)A).numRows();
        for (int i = 0; i < matrices.length; ++i) {
            numRows = Math.max(numRows, matrices[i].numRows());
            numCols += matrices[i].numCols();
        }
        SimpleMatrix combined = SimpleMatrix.wrap(this.convertType.commonType.create(numRows, numCols));
        ((SimpleBase)A).ops.extract(((SimpleBase)A).mat, 0, ((SimpleBase)A).numRows(), 0, ((SimpleBase)A).numCols(), combined.mat, 0, 0);
        int col = ((SimpleBase)A).numCols();
        for (int i = 0; i < matrices.length; ++i) {
            Matrix m = ((SimpleBase)this.convertType.convert((SimpleBase)matrices[i])).mat;
            int cols = m.getNumCols();
            int rows = m.getNumRows();
            ((SimpleBase)A).ops.extract(m, 0, rows, 0, cols, combined.mat, 0, col);
            col += cols;
        }
        return (T)combined;
    }

    public T concatRows(SimpleBase ... matrices) {
        this.convertType.specify0(this, matrices);
        Object A = this.convertType.convert(this);
        int numCols = ((SimpleBase)A).numCols();
        int numRows = ((SimpleBase)A).numRows();
        for (int i = 0; i < matrices.length; ++i) {
            numRows += matrices[i].numRows();
            numCols = Math.max(numCols, matrices[i].numCols());
        }
        SimpleMatrix combined = SimpleMatrix.wrap(this.convertType.commonType.create(numRows, numCols));
        ((SimpleBase)A).ops.extract(((SimpleBase)A).mat, 0, ((SimpleBase)A).numRows(), 0, ((SimpleBase)A).numCols(), combined.mat, 0, 0);
        int row = ((SimpleBase)A).numRows();
        for (int i = 0; i < matrices.length; ++i) {
            Matrix m = ((SimpleBase)this.convertType.convert((SimpleBase)matrices[i])).mat;
            int cols = m.getNumCols();
            int rows = m.getNumRows();
            ((SimpleBase)A).ops.extract(m, 0, rows, 0, cols, combined.mat, row, 0);
            row += rows;
        }
        return (T)combined;
    }

    public T rows(int begin, int end) {
        return this.extractMatrix(begin, end, 0, Integer.MAX_VALUE);
    }

    public T cols(int begin, int end) {
        return this.extractMatrix(0, Integer.MAX_VALUE, begin, end);
    }

    public MatrixType getType() {
        return this.mat.getType();
    }

    public T createLike() {
        return this.createMatrix(this.numRows(), this.numCols(), this.getType());
    }

    protected void setMatrix(Matrix mat) {
        this.mat = mat;
        this.ops = SimpleBase.lookupOps(mat.getType());
    }
}

