/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLHierarchy;
import com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.vocabulary.DAML_OIL;

public class DAMLObjectPropertyImpl
extends DAMLPropertyImpl
implements DAMLObjectProperty {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new DAMLObjectPropertyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to DAMLObjectProperty");
        }

        public boolean canWrap(Node n, EnhGraph g) {
            return DAMLObjectPropertyImpl.hasType(n, g, DAML_OIL.ObjectProperty);
        }
    };
    private PropertyAccessor m_propInverseOf = new PropertyAccessorImpl(this.getVocabulary().inverseOf(), this);

    public DAMLObjectPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public void setIsTransitive(boolean transitive) {
        if (transitive) {
            this.addRDFType(this.getVocabulary().TransitiveProperty());
        } else {
            this.removeRDFType(this.getVocabulary().TransitiveProperty());
        }
    }

    public boolean isTransitive() {
        return this.hasRDFType(this.getVocabulary().TransitiveProperty()) || DAMLHierarchy.getInstance().isTransitiveProperty(this);
    }

    public void setIsUnambiguous(boolean unambiguous) {
        if (unambiguous) {
            this.addRDFType(this.getVocabulary().UnambiguousProperty());
        } else {
            this.removeRDFType(this.getVocabulary().UnambiguousProperty());
        }
    }

    public boolean isUnambiguous() {
        return this.hasRDFType(this.getVocabulary().UnambiguousProperty());
    }

    public PropertyAccessor prop_inverseOf() {
        return this.m_propInverseOf;
    }
}

