/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.fitness;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.fitness.CompositeFitness;
import net.sf.jclec.fitness.ISimpleFitness;
import net.sf.jclec.fitness.IValueFitness;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CompositeValueFitness
extends CompositeFitness
implements IValueFitness {
    protected static final XmlFormat<CompositeValueFitness> COMPOSITE_VALUE_FITNESS_XML = new XmlFormat<CompositeValueFitness>(CompositeValueFitness.class){

        @Override
        public void format(CompositeValueFitness compositeValueFitness, XmlElement xml) {
            xml.setAttribute("value", compositeValueFitness.value);
            xml.add(compositeValueFitness.components, "components", COMPONENTS_FITNESS_XML);
        }

        @Override
        public CompositeValueFitness parse(XmlElement xml) {
            CompositeValueFitness compositeValueFitness = (CompositeValueFitness)xml.object();
            compositeValueFitness.value = xml.getAttribute("value", 0.0);
            compositeValueFitness.components = (ISimpleFitness[])xml.get("components", COMPONENTS_FITNESS_XML);
            return compositeValueFitness;
        }

        @Override
        public String defaultName() {
            return "composite-value-fitness";
        }
    };
    private static final long serialVersionUID = 3258690996551104821L;
    protected double value;

    public CompositeValueFitness() {
    }

    public CompositeValueFitness(ISimpleFitness[] components) {
        super(components);
    }

    public CompositeValueFitness(ISimpleFitness[] components, double value) {
        super(components);
        this.setValue(value);
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double value) {
        this.value = value;
    }

    public IFitness copy() {
        int cl = this.components.length;
        ISimpleFitness[] comps = new ISimpleFitness[cl];
        int i = 0;
        while (i < cl) {
            comps[i] = (ISimpleFitness)this.components[i].copy();
            ++i;
        }
        double val = this.value;
        return new CompositeValueFitness(comps, val);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.appendSuper(super.hashCode());
        hcb.append(this.value);
        return hcb.toHashCode();
    }

    public boolean equals(Object oth) {
        if (oth instanceof CompositeValueFitness) {
            CompositeValueFitness coth = (CompositeValueFitness)oth;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(coth));
            eb.append(this.value, coth.value);
            return eb.isEquals();
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.appendSuper(super.toString());
        tsb.append("value", this.value);
        return tsb.toString();
    }
}

