/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    public static final int NOMINAL = 0;
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    private double[][] trueTransactions = null;
    private boolean[][] missing = null;
    private double[] emax;
    private double[] emin;
    private int nTrans;
    private int nInputs;
    private int nOutputs;
    private int nVars;
    private int nPartitionForNumericAttributes;
    private int[][] fakeTransactions = null;
    private double[] steps = null;
    private Hashtable<Integer, HashSet<Integer>> tidList = null;
    private InstanceSet IS = new InstanceSet();

    public myDataset(int nPartition) {
        this.nPartitionForNumericAttributes = nPartition > 0 ? nPartition : 1;
    }

    public double[][] getTrueTransactions() {
        return this.trueTransactions;
    }

    public int[][] getFakeTransactions() {
        return this.fakeTransactions;
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnTrans() {
        return this.nTrans;
    }

    public int getnVars() {
        return this.nVars;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readDataSet(String datasetFile) throws IOException {
        try {
            int i;
            this.IS.readSet(datasetFile, true);
            this.nTrans = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nOutputs = Attributes.getOutputNumAttributes();
            this.nVars = this.nInputs + this.nOutputs;
            this.trueTransactions = new double[this.nTrans][this.nVars];
            this.fakeTransactions = new int[this.nTrans][this.nVars];
            this.steps = new double[this.nVars];
            this.tidList = new Hashtable();
            this.missing = new boolean[this.nTrans][this.nVars];
            this.emax = new double[this.nVars];
            this.emin = new double[this.nVars];
            for (i = 0; i < this.nVars; ++i) {
                if (this.getAttributeType(i) != 0) {
                    this.emax[i] = this.getMaxValue(i);
                    this.emin[i] = this.getMinValue(i);
                    continue;
                }
                this.emin[i] = 0.0;
                this.emax[i] = this.getNumNominalValues(i) - 1;
            }
            for (i = 0; i < this.nVars; ++i) {
                this.steps[i] = (this.emax[i] - this.emin[i]) / (double)this.nPartitionForNumericAttributes;
            }
            for (i = 0; i < this.nTrans; ++i) {
                int j;
                Instance inst = this.IS.getInstance(i);
                int cnt_index = 1;
                for (j = 0; j < this.nInputs; ++j) {
                    this.trueTransactions[i][j] = this.IS.getInputNumericValue(i, j);
                    this.fakeTransactions[i][j] = this.recastTrueValue(this.trueTransactions[i][j], j, cnt_index);
                    this.addTIDToValueList(this.fakeTransactions[i][j], i);
                    cnt_index += this.getAttributeType(j) != 0 ? this.nPartitionForNumericAttributes : this.getNumNominalValues(j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    this.trueTransactions[i][j] = this.emin[j] - 1.0;
                    this.fakeTransactions[i][j] = 0;
                }
                int k = 0;
                while (k < this.nOutputs) {
                    this.trueTransactions[i][j] = this.IS.getOutputNumericValue(i, k);
                    this.fakeTransactions[i][j] = this.recastTrueValue(this.trueTransactions[i][j], j, cnt_index);
                    this.addTIDToValueList(this.fakeTransactions[i][j], i);
                    cnt_index += this.getAttributeType(j) != 0 ? this.nPartitionForNumericAttributes : this.getNumNominalValues(j);
                    ++k;
                    ++j;
                }
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    private int recastTrueValue(double true_value, int id_attr, int cnt_index) {
        int fake_value = (int)true_value;
        if (this.getAttributeType(id_attr) != 0) {
            int p;
            boolean stop = false;
            for (p = 0; p < this.nPartitionForNumericAttributes - 1 && !stop; ++p) {
                if (!(true_value >= this.emin[id_attr] + this.steps[id_attr] * (double)p) || !(true_value <= this.emin[id_attr] + this.steps[id_attr] * (double)(p + 1))) continue;
                fake_value = p;
                stop = true;
            }
            if (!stop) {
                fake_value = p;
            }
        }
        return fake_value + cnt_index;
    }

    private void addTIDToValueList(int value, int tid) {
        HashSet<Integer> lst = this.tidList.get(value);
        if (lst == null) {
            lst = new HashSet();
            this.tidList.put(value, lst);
        }
        lst.add(tid);
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnTrans();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nTrans; ++i) {
            int j;
            for (j = 1; j < this.nVars && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nVars) continue;
            ++tam;
        }
        return tam;
    }

    public boolean[] getMissing(int pos) {
        return this.missing[pos];
    }

    public ArrayList<Integer> getIDsOfAllAttributeValues() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int a = 0; a < this.nVars; ++a) {
            int num_values = this.getAttributeType(a) != 0 ? this.nPartitionForNumericAttributes : this.getNumNominalValues(a);
            for (int v = 0; v < num_values; ++v) {
                ids.add(v * this.nVars + a);
            }
        }
        return ids;
    }

    public double[] getSteps() {
        return this.steps;
    }

    public Hashtable<Integer, HashSet<Integer>> getTIDList() {
        return this.tidList;
    }

    public String getAttributeName(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getName();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getName();
    }

    public int getAttributeType(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getType();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getType();
    }

    public String getNominalValue(int id_attr, int id_val) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getNominalValue(id_val);
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getNominalValue(id_val);
    }

    private double getMaxValue(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getMaxAttribute();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getMaxAttribute();
    }

    private double getMinValue(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getMinAttribute();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getMinAttribute();
    }

    private int getNumNominalValues(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getNumNominalValues();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getNumNominalValues();
    }
}

