/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.niching;

import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.algorithm.niching.NichingAlgorithm;
import net.sf.jclec.fitness.IValueFitness;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clearing<I extends IIndividual>
extends NichingAlgorithm<I> {
    protected int kappa;
    protected boolean minimize = false;
    private static final long serialVersionUID = -5042241420325727708L;

    public final int getKappa() {
        return this.kappa;
    }

    public final void setKappa(int kappa) {
        this.kappa = kappa;
    }

    public final boolean isMinimize() {
        return this.minimize;
    }

    public final void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        int kappa = configuration.getInt("kappa", 2);
        this.setKappa(kappa);
        boolean minimize = configuration.getBoolean("minimize", false);
        this.setMinimize(minimize);
    }

    @Override
    protected void createNiches() {
        int numberOfIndividuals = 0;
        int bsetSize = this.bset.size();
        List aux = this.bettersSelector.select(this.bset, bsetSize);
        for (IIndividual ind : aux) {
            IIndividual indCopy = ind.copy();
            indCopy.setFitness(ind.getFitness().copy());
            this.nset.add(indCopy);
        }
        double radiusOfNiche = this.calculateNicheRadius();
        int[] sample = new int[bsetSize];
        if (this.minimize) {
            int i = 0;
            while (i < bsetSize) {
                if (((IValueFitness)((IIndividual)this.nset.get(i)).getFitness()).getValue() < Double.POSITIVE_INFINITY && !this.checkConsideredIndividuals(i, numberOfIndividuals, sample)) {
                    int numberOfWinners = 1;
                    sample[numberOfIndividuals] = i;
                    ++numberOfIndividuals;
                    int j = i + 1;
                    while (j < bsetSize) {
                        if (((IValueFitness)((IIndividual)this.nset.get(j)).getFitness()).getValue() < Double.POSITIVE_INFINITY && ((IIndividual)this.nset.get(i)).distance((IIndividual)this.nset.get(j)) < radiusOfNiche) {
                            if (numberOfWinners < this.kappa) {
                                if (!this.checkConsideredIndividuals(j, numberOfIndividuals, sample)) {
                                    ++numberOfWinners;
                                    sample[numberOfIndividuals] = j;
                                    ++numberOfIndividuals;
                                }
                            } else {
                                ((IValueFitness)((IIndividual)this.nset.get(j)).getFitness()).setValue(Double.POSITIVE_INFINITY);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < bsetSize) {
                if (((IValueFitness)((IIndividual)this.nset.get(i)).getFitness()).getValue() > -1.0 && !this.checkConsideredIndividuals(i, numberOfIndividuals, sample)) {
                    int numberOfWinners = 1;
                    sample[numberOfIndividuals] = i;
                    ++numberOfIndividuals;
                    int j = i + 1;
                    while (j < bsetSize) {
                        if (((IValueFitness)((IIndividual)this.nset.get(j)).getFitness()).getValue() > -1.0 && ((IIndividual)this.nset.get(i)).distance((IIndividual)this.nset.get(j)) < radiusOfNiche) {
                            if (numberOfWinners < this.kappa) {
                                if (!this.checkConsideredIndividuals(j, numberOfIndividuals, sample)) {
                                    ++numberOfWinners;
                                    sample[numberOfIndividuals] = j;
                                    ++numberOfIndividuals;
                                }
                            } else {
                                ((IValueFitness)((IIndividual)this.nset.get(j)).getFitness()).setValue(-1.0);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected boolean checkConsideredIndividuals(int numberOfIndividual, int numberOfIndividuals, int[] sample) {
        int j = 0;
        while (j < numberOfIndividuals) {
            if (sample[j] == numberOfIndividual) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public double calculateNicheRadius() {
        double distanciaMaxima = -1.0;
        int i = 0;
        while (i < this.bset.size()) {
            int j = i + 1;
            while (j < this.bset.size()) {
                if (distanciaMaxima < ((IIndividual)this.bset.get(i)).distance((IIndividual)this.bset.get(j))) {
                    distanciaMaxima = ((IIndividual)this.bset.get(i)).distance((IIndividual)this.bset.get(j));
                }
                ++j;
            }
            ++i;
        }
        return 0.2 * distanciaMaxima;
    }
}

