/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import weka.core.InheritanceUtils;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageLibIsolatingClassLoader;

public class SerializationHelper
implements RevisionHandler {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static boolean isSerializable(String classname) {
        boolean result;
        try {
            result = SerializationHelper.isSerializable(WekaPackageClassLoaderManager.forName(classname));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean isSerializable(Class<?> c) {
        return InheritanceUtils.hasInterface(Serializable.class, c);
    }

    public static boolean hasUID(String classname) {
        boolean result;
        try {
            result = SerializationHelper.hasUID(WekaPackageClassLoaderManager.forName(classname));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean hasUID(Class<?> c) {
        boolean result = false;
        if (SerializationHelper.isSerializable(c)) {
            try {
                c.getDeclaredField(SERIAL_VERSION_UID);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public static boolean needsUID(String classname) {
        boolean result;
        try {
            result = SerializationHelper.needsUID(WekaPackageClassLoaderManager.forName(classname));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean needsUID(Class<?> c) {
        boolean result = SerializationHelper.isSerializable(c) ? !SerializationHelper.hasUID(c) : false;
        return result;
    }

    public static long getUID(String classname) {
        long result;
        try {
            result = SerializationHelper.getUID(WekaPackageClassLoaderManager.forName(classname));
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    public static long getUID(Class<?> c) {
        return ObjectStreamClass.lookup(c).getSerialVersionUID();
    }

    public static void write(String filename, Object o) throws Exception {
        SerializationHelper.write(new FileOutputStream(filename), o);
    }

    public static void write(OutputStream stream, Object o) throws Exception {
        if (!(stream instanceof BufferedOutputStream)) {
            stream = new BufferedOutputStream(stream);
        }
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    public static void writeAll(String filename, Object[] o) throws Exception {
        SerializationHelper.writeAll(new FileOutputStream(filename), o);
    }

    public static void writeAll(OutputStream stream, Object[] o) throws Exception {
        if (!(stream instanceof BufferedOutputStream)) {
            stream = new BufferedOutputStream(stream);
        }
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        for (int i = 0; i < o.length; ++i) {
            oos.writeObject(o[i]);
        }
        oos.flush();
        oos.close();
    }

    public static Object read(String filename) throws Exception {
        return SerializationHelper.read(new FileInputStream(filename));
    }

    public static Object read(InputStream stream) throws Exception {
        ObjectInputStream ois = SerializationHelper.getObjectInputStream(stream);
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public static ClassLoader checkForThirdPartyClass(String className, WekaPackageLibIsolatingClassLoader l) {
        WekaPackageLibIsolatingClassLoader dep;
        ClassLoader result = null;
        if (l.hasThirdPartyClass(className)) {
            return l;
        }
        Iterator<WekaPackageLibIsolatingClassLoader> iterator = l.getPackageClassLoadersForDependencies().iterator();
        while (iterator.hasNext() && (result = SerializationHelper.checkForThirdPartyClass(className, dep = iterator.next())) == null) {
        }
        return result;
    }

    public static ObjectInputStream getObjectInputStream(InputStream stream) throws IOException {
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return new ObjectInputStream(stream){
            protected Set<WekaPackageLibIsolatingClassLoader> m_thirdPartyLoaders = new LinkedHashSet<WekaPackageLibIsolatingClassLoader>();

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String arrayStripped = desc.getName().replace("[L", "").replace("[", "").replace(";", "");
                ClassLoader cl = WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getLoaderForClass(arrayStripped);
                if (cl instanceof WekaPackageLibIsolatingClassLoader) {
                    this.m_thirdPartyLoaders.add((WekaPackageLibIsolatingClassLoader)cl);
                }
                Class<?> result = null;
                try {
                    result = Class.forName(desc.getName(), true, cl);
                }
                catch (ClassNotFoundException ex) {
                    for (WekaPackageLibIsolatingClassLoader l : this.m_thirdPartyLoaders) {
                        ClassLoader checked = SerializationHelper.checkForThirdPartyClass(arrayStripped, l);
                        if (checked == null) continue;
                        result = Class.forName(desc.getName(), true, checked);
                    }
                }
                if (result == null) {
                    throw new ClassNotFoundException("Unable to find class " + arrayStripped);
                }
                return result;
            }
        };
    }

    public static Object[] readAll(String filename) throws Exception {
        return SerializationHelper.readAll(new FileInputStream(filename));
    }

    public static Object[] readAll(InputStream stream) throws Exception {
        ObjectInputStream ois = SerializationHelper.getObjectInputStream(stream);
        Vector<Object> result = new Vector<Object>();
        try {
            while (true) {
                result.add(ois.readObject());
            }
        }
        catch (IOException iOException) {
            ois.close();
            return result.toArray(new Object[result.size()]);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14293 $");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("\nUsage: " + SerializationHelper.class.getName() + " classname [classname [classname [...]]]\n");
            System.exit(1);
        }
        System.out.println();
        for (String arg : args) {
            System.out.println(arg);
            System.out.println("- is serializable: " + SerializationHelper.isSerializable(arg));
            System.out.println("- has serialVersionUID: " + SerializationHelper.hasUID(arg));
            System.out.println("- needs serialVersionUID: " + SerializationHelper.needsUID(arg));
            System.out.println("- serialVersionUID: private static final long serialVersionUID = " + SerializationHelper.getUID(arg) + "L;");
            System.out.println();
        }
    }
}

