/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.rexp.DecorationUtil;
import org.jpmml.rexp.FilterModelConverter;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public class WrappedModelConverter
extends FilterModelConverter<RGenericVector, RExp> {
    public WrappedModelConverter(RGenericVector wrappedModel) {
        super(wrappedModel);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector wrappedModel = (RGenericVector)this.getObject();
        RGenericVector taskDesc = wrappedModel.getGenericElement("task.desc");
        RStringVector type = taskDesc.getStringElement("type");
        RStringVector target = taskDesc.getStringElement("target");
        super.encodeSchema(encoder);
        String targetName = (String)target.asScalar();
        DataField dataField = encoder.getDataField(targetName);
        switch ((String)type.asScalar()) {
            case "regr": {
                if (dataField != null) break;
                dataField = encoder.createDataField(targetName, OpType.CONTINUOUS, DataType.DOUBLE);
                encoder.setLabel(dataField);
                break;
            }
            case "classif": {
                RBooleanVector invertLevels;
                RVector<?> classLevels = taskDesc.getVectorElement("class.levels");
                List values = classLevels.getValues();
                if (dataField == null) {
                    dataField = encoder.createDataField(targetName, OpType.CATEGORICAL, null, values);
                    encoder.setLabel(dataField);
                } else if (dataField.requireOpType() != OpType.CATEGORICAL) {
                    dataField = (DataField)encoder.toCategorical(targetName, values);
                    encoder.setLabel(dataField);
                }
                if (classLevels.size() != 2 || !((Boolean)(invertLevels = DecorationUtil.getBooleanElement(wrappedModel, "invert_levels")).asScalar()).booleanValue()) break;
                values = PMMLUtil.getValues((Field)dataField);
                CategoricalLabel label = new CategoricalLabel(dataField.requireName(), dataField.requireDataType(), Lists.reverse((List)values));
                encoder.setLabel((Label)label);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public Model encodeModel(Schema schema) {
        return super.encodeModel(schema);
    }

    @Override
    public ModelConverter<RExp> createConverter() {
        RGenericVector wrappedModel = (RGenericVector)this.getObject();
        RExp learnerModel = (RExp)wrappedModel.getElement("learner.model");
        return (ModelConverter)WrappedModelConverter.newConverter(learnerModel);
    }
}

