/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.Int2;
import org.xmlcml.euclid.IntRange;
import org.xmlcml.euclid.Real2Range;

public class Int2Range
implements EuclidConstants {
    IntRange xrange;
    IntRange yrange;

    public Int2Range() {
        this.xrange = new IntRange();
        this.yrange = new IntRange();
    }

    public Int2Range(IntRange xr, IntRange yr) {
        if (xr.isValid() && yr.isValid()) {
            this.xrange = xr;
            this.yrange = yr;
        }
    }

    public Int2Range(Int2Range r) {
        if (r.isValid()) {
            this.xrange = new IntRange(r.xrange);
            this.yrange = new IntRange(r.yrange);
        }
    }

    public Int2Range(Real2Range r) {
        this.xrange = new IntRange(r.xrange);
        this.yrange = new IntRange(r.yrange);
    }

    public boolean isValid() {
        return this.xrange != null && this.yrange != null && this.xrange.isValid() && this.yrange.isValid();
    }

    public boolean isEqualTo(Int2Range r2) {
        if (this.isValid() && r2 != null && r2.isValid()) {
            return this.xrange.isEqualTo(r2.xrange) && this.yrange.isEqualTo(r2.yrange);
        }
        return false;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o != null && o instanceof Int2Range) {
            Int2Range i2r = (Int2Range)o;
            equals = this.getXRange().equals(i2r.getXRange()) && this.getYRange().equals(i2r.getYRange());
        }
        return equals;
    }

    public int hashCode() {
        return 17 * this.xrange.hashCode() + 31 * this.yrange.hashCode();
    }

    public Int2Range plus(Int2Range r2) {
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new Int2Range();
            }
            return new Int2Range(r2);
        }
        if (r2 == null || !r2.isValid()) {
            return new Int2Range(this);
        }
        return new Int2Range(this.xrange.plus(r2.xrange), this.yrange.plus(r2.yrange));
    }

    public Int2Range intersectionWith(Int2Range r2) {
        if (!this.isValid() || r2 == null || !r2.isValid()) {
            return new Int2Range();
        }
        IntRange xr = this.getXRange().intersectionWith(r2.getXRange());
        IntRange yr = this.getYRange().intersectionWith(r2.getYRange());
        return new Int2Range(xr, yr);
    }

    public IntRange getXRange() {
        return this.xrange;
    }

    public IntRange getYRange() {
        return this.yrange;
    }

    public Int2Range getInt2RangeExtendedInX(int leftSide, int rightSide) {
        Int2Range i2r = new Int2Range(this);
        if (i2r.xrange != null) {
            i2r.xrange = i2r.xrange.getRangeExtendedBy(leftSide, rightSide);
        }
        return i2r;
    }

    public Int2Range getInt2RangeExtendedInY(int topExtend, int bottomExtend) {
        Int2Range i2r = new Int2Range(this);
        if (i2r.yrange != null) {
            i2r.yrange = i2r.yrange.getRangeExtendedBy(topExtend, bottomExtend);
        }
        return i2r;
    }

    public boolean includes(Int2 p) {
        if (!this.isValid()) {
            return false;
        }
        return this.xrange.includes(p.getX()) && this.yrange.includes(p.getY());
    }

    public boolean includes(Int2Range r) {
        if (!this.isValid() || r == null || !r.isValid()) {
            return false;
        }
        IntRange xr = r.getXRange();
        IntRange yr = r.getYRange();
        return this.xrange.includes(xr) && this.yrange.includes(yr);
    }

    public void add(Int2 p) {
        this.xrange.add(p.getX());
        this.yrange.add(p.getY());
    }

    public String toString() {
        return "(" + this.xrange.toString() + "," + this.yrange.toString() + ")";
    }

    public boolean touches(Int2Range bbox) {
        return this.xrange.touches(bbox.xrange) || this.yrange.touches(bbox.yrange);
    }
}

