/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.inference.operators.SimpleMetropolizedGibbsOperator;
import dr.math.MathUtils;
import java.util.ArrayList;

@Deprecated
public class GibbsPruneAndRegraft
extends SimpleMetropolizedGibbsOperator {
    private int MAX_DISTANCE = 10;
    private final TreeModel tree;
    private int[] distances;
    private double[] scores;
    private boolean pruned = true;

    public GibbsPruneAndRegraft(TreeModel treeModel, boolean bl, double d) {
        this.tree = treeModel;
        this.pruned = bl;
        this.setWeight(d);
        this.scores = new double[treeModel.getNodeCount()];
        this.MAX_DISTANCE = treeModel.getNodeCount() / 10;
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        if (this.pruned) {
            return this.prunedGibbsProposal(likelihood);
        }
        return this.gibbsProposal(likelihood);
    }

    private double gibbsProposal(Likelihood likelihood) {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        int n;
        NodeRef nodeRef3;
        int n2 = this.tree.getNodeCount();
        NodeRef nodeRef4 = this.tree.getRoot();
        while (nodeRef4 == (nodeRef3 = this.tree.getNode(n = MathUtils.nextInt(n2))) || this.tree.getParent(nodeRef3) == nodeRef4) {
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
        double d = this.tree.getNodeHeight(nodeRef5);
        double d2 = 0.0;
        double d3 = this.calculateTreeLikelihood(likelihood, this.tree);
        int n3 = (int)(-d3);
        double d4 = Math.exp(d3 + (double)n3);
        NodeRef nodeRef6 = this.getOtherChild(this.tree, nodeRef5, nodeRef3);
        NodeRef nodeRef7 = this.tree.getParent(nodeRef5);
        for (int i = 0; i < n2; ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (nodeRef2 == nodeRef4) continue;
            nodeRef = this.tree.getParent(nodeRef2);
            if (nodeRef3 == nodeRef2 || !(this.tree.getNodeHeight(nodeRef2) < d) || !(d < this.tree.getNodeHeight(nodeRef))) continue;
            arrayList.add(i);
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
            double d5 = Math.exp(this.calculateTreeLikelihood(likelihood, this.tree) + (double)n3);
            arrayList2.add(d5);
            d2 += d5;
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef6, nodeRef7);
        }
        if (d2 <= 1.0E-100) {
            throw new RuntimeException("Couldn't find another proposal with a decent likelihood.");
        }
        double d6 = MathUtils.nextDouble() * d2;
        int n4 = 0;
        while (d6 > 0.0) {
            d6 -= ((Double)arrayList2.get(n4)).doubleValue();
            ++n4;
        }
        nodeRef2 = this.tree.getNode((Integer)arrayList.get(--n4));
        nodeRef = this.tree.getParent(nodeRef2);
        this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
        double d7 = (Double)arrayList2.get(n4);
        double d8 = d7 / d2;
        double d9 = d4 / (d2 - d7 + d4);
        double d10 = Math.log(d9 / d8);
        return d10;
    }

    private double prunedGibbsProposal(Likelihood likelihood) {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        int n;
        NodeRef nodeRef3;
        int n2 = this.tree.getNodeCount();
        NodeRef nodeRef4 = this.tree.getRoot();
        for (int i = 0; i < n2; ++i) {
            this.scores[i] = Double.NEGATIVE_INFINITY;
        }
        while (nodeRef4 == (nodeRef3 = this.tree.getNode(n = MathUtils.nextInt(n2))) || this.tree.getParent(nodeRef3) == nodeRef4) {
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
        double d = this.tree.getNodeHeight(nodeRef5);
        double d2 = 0.0;
        double d3 = this.calculateTreeLikelihood(likelihood, this.tree);
        int n3 = (int)(-d3);
        double d4 = Math.exp(d3 + (double)n3);
        NodeRef nodeRef6 = this.getOtherChild(this.tree, nodeRef5, nodeRef3);
        NodeRef nodeRef7 = this.tree.getParent(nodeRef5);
        for (int i = 0; i < n2; ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (nodeRef2 == nodeRef4) continue;
            nodeRef = this.tree.getParent(nodeRef2);
            if (nodeRef3 == nodeRef2 || !(this.tree.getNodeHeight(nodeRef2) < d) || !(d < this.tree.getNodeHeight(nodeRef)) || this.getNodeDistance(nodeRef5, nodeRef) > this.MAX_DISTANCE) continue;
            arrayList.add(i);
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
            double d5 = Math.exp(this.calculateTreeLikelihood(likelihood, this.tree) + (double)n3);
            arrayList2.add(d5);
            this.scores[i] = d5;
            d2 += d5;
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef6, nodeRef7);
        }
        if (d2 <= 1.0E-100) {
            throw new RuntimeException("Couldn't find another proposal with a decent likelihood.");
        }
        double d6 = MathUtils.nextDouble() * d2;
        int n4 = 0;
        while (d6 > 0.0) {
            d6 -= ((Double)arrayList2.get(n4)).doubleValue();
            ++n4;
        }
        nodeRef2 = this.tree.getNode((Integer)arrayList.get(--n4));
        nodeRef = this.tree.getParent(nodeRef2);
        this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
        double d7 = 0.0;
        NodeRef nodeRef8 = nodeRef2;
        NodeRef nodeRef9 = nodeRef;
        for (int i = 0; i < n2; ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (nodeRef2 == nodeRef4) continue;
            nodeRef = this.tree.getParent(nodeRef2);
            if (nodeRef3 == nodeRef2 || !(this.tree.getNodeHeight(nodeRef2) < d) || !(d < this.tree.getNodeHeight(nodeRef)) || this.getNodeDistance(nodeRef5, nodeRef) > this.MAX_DISTANCE) continue;
            if (this.scores[i] != Double.NEGATIVE_INFINITY) {
                d7 += this.scores[i];
                continue;
            }
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
            double d8 = Math.exp(this.calculateTreeLikelihood(likelihood, this.tree) + (double)n3);
            d7 += d8;
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef8, nodeRef9);
            this.evaluate(likelihood, 1.0);
        }
        double d9 = (Double)arrayList2.get(n4);
        double d10 = d9 / d2;
        double d11 = d4 / d7;
        double d12 = Math.log(d11 / d10);
        return d12;
    }

    private int getNodeDistance(NodeRef nodeRef, NodeRef nodeRef2) {
        int n = 0;
        double d = this.tree.getNodeHeight(nodeRef);
        double d2 = this.tree.getNodeHeight(nodeRef2);
        while (nodeRef != nodeRef2) {
            ++n;
            if (d < d2) {
                nodeRef = this.tree.getParent(nodeRef);
                d = this.tree.getNodeHeight(nodeRef);
                continue;
            }
            nodeRef2 = this.tree.getParent(nodeRef2);
            d2 = this.tree.getNodeHeight(nodeRef2);
        }
        return n;
    }

    public void printDistances() {
        System.out.println("Number of proposed trees in distances:");
        for (int i = 0; i < this.distances.length; ++i) {
            System.out.println(i + ")\t\t" + this.distances[i]);
        }
    }

    private double calculateTreeLikelihood(Likelihood likelihood, TreeModel treeModel) {
        return this.evaluate(likelihood, 1.0);
    }

    private void pruneAndRegraft(TreeModel treeModel, NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4) {
        treeModel.beginTreeEdit();
        NodeRef nodeRef5 = treeModel.getParent(nodeRef2);
        NodeRef nodeRef6 = this.getOtherChild(treeModel, nodeRef2, nodeRef);
        treeModel.removeChild(nodeRef2, nodeRef6);
        treeModel.removeChild(nodeRef5, nodeRef2);
        treeModel.addChild(nodeRef5, nodeRef6);
        treeModel.removeChild(nodeRef4, nodeRef3);
        treeModel.addChild(nodeRef2, nodeRef3);
        treeModel.addChild(nodeRef4, nodeRef2);
        treeModel.endTreeEdit();
    }

    protected NodeRef getOtherChild(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        if (tree.getChild(nodeRef, 0) == nodeRef2) {
            return tree.getChild(nodeRef, 1);
        }
        return tree.getChild(nodeRef, 0);
    }

    @Override
    public String getOperatorName() {
        return "GibbsPruneAndRegraft";
    }

    @Override
    public int getStepCount() {
        return 0;
    }
}

