/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.DuplicatedParameter;
import dr.inference.model.Parameter;
import java.util.ArrayList;

public class GeneralSubstitutionModel
extends BaseSubstitutionModel {
    protected int ratesRelativeTo;
    protected Parameter ratesParameter = null;

    public GeneralSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, Parameter parameter, int n) {
        this(string, dataType, frequencyModel, parameter, n, null);
    }

    public GeneralSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, Parameter parameter, int n, EigenSystem eigenSystem) {
        super(string, dataType, frequencyModel, eigenSystem);
        this.ratesParameter = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            if (!(parameter instanceof DuplicatedParameter)) {
                parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
            }
            this.setupDimensionNames(n);
        }
        this.setRatesRelativeTo(n);
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = i == this.ratesRelativeTo ? 1.0 : (this.ratesRelativeTo < 0 || i < this.ratesRelativeTo ? this.ratesParameter.getParameterValue(i) : this.ratesParameter.getParameterValue(i - 1));
        }
    }

    protected void setupDimensionNames(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.ratesParameter.getParameterName();
        int n2 = 0;
        for (int i = 0; i < this.dataType.getStateCount(); ++i) {
            for (int j = i + 1; j < this.dataType.getStateCount(); ++j) {
                if (n2 == n) continue;
                arrayList.add(this.getDimensionString(i, j, string));
            }
            ++n2;
        }
        String[] stringArray = new String[]{};
        this.ratesParameter.setDimensionNames(arrayList.toArray(stringArray));
    }

    protected String getDimensionString(int n, int n2, String string) {
        String string2 = this.dataType.getCode(n) + "." + this.dataType.getCode(n2);
        if (string == null) {
            return string2;
        }
        return string + "." + string2;
    }

    public void setRatesRelativeTo(int n) {
        this.ratesRelativeTo = n;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.updateMatrix = true;
    }

    @Override
    protected void acceptState() {
    }
}

