/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Statistic;
import dr.inference.model.SubStatistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class LoggableStatistic
extends Statistic.Abstract {
    public static final String LOGGABLE_STATISTIC = "loggableStatistic";
    private final NumberColumn[] logColumns;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserName() {
            return LoggableStatistic.LOGGABLE_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.hasAttribute("name") || xMLObject.hasAttribute("id") ? xMLObject.getAttribute("name", xMLObject.getId()) : "";
            Loggable loggable = (Loggable)xMLObject.getChild(Loggable.class);
            LogColumn[] logColumnArray = loggable.getColumns();
            NumberColumn[] numberColumnArray = new NumberColumn[logColumnArray.length];
            for (int i = 0; i < logColumnArray.length; ++i) {
                if (!(logColumnArray[i] instanceof NumberColumn)) {
                    throw new XMLParseException("Can only convert NumberColumns into Statistics");
                }
                numberColumnArray[i] = (NumberColumn)logColumnArray[i];
            }
            return new LoggableStatistic(string, numberColumnArray);
        }

        @Override
        public String getParserDescription() {
            return "Allows you to choose specific dimensions of a given statistic";
        }

        @Override
        public Class getReturnType() {
            return SubStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Loggable.class)};
        }
    };

    public LoggableStatistic(String string, NumberColumn[] numberColumnArray) {
        super(string);
        this.logColumns = numberColumnArray;
    }

    @Override
    public int getDimension() {
        return this.logColumns.length;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.logColumns[n].getDoubleValue();
    }

    @Override
    public String getDimensionName(int n) {
        return this.logColumns[n].getLabel();
    }
}

