/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Color;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.DefaultElementView;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.ParamScaleLegend;
import org.rosuda.deducer.plots.ScaleBrewerPanel;
import org.rosuda.deducer.toolkit.XMLHelper;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamColor;
import org.rosuda.deducer.widgets.param.ParamLogical;
import org.rosuda.deducer.widgets.param.ParamNone;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Scale
implements ElementModel {
    private static String[] transformations = new String[]{"asn", "atanh", "exp", "identity", "log", "log10", "log1p", "probit", "reciprocal", "reverse", "sqrt"};
    private static String[] transformationNames = new String[]{"Arc-sin square root", "Arc-tangent", "e^x", "identity", "log", "log base 10", "log + 1", "probit", "1 / x", "reverse", "square root"};
    private String name;
    public String aesName;
    public Vector params = new Vector();

    public static Scale makeAlpha() {
        Scale scale = new Scale();
        scale.setName("scale_alpha");
        scale.aesName = "alpha";
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Data range");
        scale.params.add(param);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("range");
        paramVector.setTitle("Alpha range");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        paramVector.setValue(new String[]{"0", "1"});
        paramVector.setDefaultValue(new String[]{"0", "1"});
        paramVector.setLowerBound(new Double(0.0));
        paramVector.setUpperBound(new Double(1.0));
        scale.params.add(paramVector);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeBrewer(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_brewer");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, false);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Included levels");
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("palette");
        param.setTitle("Colour palette");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("Blues");
        param.setDefaultValue("Blues");
        param.setOptions(new String[]{"YlOrRd", "YlOrBr", "YlGnBu", "YlGn", "Reds", "RdPu", "Purples", "PuRd", "PuBuGn", "PuBu", "OrRd", "Oranges", "Greys", "Greens", "GnBu", "BuPu", "BuGn", "Blues", "", "Set3", "Set2", "Set1", "Pastel2", "Pastel1", "Paired", "Dark2", "Accent", "", "Spectral", "RdYlGn", "RdYlBu", "RdGy", "RdBu", "PuOr", "PRGn", "PiYG", "BrBG"});
        scale.params.add(param);
        return scale;
    }

    public static Scale makeContinuous(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_continuous");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("expand");
        param.setTitle("Expand (*,+)");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setValue(new String[]{"0.05", "0.55"});
        param.setDefaultValue(new String[]{"0.05", "0.55"});
        scale.params.add(param);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeDate(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_date");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("expand");
        param.setTitle("Expand (*,+)");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setValue(new String[]{"0.05", "0.55"});
        param.setDefaultValue(new String[]{"0.05", "0.55"});
        scale.params.add(param);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        return scale;
    }

    public static Scale makeDatetime(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_datetime");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("expand");
        param.setTitle("Expand (*,+)");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setValue(new String[]{"0.05", "0.55"});
        param.setDefaultValue(new String[]{"0.05", "0.55"});
        scale.params.add(param);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        return scale;
    }

    public static Scale makeDiscrete(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_discrete");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, false);
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("expand");
        param.setTitle("Expand");
        param.setValue(new String[]{"0.05", "0.55"});
        param.setDefaultValue(new String[]{"0.05", "0.55"});
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("limits");
        paramVector.setNumeric(false);
        paramVector.setTitle("Included levels");
        scale.params.add(paramVector);
        param = new ParamLogical();
        param.setName("drop");
        param.setTitle("Drop unused levels");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamCheckBoxWidget");
        param.setValue(new Boolean(true));
        param.setDefaultValue(new Boolean(true));
        scale.params.add(param);
        return scale;
    }

    public static Scale makeGradient(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_gradient");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamNone("Colours");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamColor();
        param.setName("low");
        param.setTitle("Low");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        param.setValue(Color.decode("#132B43"));
        param.setDefaultValue(Color.decode("#132B43"));
        scale.params.add(param);
        param = new ParamColor();
        param.setName("high");
        param.setTitle("High");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        param.setValue(Color.decode("#56B1F7"));
        param.setDefaultValue(Color.decode("#56B1F7"));
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("space");
        param.setTitle("Space");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("rgb");
        param.setDefaultValue("rgb");
        param.setOptions(new String[]{"rgb", "Lab"});
        scale.params.add(param);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeGradient2(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_gradient2");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamNone("Colours");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamColor();
        param.setName("low");
        param.setTitle("Low");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        param.setValue(Color.decode("#3B4FB8"));
        param.setDefaultValue(Color.decode("#3B4FB8"));
        scale.params.add(param);
        param = new ParamColor();
        param.setName("mid");
        param.setTitle("Mid-point");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        scale.params.add(param);
        param = new ParamColor();
        param.setName("high");
        param.setTitle("High");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        param.setValue(Color.decode("#B71B1A"));
        param.setDefaultValue(Color.decode("#B71B1A"));
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("space");
        param.setTitle("Space");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("rgb");
        param.setDefaultValue("rgb");
        param.setOptions(new String[]{"rgb", "Lab"});
        scale.params.add(param);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("midpoint");
        paramNumeric.setTitle("Mid-point value");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        scale.params.add(paramNumeric);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Data range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeGradientn(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_gradientn");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("colours");
        paramVector.setTitle("Colours");
        paramVector.setNumeric(false);
        scale.params.add(paramVector);
        param = new ParamCharacter();
        param.setName("space");
        param.setTitle("Colour space");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("rgb");
        param.setDefaultValue("rgb");
        param.setOptions(new String[]{"rgb", "Lab"});
        scale.params.add(param);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Data range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeGrey(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_grey");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, false);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamNone("Gradient");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("start");
        paramNumeric.setTitle("Low");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(0.2));
        paramNumeric.setDefaultValue(new Double(0.2));
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        scale.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("end");
        paramNumeric.setTitle("high");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(0.2));
        paramNumeric.setDefaultValue(new Double(0.2));
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        scale.params.add(paramNumeric);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Data range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeHue(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_hue");
        scale.aesName = string;
        Param param = new ParamScaleLegend("legend", scale.aesName, false);
        param.setTitle("");
        ((ParamScaleLegend)param).setAes(string);
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamNone("Colour");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("h");
        param.setTitle("Hue range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setValue(new String[]{"15", "375"});
        param.setDefaultValue(new String[]{"15", "375"});
        scale.params.add(param);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("l");
        paramNumeric.setTitle("Luminance [0, 100]");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(65.0));
        paramNumeric.setDefaultValue(new Double(65.0));
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(100.0));
        scale.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("c");
        paramNumeric.setTitle("Chroma");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(100.0));
        paramNumeric.setDefaultValue(new Double(100.0));
        paramNumeric.setLowerBound(new Double(0.0));
        scale.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("h.start");
        paramNumeric.setTitle("Hue start");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(0.0));
        paramNumeric.setDefaultValue(new Double(0.0));
        paramNumeric.setLowerBound(new Double(0.0));
        scale.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("direction");
        paramNumeric.setTitle("Colour wheel direction");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramNumeric.setValue(new Double(1.0));
        paramNumeric.setDefaultValue(new Double(1.0));
        paramNumeric.setOptions(new String[]{"1.0", "-1.0"});
        paramNumeric.setLabels(new String[]{"clockwise", "counter clockwise"});
        scale.params.add(paramNumeric);
        param = new ParamNone("Data");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        scale.params.add(param);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("limits");
        paramVector.setTitle("Included levels");
        paramVector.setNumeric(false);
        scale.params.add(paramVector);
        return scale;
    }

    public static Scale makeIdentity(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_identity");
        scale.aesName = string;
        ParamScaleLegend paramScaleLegend = new ParamScaleLegend("legend", scale.aesName, false);
        paramScaleLegend.setTitle("");
        paramScaleLegend.setViewType("scale");
        scale.params.add(paramScaleLegend);
        return scale;
    }

    public static Scale makeLineType() {
        Scale scale = new Scale();
        scale.setName("scale_linetype");
        scale.aesName = "linetype";
        Param param = new ParamScaleLegend("legend", scale.aesName, false);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("limits");
        paramVector.setTitle("Included levels");
        paramVector.setNumeric(false);
        scale.params.add(param);
        param = new ParamLogical();
        param.setName("drop");
        param.setTitle("Drop unused levels");
        param.setValue(new Boolean(true));
        param.setDefaultValue(new Boolean(true));
        scale.params.add(param);
        return scale;
    }

    public static Scale makeManual(String string) {
        Scale scale = new Scale();
        scale.setName("scale_" + string + "_manual");
        scale.aesName = string;
        ParamScaleLegend paramScaleLegend = new ParamScaleLegend("legend", scale.aesName, false);
        paramScaleLegend.setTitle("");
        paramScaleLegend.setViewType("scale");
        scale.params.add(paramScaleLegend);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("values");
        paramVector.setTitle("Values");
        paramVector.setNumeric(!string.equals("colour") && !string.equals("fill"));
        scale.params.add(paramVector);
        return scale;
    }

    public static Scale makeShape() {
        Scale scale = new Scale();
        scale.setName("scale_shape");
        scale.aesName = "shape";
        Param param = new ParamScaleLegend("legend", scale.aesName, false);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        ParamVector paramVector = new ParamVector();
        paramVector.setName("limits");
        paramVector.setTitle("Included levels");
        paramVector.setNumeric(false);
        scale.params.add(param);
        param = new ParamLogical();
        param.setName("solid");
        param.setTitle("Use solid points");
        param.setValue(new Boolean(true));
        param.setDefaultValue(new Boolean(true));
        scale.params.add(param);
        return scale;
    }

    public static Scale makeSize() {
        Scale scale = new Scale();
        scale.setName("scale_size");
        scale.aesName = "size";
        Param param = new ParamScaleLegend("legend", scale.aesName, true);
        param.setTitle("");
        param.setViewType("scale");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("limits");
        param.setTitle("Data range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        scale.params.add(param);
        param = new ParamVector();
        param.setName("range");
        param.setTitle("size range");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setValue(new String[]{"1", "6"});
        param.setDefaultValue(new String[]{"1", "6"});
        scale.params.add(param);
        param = new ParamCharacter();
        param.setName("trans");
        param.setTitle("Transform");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setValue("identity");
        param.setDefaultValue("identity");
        param.setOptions(transformations);
        param.setLabels(transformationNames);
        scale.params.add(param);
        return scale;
    }

    public static Scale makeArea() {
        Scale scale = Scale.makeSize();
        scale.setName("scale_size_area");
        return scale;
    }

    public static Scale makeScale(String string, String string2) {
        if (string2.equals("linetype")) {
            return Scale.makeLineType();
        }
        if (string2.equals("discrete")) {
            return Scale.makeDiscrete(string);
        }
        if (string2.equals("shape")) {
            return Scale.makeShape();
        }
        if (string2.equals("hue")) {
            return Scale.makeHue(string);
        }
        if (string2.equals("alpha")) {
            return Scale.makeAlpha();
        }
        if (string2.equals("continuous")) {
            return Scale.makeContinuous(string);
        }
        if (string2.equals("date")) {
            return Scale.makeDate(string);
        }
        if (string2.equals("datetime")) {
            return Scale.makeDatetime(string);
        }
        if (string2.equals("gradient")) {
            return Scale.makeGradient(string);
        }
        if (string2.equals("gradient2")) {
            return Scale.makeGradient2(string);
        }
        if (string2.equals("gradientn")) {
            return Scale.makeGradientn(string);
        }
        if (string2.equals("grey")) {
            return Scale.makeGrey(string);
        }
        if (string2.equals("identity")) {
            return Scale.makeIdentity(string);
        }
        if (string2.equals("manual")) {
            return Scale.makeManual(string);
        }
        if (string2.equals("size")) {
            return Scale.makeSize();
        }
        if (string2.equals("area")) {
            return Scale.makeArea();
        }
        if (string2.equals("brewer")) {
            return Scale.makeBrewer(string);
        }
        return null;
    }

    @Override
    public Object clone() {
        Scale scale = new Scale();
        for (int i = 0; i < this.params.size(); ++i) {
            scale.params.add(((Param)this.params.get(i)).clone());
        }
        scale.setName(this.name);
        scale.aesName = this.aesName;
        return scale;
    }

    @Override
    public String checkValid() {
        return null;
    }

    @Override
    public String getCall() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.params.size(); ++i) {
            Param param = (Param)this.params.get(i);
            String[] stringArray = param.getParamCalls();
            for (int j = 0; j < stringArray.length; ++j) {
                vector.add(stringArray[j]);
            }
        }
        String string = Deducer.makeRCollection(vector, this.getName(), false);
        return string;
    }

    @Override
    public String getType() {
        return "scale";
    }

    @Override
    public ElementView getView() {
        if (!this.getName().endsWith("brewer")) {
            return new DefaultElementView(this);
        }
        return new ScaleBrewerPanel(this);
    }

    @Override
    public Vector getParams() {
        return this.params;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getData() {
        return null;
    }

    @Override
    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ElementModel");
            element.setAttribute("className", "org.rosuda.deducer.plots.Scale");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.aesName != null) {
                element.setAttribute("aesName", this.aesName);
            }
            for (int i = 0; i < this.params.size(); ++i) {
                Element element2 = ((Param)this.params.get(i)).toXML();
                element2 = (Element)document.importNode(element2, true);
                element.appendChild(element2);
            }
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Scale")) {
            System.out.println("Error Scale: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.aesName = element.hasAttribute("aesName") ? element.getAttribute("aesName") : null;
        this.params = new Vector();
        Vector vector = XMLHelper.getChildrenElementsByTag(element, "Param");
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            string = element2.getAttribute("className");
            Param param = Param.makeParam(string);
            param.setFromXML(element2);
            this.params.add(param);
        }
    }
}

