/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.tramo.ArmaModule;
import ec.tstoolkit.modelling.arima.tramo.DifferencingModule;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.regression.SeasonalDummies;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.List;

public class FTest {
    private RegArimaModel<SarimaModel> regmodel_;
    private RegArimaEstimation<SarimaModel> seasonalModel_;
    private StatisticalTest f_;
    private double sensitivity_ = 0.01;
    private int nseas_;

    public boolean test(TsData s) {
        this.clear();
        this.prepareSeasonalModel(s);
        this.addSeasonalDummies(s.getDomain());
        if (!this.estimateModel()) {
            return false;
        }
        return this.computeStatistics();
    }

    public boolean test(ModelDescription m) {
        this.clear();
        this.prepareSeasonalModel(m.clone());
        this.addSeasonalDummies(m.getEstimationDomain());
        if (!this.estimateModel()) {
            return false;
        }
        return this.computeStatistics();
    }

    public boolean testAMI(TsData s) {
        this.clear();
        return this.searchSeasonalModel(s);
    }

    public double getSensitivity() {
        return this.sensitivity_;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity_ = sensitivity;
    }

    public RegArimaEstimation<SarimaModel> getEstimatedModel() {
        return this.seasonalModel_;
    }

    public StatisticalTest getFTest() {
        return this.f_;
    }

    private void prepareSeasonalModel(TsData input) {
        SarimaSpecification rspec = new SarimaSpecification(input.getFrequency().intValue());
        rspec.airline(false);
        SarimaModel arima = new SarimaModel(rspec);
        this.regmodel_ = new RegArimaModel<SarimaModel>(arima);
        this.regmodel_.setY(new DataBlock(input.internalStorage()));
        this.regmodel_.setMeanCorrection(true);
    }

    private void prepareSeasonalModel(ModelDescription m) {
        SarimaSpecification rspec = m.getSpecification();
        rspec.setBD(0);
        rspec.setBP(0);
        rspec.setBQ(0);
        m.setSpecification(rspec);
        this.regmodel_ = m.buildRegArima();
        this.regmodel_.setMeanCorrection(true);
    }

    private void addSeasonalDummies(TsDomain domain) {
        SeasonalDummies dummies = new SeasonalDummies(domain.getFrequency());
        List<DataBlock> regs = RegressionUtilities.data(dummies, domain);
        for (DataBlock reg : regs) {
            this.regmodel_.addX(reg);
        }
        this.nseas_ = dummies.getDim();
    }

    private boolean estimateModel() {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        this.seasonalModel_ = monitor.process(this.regmodel_);
        return this.seasonalModel_ != null;
    }

    private boolean estimateContext(ModellingContext context) {
        ModelDescription model = context.description;
        if (model.getArimaComponent().getDifferencingOrder() == 0) {
            model.setMean(true);
        }
        context.estimation = new ModelEstimation(model.buildRegArima(), model.getLikelihoodCorrection());
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        return context.estimation.compute(monitor, context.description.getArimaComponent().getFreeParametersCount());
    }

    private boolean computeStatistics() {
        try {
            JointRegressionTest test = new JointRegressionTest(this.sensitivity_);
            int nvars = this.regmodel_.getVarsCount();
            test.accept(this.seasonalModel_.likelihood, this.regmodel_.getArma().getParametersCount(), nvars - this.nseas_, this.nseas_, null);
            this.f_ = test.getTest();
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private void clear() {
        this.regmodel_ = null;
        this.seasonalModel_ = null;
        this.f_ = null;
    }

    private boolean searchSeasonalModel(TsData s) {
        ModellingContext context = new ModellingContext();
        context.description = new ModelDescription(s, null);
        context.description.setAirline(false);
        context.hasseas = false;
        SeasonalDummies dummies = new SeasonalDummies(s.getFrequency());
        this.nseas_ = dummies.getDim();
        context.description.addVariable(Variable.userVariable(dummies, ComponentType.Seasonal, RegStatus.Prespecified));
        if (!this.estimateContext(context)) {
            return false;
        }
        context.description.setSpecification(new SarimaSpecification(context.description.getFrequency()));
        DifferencingModule diff = new DifferencingModule();
        diff.process(context);
        context.estimation = null;
        ArmaModule arma = new ArmaModule();
        arma.setAcceptingWhiteNoise(true);
        arma.process(context);
        if (!this.estimateContext(context)) {
            return false;
        }
        this.regmodel_ = context.estimation.getRegArima();
        this.seasonalModel_ = new RegArimaEstimation<SarimaModel>(this.regmodel_, context.estimation.getLikelihood());
        return this.computeStatistics();
    }
}

