/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class BrowserHelper {
    public static final String[] LINUX_BROWSERS = new String[]{"firefox", "google-chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape"};

    public static void openURL(String url) {
        BrowserHelper.openURL(null, url);
    }

    public static void openURL(Component parent, String url) {
        BrowserHelper.openURL(parent, url, true);
    }

    public static void openURL(Component parent, String url, boolean showDialog) {
        String osName = System.getProperty("os.name");
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                System.err.println("Desktop or browse action not supported, using fallback to determine browser.");
                if (osName.startsWith("Mac OS")) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String browser = null;
                    for (int count = 0; count < LINUX_BROWSERS.length && browser == null; ++count) {
                        if (Runtime.getRuntime().exec(new String[]{"which", LINUX_BROWSERS[count]}).waitFor() != 0) continue;
                        browser = LINUX_BROWSERS[count];
                        break;
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Error attempting to launch web browser:\n" + e.getMessage();
            if (showDialog) {
                JOptionPane.showMessageDialog(parent, errMsg);
            }
            System.err.println(errMsg);
        }
    }

    public static JLabel createLink(String url, String text) {
        final String urlF = url;
        final JLabel result = new JLabel();
        result.setText(text == null || text.length() == 0 ? url : text);
        result.setToolTipText("Click to open link in browser");
        result.setForeground(Color.BLUE);
        result.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    BrowserHelper.openURL(urlF);
                } else {
                    super.mouseClicked(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                result.setForeground(Color.RED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                result.setForeground(Color.BLUE);
            }
        });
        return result;
    }
}

