## ------------------------------------------------------------------------
X <- matrix( rnorm( 1000 ), 20, 50 )
y <- rnorm( 20 )

## ------------------------------------------------------------------------
A <- matrix( sample( 0:1, 50*50, repl=TRUE ), 50, 50 )
A <- A & t(A)  ## Make the matrix symmetric

## ------------------------------------------------------------------------
library( gelnet )
L <- adj2nlapl(A)

## ------------------------------------------------------------------------
model <- gelnet( X, y, 0.1, 1, P = L )

## ------------------------------------------------------------------------
Xnew <- matrix( rnorm( 500 ), 10, 50 )
Xnew %*% model$w + model$b

## ------------------------------------------------------------------------
y <- factor( y > 0, levels=c(TRUE,FALSE) )
model2 <- gelnet( X, y, 0.1, 1, P=L )

## ------------------------------------------------------------------------
data.frame( scores= X %*% model2$w + model2$b, labels= y )

## ------------------------------------------------------------------------
model2bal <- gelnet( X, y, 0.1, 1, P=L, balanced=TRUE )
data.frame( scores= X %*% model2bal$w + model2bal$b, labels= y )

## ------------------------------------------------------------------------
j <- which( y == TRUE )
model1 <- gelnet( X[j,], NULL, 0.1, 1, P=L )

## ------------------------------------------------------------------------
data.frame( scores= X %*% model2bal$w + model2bal$b, labels= y )

