/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.Clause;
import org.chocosolver.sat.Literalizer;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.queues.CircularQueue;

public class SatDecorator
extends MiniSat {
    public ArrayList<Clause> dynClauses = new ArrayList();
    private final TIntObjectHashMap<Literalizer> lits = new TIntObjectHashMap();
    private final HashMap<Variable, List<Literalizer>> vars = new HashMap();
    private final IStateInt sat_trail_;
    private final CircularQueue<Variable> toCheck = new CircularQueue(16);
    private final TIntArrayList early_deductions_;
    private final TIntArrayList touched_variables_;

    public SatDecorator(Model model) {
        super(false);
        this.sat_trail_ = model.getEnvironment().makeInt();
        this.early_deductions_ = new TIntArrayList();
        this.touched_variables_ = new TIntArrayList();
    }

    @Override
    public void beforeAddingClauses() {
        this.synchro();
    }

    @Override
    public void afterAddingClauses() {
        this.storeEarlyDeductions();
    }

    public void learnClause(int ... ps) {
        Arrays.sort(ps);
        switch (ps.length) {
            case 0: {
                this.ok_ = false;
                return;
            }
            case 1: {
                this.dynUncheckedEnqueue(ps[0]);
                this.propagate();
                this.ok_ = this.confl == C_Undef;
                return;
            }
        }
        Clause cr = new Clause(ps);
        this.removeDominated(cr);
        this.dynClauses.add(cr);
        this.attachClause(cr);
    }

    private void removeDominated(Clause last) {
        for (int c = this.dynClauses.size() - 1; c >= 0; --c) {
            int p;
            int l;
            Clause prev = this.dynClauses.get(c);
            if (last.size() >= prev.size()) continue;
            int i = 0;
            int j = 0;
            while (i < last.size() && j < prev.size() && (l = last._g(i)) >= (p = prev._g(j))) {
                ++j;
                if (l != p) continue;
                ++i;
            }
            if (i != last.size() || j != prev.size()) continue;
            this.detachLearnt(c);
        }
    }

    public void detachLearnt(int ci) {
        Clause cr = this.dynClauses.get(ci);
        this.detachClause(cr);
        this.dynClauses.remove(ci);
    }

    private void dynUncheckedEnqueue(int l) {
        this.touched_variables_.add(l);
    }

    public int nLearnt() {
        return this.dynClauses.size();
    }

    public ESat value(int svar) {
        switch (this.valueVar(svar)) {
            case 2: {
                return ESat.FALSE;
            }
            case 1: {
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    public boolean propagateOneLiteral(int lit) {
        assert (this.ok_);
        this.touched_variables_.resetQuick();
        this.propagate();
        if (this.confl != C_Undef) {
            return false;
        }
        if (this.valueLit(lit) == 1) {
            this.pushTrailMarker();
            return true;
        }
        if (this.valueLit(lit) == 2) {
            return false;
        }
        this.pushTrailMarker();
        assert (this.valueLit(lit) == 3);
        this.assignment_.set(SatDecorator.var(lit), SatDecorator.makeBoolean(SatDecorator.sgn(lit)));
        this.trail_.add(lit);
        this.propagate();
        return this.confl == C_Undef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bound(Variable cpvar, ICause cause) throws ContradictionException {
        try {
            if (this.sat_trail_.get() < this.trailMarker()) {
                this.cancelUntil(this.sat_trail_.get());
                assert (this.sat_trail_.get() == this.trailMarker());
            }
            this.toCheck.addFirst(cpvar);
            while (!this.toCheck.isEmpty()) {
                Variable cvar = this.toCheck.pollFirst();
                List<Literalizer> myLits = this.vars.get(cvar);
                for (int i = 0; i < myLits.size(); ++i) {
                    Literalizer ltz = myLits.get(i);
                    if (!ltz.canReact()) continue;
                    int lit = ltz.toLit();
                    if (this.propagateOneLiteral(lit)) {
                        this.sat_trail_.set(this.trailMarker());
                        for (int j = 0; j < this.touched_variables_.size(); ++j) {
                            lit = this.touched_variables_.get(j);
                            Literalizer lzr = this.lits.get(SatDecorator.var(lit));
                            if (lzr == null || !lzr.toEvent(lit, cause)) continue;
                            this.toCheck.addFirst(lzr.cvar());
                        }
                        continue;
                    }
                    ltz.toEvent(SatDecorator.neg(lit), cause);
                }
            }
        }
        finally {
            this.touched_variables_.resetQuick();
            this.toCheck.clear();
        }
    }

    public void storeEarlyDeductions() {
        for (int i = 0; i < this.touched_variables_.size(); ++i) {
            int lit = this.touched_variables_.get(i);
            this.early_deductions_.add(lit);
        }
        this.touched_variables_.resetQuick();
    }

    public void applyEarlyDeductions(ICause cause) throws ContradictionException {
        for (int i = 0; i < this.early_deductions_.size(); ++i) {
            int lit = this.early_deductions_.get(i);
            this.lits.get(SatDecorator.var(lit)).toEvent(lit, cause);
        }
    }

    @Override
    public void cancelUntil(int level) {
        super.cancelUntil(level);
    }

    @Override
    public void onLiteralPushed(int l) {
        this.touched_variables_.add(l);
    }

    public <V extends Variable> int bind(V bvar, Literalizer ltz, Consumer<V> actionOnNew) {
        Optional<Literalizer> opt;
        List tmp = this.vars.computeIfAbsent(bvar, k -> new ArrayList());
        if (tmp.isEmpty()) {
            actionOnNew.accept(bvar);
        }
        if (!(opt = tmp.stream().filter(l -> l.equals(ltz)).findFirst()).isPresent()) {
            int var = this.newVariable();
            ltz.svar(var);
            this.lits.put(var, ltz);
            tmp.add(ltz);
            opt = Optional.of(ltz);
        }
        return opt.get().svar();
    }

    public void synchro() {
        if (this.sat_trail_.get() < this.trailMarker()) {
            this.cancelUntil(this.sat_trail_.get());
            assert (this.sat_trail_.get() == this.trailMarker());
        }
    }

    public boolean clauseEntailed(ArrayList<Clause> clauses) {
        block0: for (Clause c : clauses) {
            for (int i = 0; i < c.size(); ++i) {
                int lit = c._g(i);
                Literalizer ltz = this.lits.get(SatDecorator.var(lit));
                if (ltz == null || this.lits.get(SatDecorator.var(lit)).check(SatDecorator.sgn(lit))) continue block0;
            }
            return false;
        }
        return true;
    }
}

