/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained(partial=true, comment="NQ (!=) is not explained")
public class PropSum
extends Propagator<IntVar> {
    protected final int pos;
    protected final int l;
    protected final int b;
    protected final int[] I;
    protected int maxI;
    protected int sumLB;
    protected int sumUB;
    protected final Operator o;
    protected final int[] ps;

    public PropSum(IntVar[] variables, int pos, Operator o, int b) {
        this(variables, pos, o, b, PropSum.computePriority(variables.length), false);
    }

    PropSum(IntVar[] variables, int pos, Operator o, int b, PropagatorPriority priority, boolean reactOnFineEvent) {
        super((Variable[])variables, (Priority)priority, reactOnFineEvent);
        this.pos = pos;
        this.o = o;
        this.b = b;
        this.l = variables.length;
        this.I = new int[this.l];
        this.maxI = 0;
        this.ps = new int[!this.lcg() ? 0 : this.l + 1];
    }

    protected static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 1) {
            return PropagatorPriority.UNARY;
        }
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        switch (this.o) {
            case NQ: {
                return IntEventType.instantiation();
            }
            case LE: {
                if (vIdx < this.pos) {
                    return IntEventType.lowerBoundAndInst();
                }
                return IntEventType.upperBoundAndInst();
            }
            case GE: {
                if (vIdx < this.pos) {
                    return IntEventType.upperBoundAndInst();
                }
                return IntEventType.lowerBoundAndInst();
            }
        }
        return IntEventType.boundAndInst();
    }

    protected void prepare() {
        int ub;
        int lb;
        int i;
        this.sumUB = 0;
        this.sumLB = 0;
        this.maxI = 0;
        for (i = 0; i < this.pos; ++i) {
            lb = ((IntVar[])this.vars)[i].getLB();
            ub = ((IntVar[])this.vars)[i].getUB();
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI >= this.I[i]) continue;
            this.maxI = this.I[i];
        }
        while (i < this.l) {
            lb = -((IntVar[])this.vars)[i].getUB();
            ub = -((IntVar[])this.vars)[i].getLB();
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            ++i;
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    protected void filter() throws ContradictionException {
        this.prepare();
        switch (this.o) {
            case LE: {
                this.filterOnLeq();
                break;
            }
            case GE: {
                this.filterOnGeq();
                break;
            }
            case NQ: {
                this.filterOnNeq();
                break;
            }
            default: {
                this.filterOnEq();
            }
        }
    }

    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        do {
            anychange = false;
            if (F2 < 0) {
                this.fails(this.explainByMin(-1));
            } else if (E < 0) {
                this.fails(this.explainByMax(-1));
            }
            if (this.maxI > F2 || this.maxI > E) {
                int nlb;
                int nub;
                int bnd;
                int ub;
                int lb;
                int i;
                this.maxI = 0;
                for (i = 0; i < this.pos; ++i) {
                    if (this.I[i] - F2 > 0) {
                        lb = ((IntVar[])this.vars)[i].getLB();
                        ub = lb + this.I[i];
                        bnd = F2 + lb;
                        if (((IntVar[])this.vars)[i].getUB() > bnd && ((IntVar[])this.vars)[i].updateUpperBound(bnd, this, this.explainByMin(i))) {
                            nub = ((IntVar[])this.vars)[i].getUB();
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = ((IntVar[])this.vars)[i].getUB();
                        lb = ub - this.I[i];
                        bnd = ub - E;
                        if (((IntVar[])this.vars)[i].getLB() < bnd && ((IntVar[])this.vars)[i].updateLowerBound(ub - E, this, this.explainByMax(i))) {
                            nlb = ((IntVar[])this.vars)[i].getLB();
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI >= this.I[i]) continue;
                    this.maxI = this.I[i];
                }
                while (i < this.l) {
                    if (this.I[i] - F2 > 0) {
                        lb = -((IntVar[])this.vars)[i].getUB();
                        ub = lb + this.I[i];
                        bnd = -F2 - lb;
                        if (((IntVar[])this.vars)[i].getLB() < bnd && ((IntVar[])this.vars)[i].updateLowerBound(bnd, this, this.explainByMin(i))) {
                            nub = -((IntVar[])this.vars)[i].getLB();
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = -((IntVar[])this.vars)[i].getLB();
                        lb = ub - this.I[i];
                        bnd = -ub + E;
                        if (((IntVar[])this.vars)[i].getUB() > bnd && ((IntVar[])this.vars)[i].updateUpperBound(bnd, this, this.explainByMax(i))) {
                            nlb = -((IntVar[])this.vars)[i].getUB();
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    ++i;
                }
            }
            if (F2 > 0 || E > 0) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    protected void filterOnLeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0) {
            this.fails(this.explainByMin(-1));
        }
        if (this.maxI > F2) {
            int nub;
            int ub;
            int lb;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - F2 > 0) {
                    lb = ((IntVar[])this.vars)[i].getLB();
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, this, this.explainByMin(i))) {
                        nub = ((IntVar[])this.vars)[i].getUB();
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - F2 > 0) {
                    lb = -((IntVar[])this.vars)[i].getUB();
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(-F2 - lb, this, this.explainByMin(i))) {
                        nub = -((IntVar[])this.vars)[i].getLB();
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (E <= 0) {
            this.setPassive();
        }
    }

    protected void filterOnGeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (E < 0) {
            this.fails(this.explainByMax(-1));
        }
        if (this.maxI > E) {
            int nlb;
            int lb;
            int ub;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - E > 0) {
                    ub = ((IntVar[])this.vars)[i].getUB();
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(ub - E, this, this.explainByMax(i))) {
                        nlb = ((IntVar[])this.vars)[i].getLB();
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - E > 0) {
                    ub = -((IntVar[])this.vars)[i].getLB();
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(-ub + E, this, this.explainByMax(i))) {
                        nlb = -((IntVar[])this.vars)[i].getUB();
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (F2 <= 0) {
            this.setPassive();
        }
    }

    Reason explainByMax(int i) {
        if (this.lcg()) {
            int j;
            int m = 1;
            for (j = 0; j < this.pos; ++j) {
                this.ps[m++] = ((IntVar[])this.vars)[j].getMaxLit();
            }
            while (j < this.l) {
                this.ps[m++] = ((IntVar[])this.vars)[j].getMinLit();
                ++j;
            }
            if (i > -1) {
                this.ps[0] = 0;
                this.ps[i + 1] = 0;
            }
            return Reason.r(this.ps);
        }
        return Reason.undef();
    }

    Reason explainByMin(int i) {
        if (this.lcg()) {
            int j;
            int m = 1;
            for (j = 0; j < this.pos; ++j) {
                this.ps[m++] = ((IntVar[])this.vars)[j].getMinLit();
            }
            while (j < this.l) {
                this.ps[m++] = ((IntVar[])this.vars)[j].getMaxLit();
                ++j;
            }
            if (i > -1) {
                this.ps[0] = 0;
                this.ps[i + 1] = 0;
            }
            return Reason.r(this.ps);
        }
        return Reason.undef();
    }

    protected void filterOnNeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0 || E < 0) {
            this.setPassive();
            return;
        }
        int w = -1;
        int sum = 0;
        for (int i = 0; i < this.l; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                sum += i < this.pos ? ((IntVar[])this.vars)[i].getValue() : -((IntVar[])this.vars)[i].getValue();
                continue;
            }
            if (w == -1) {
                w = i;
                continue;
            }
            return;
        }
        if (w == -1) {
            if (sum == this.b) {
                this.fails();
            }
        } else {
            ((IntVar[])this.vars)[w].removeValue(w < this.pos ? this.b - sum : sum - this.b, this, this.lcg() ? this.defaultReason(((IntVar[])this.vars)[w]) : Reason.undef());
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int sumUB = 0;
        int sumLB = 0;
        for (i = 0; i < this.pos; ++i) {
            sumLB += ((IntVar[])this.vars)[i].getLB();
            sumUB += ((IntVar[])this.vars)[i].getUB();
        }
        while (i < this.l) {
            sumLB -= ((IntVar[])this.vars)[i].getUB();
            sumUB -= ((IntVar[])this.vars)[i].getLB();
            ++i;
        }
        return this.check(sumLB, sumUB);
    }

    public ESat check(int sumLB, int sumUB) {
        switch (this.o) {
            case NQ: {
                if (sumUB < this.b || sumLB > this.b) {
                    return ESat.TRUE;
                }
                if (sumUB == this.b && sumLB == this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case LE: {
                if (sumUB <= this.b) {
                    return ESat.TRUE;
                }
                if (sumLB > this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case GE: {
                if (sumLB >= this.b) {
                    return ESat.TRUE;
                }
                if (sumUB < this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
        }
        if (sumLB == this.b && sumUB == this.b) {
            return ESat.TRUE;
        }
        if (sumUB < this.b || sumLB > this.b) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.pos == 0 ? "-" : "").append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    public static int nb(Operator co) {
        switch (co) {
            case LE: {
                return 1;
            }
            case GE: {
                return -1;
            }
        }
        return 0;
    }

    public static Operator nop(Operator co) {
        switch (co) {
            case LE: {
                return Operator.GE;
            }
            case GE: {
                return Operator.LE;
            }
        }
        return Operator.getOpposite(co);
    }

    protected PropSum opposite() {
        return new PropSum((IntVar[])this.vars, this.pos, PropSum.nop(this.o), this.b + PropSum.nb(this.o));
    }
}

