/**
 * Copyright (c) 2024 Visa, Inc.
 *
 * This source code is licensed under the MIT license
 * https://github.com/visa/visa-chart-components/blob/master/LICENSE
 *
 **/
import{r as t,c as s,h as i,g as e}from"./p-b0ab226b.js";import{b as h}from"./p-bb2c1516.js";import{n as a,l as r}from"./p-42dcf457.js";import{U as l,s as c,e as o}from"./p-5fcd3c02.js";import{v as n}from"./p-b5f7528a.js";import{m as u}from"./p-f9c89fe4.js";import{m as d}from"./p-e1d72334.js";import{c as f}from"./p-3f5e41ff.js";import"./p-b6ae930f.js";import"./p-6e7316e2.js";const{propDefaultValues:b}=l;class p{}p.mainTitle="Clustered Bar Chart Title";p.subTitle=b.subTitle.text;p.height=250;p.width=675;p.margin={top:400*.01,bottom:400*.01,right:400*.01,left:400*.01};p.padding={top:20,bottom:50,right:50,left:50};p.localization=b.localization;p.ordinalAccessor="label";p.valueAccessor="value";p.groupAccessor="category";p.reverseOrder=false;p.layout=b.layout;p.xAxis=b.xAxis;p.yAxis=b.yAxis;p.wrapLabel=b.wrapLabel;p.colorPalette=b.colorPaletteCategorical;p.hoverStyle=b.hoverStyle;p.clickStyle=b.clickStyle;p.referenceStyle=b.referenceStyle;p.cursor=b.cursor;p.roundedCorner=b.roundedCorner;p.barIntervalRatio=b.barIntervalRatio;p.groupIntervalRatio=b.barIntervalRatio;p.hoverOpacity=b.hoverOpacity;p.dataLabel=b.dataLabel;p.legend=b.categoryLegend;p.tooltipLabel=b.tooltipLabel;p.showTooltip=b.showTooltip;p.accessibility=b.accessibility;p.animationConfig=b.animationConfig;p.highestHeadingLevel=b.highestHeadingLevel;p.referenceLines=b.referenceLines;p.annotations=b.annotations;p.clickHighlight=b.clickHighlight;p.suppressEvents=b.suppressEvents;const g=".o-layout{width:100%;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap}.o-layout--chart{width:100%}.is--vertical .o-layout--chart{width:90%}clustered-bar-chart{cursor:default}clustered-bar-chart .annotations{pointer-events:none}clustered-bar-chart .annotations .handle{pointer-events:all}clustered-bar-chart .screen-reader-info{position:absolute;left:-9999px;top:auto;width:1px;height:1px;overflow:hidden}clustered-bar-chart .data-table-link{color:#767676;text-decoration:none;font-size:12px;margin-left:5%}clustered-bar-chart .hidden{display:none}clustered-bar-chart #visa-viz-d3-clustered-bar-container{clear:both}clustered-bar-chart .clustered-bar-legend{font-size:1em;display:-ms-flexbox;display:flex;-ms-flex-direction:row;flex-direction:row;-ms-flex-pack:start;justify-content:flex-start;-ms-flex-wrap:wrap;flex-wrap:wrap}clustered-bar-chart .clustered-bar-legend .legend{display:-ms-flexbox;display:flex;-ms-flex-direction:row;flex-direction:row;-ms-flex-pack:start;justify-content:flex-start;margin-right:10px}clustered-bar-chart .clustered-bar-legend .key-dot{margin:3px 8px}clustered-bar-chart .light .grid line{stroke:#c9c9c9;stroke-opacity:1;stroke-width:0.8}clustered-bar-chart .light .grid path{stroke-width:0}clustered-bar-chart .light .axis{font-size:12px}clustered-bar-chart .light .axis .tick text{fill:#767676}clustered-bar-chart .light .axis .tick line{stroke:#767676}clustered-bar-chart .light .axis-label{text-anchor:middle;font:1rem sans-serif}clustered-bar-chart .light .axis-mark{color:#949494;stroke-width:2px}clustered-bar-chart .light .y.axis path{stroke:#767676;opacity:0}clustered-bar-chart .light .x.axis path{stroke:transparent}clustered-bar-chart .dark .grid line{stroke:lightgrey;stroke-opacity:0.7;shape-rendering:crispEdges}clustered-bar-chart .dark .grid path{stroke-width:0}clustered-bar-chart .dark .axis{font-size:12px}clustered-bar-chart .dark .axis .tick line{stroke:lightgrey}clustered-bar-chart .dark .axis .tick text{fill:grey}clustered-bar-chart .dark .axis path{stroke:black}clustered-bar-chart .dark .axis-label{text-anchor:middle;font:1rem sans-serif}clustered-bar-chart .dark .o-layout--chart svg{background:black}clustered-bar-chart .dark .o-layout--chart svg .clustered-bar-dataLabel-vertical{text-anchor:middle}clustered-bar-chart .dark .o-layout--chart svg .clustered-bar-dataLabel-horizontal{text-anchor:start}";const v=g;const{configLocalization:m,getGlobalInstances:y,getActiveLanguageString:x,verifyTextHasSpace:w,checkAttributeTransitions:k,createTextStrokeFilter:A,drawHoverStrokes:W,removeHoverStrokes:L,buildStrokes:S,convertColorsToTextures:T,initializeDescriptionRoot:C,initializeElementAccess:D,setElementFocusHandler:I,setElementAccessID:z,setAccessibilityController:O,hideNonessentialGroups:E,setAccessTitle:P,setAccessSubtitle:N,setAccessLongDescription:M,setAccessExecutiveSummary:j,setAccessPurpose:H,setAccessContext:K,setAccessStatistics:$,setAccessChartCounts:G,setAccessXAxis:R,setAccessYAxis:V,setAccessStructure:q,setAccessAnnotation:B,retainAccessFocus:F,checkAccessFocus:_,setElementInteractionAccessState:X,setAccessibilityDescriptionWidth:Y,autoTextColor:U,annotate:J,chartAccessors:Q,convertVisaColor:Z,checkInteraction:tt,checkClicked:st,checkHovered:it,drawAxis:et,drawGrid:ht,drawLegend:at,setLegendInteractionState:rt,drawTooltip:lt,formatDataLabel:ct,formatDate:ot,getColors:nt,getLicenses:ut,getPadding:dt,getScopedData:ft,initTooltipStyle:bt,overrideTitleTooltip:pt,placeDataLabels:gt,scopeDataKeys:vt,transitionEndAll:mt,visaColors:yt,validateAccessibilityProps:xt,validateLocalizationProps:wt,findTagLevel:kt,prepareRenderChange:At,roundTo:Wt,resolveLabelCollision:Lt,setSubTitle:St,setReferenceLine:Tt}=l;const Ct=class{constructor(i){t(this,i);this.clickEvent=s(this,"clickEvent",7);this.hoverEvent=s(this,"hoverEvent",7);this.mouseOutEvent=s(this,"mouseOutEvent",7);this.initialLoadEvent=s(this,"initialLoadEvent",7);this.initialLoadEndEvent=s(this,"initialLoadEndEvent",7);this.drawStartEvent=s(this,"drawStartEvent",7);this.drawEndEvent=s(this,"drawEndEvent",7);this.transitionEndEvent=s(this,"transitionEndEvent",7);this.shouldValidateAccessibility=true;this.shouldValidateLocalization=true;this.nest=[];this.datakeys=[];this.legendData=[];this.updated=true;this.shouldValidate=false;this.shouldUpdateData=false;this.shouldSetDimensions=false;this.shouldUpdateScales=false;this.shouldValidateAxes=false;this.shouldUpdateAnnotations=false;this.shouldResetRoot=false;this.shouldUpdateTableData=false;this.shouldSetColors=false;this.shouldSetSubTitle=false;this.shouldValidateLabelPlacement=false;this.shouldValidateDataLabelAccessor=false;this.shouldValidateInteractionKeys=false;this.shouldSetSelectionClass=false;this.shouldUpdateXAxis=false;this.shouldUpdateYAxis=false;this.shouldUpdateXGrid=false;this.shouldUpdateYGrid=false;this.shouldUpdateBaseline=false;this.shouldCheckValueAxis=false;this.shouldCheckLabelAxis=false;this.shouldSetGlobalSelections=false;this.shouldEnterUpdateExit=false;this.shouldUpdateGeometries=false;this.shouldUpdateCorners=false;this.shouldUpdateLegendData=false;this.shouldUpdateLegend=false;this.shouldUpdateLegendInteractivity=false;this.shouldSetLegendCursor=false;this.shouldUpdateReferenceLines=false;this.shouldUpdateCursor=false;this.shouldDrawInteractionState=false;this.shouldSetLabelOpacity=false;this.shouldSetLabelPosition=false;this.shouldSetLabelContent=false;this.shouldCheckLabelColor=false;this.shouldBindInteractivity=false;this.shouldUpdateDescriptionWrapper=false;this.shouldSetChartAccessibilityTitle=false;this.shouldSetChartAccessibilitySubtitle=false;this.shouldSetChartAccessibilityLongDescription=false;this.shouldSetChartAccessibilityExecutiveSummary=false;this.shouldSetChartAccessibilityStatisticalNotes=false;this.shouldSetChartAccessibilityStructureNotes=false;this.shouldSetParentSVGAccessibility=false;this.shouldSetGeometryAccessibilityAttributes=false;this.shouldSetGeometryAriaLabels=false;this.shouldSetGroupAccessibilityLabel=false;this.shouldSetChartAccessibilityPurpose=false;this.shouldSetChartAccessibilityContext=false;this.shouldSetTestingAttributes=false;this.shouldRedrawWrapper=false;this.shouldSetTagLevels=false;this.shouldSetChartAccessibilityCount=false;this.shouldSetYAxisAccessibility=false;this.shouldSetXAxisAccessibility=false;this.shouldSetAnnotationAccessibility=false;this.shouldSetTextures=false;this.shouldSetStrokes=false;this.shouldSetLocalizationConfig=false;this.strokes={};this.topLevel="h2";this.bottomLevel="p";this.textTreatmentHandler=(t,s,i)=>{const e=c(i[s]);const h=this.clickHighlight&&this.clickHighlight.length>0&&st(t,this.clickHighlight,this.innerInteractionKeys)&&this.clickStyle.color?yt[this.clickStyle.color]||this.clickStyle.color:this.hoverHighlight&&it(t,this.hoverHighlight,this.innerInteractionKeys)&&this.hoverStyle.color?yt[this.hoverStyle.color]||this.hoverStyle.color:this.preparedColors[s];const a=this.dataLabel.placement==="auto"?this.layout==="vertical"?this.dataLabel.collisionPlacement==="top"&&e.attr("data-baseline")!=="bottom"||this.dataLabel.collisionPlacement==="middle"&&e.attr("data-baseline")!=="bottom"||this.dataLabel.collisionPlacement==="bottom"&&e.attr("data-baseline")==="bottom"&&(t[this.valueAccessor]>=0&&this.y(0)-this.y(t[this.valueAccessor])>20||t[this.valueAccessor]<0&&this.y(0)-this.y(t[this.valueAccessor])<-20):this.dataLabel.collisionPlacement==="right"&&e.attr("data-align")!=="left"||this.dataLabel.collisionPlacement==="middle"&&e.attr("data-align")!=="left"||this.dataLabel.collisionPlacement==="left"&&e.attr("data-align")!=="right":false;const r=a||this.dataLabel.placement==="bottom"||this.dataLabel.placement==="left"?U(h):yt.dark_text;e.attr("filter",!e.classed("textIsMoving")?A({root:this.svg.node(),id:this.chartID,color:a||this.dataLabel.placement==="bottom"||this.dataLabel.placement==="left"?h:"#ffffff"}):null);return r};this.mainTitle=p.mainTitle;this.subTitle=p.subTitle;this.height=p.height;this.width=p.width;this.layout=p.layout;this.margin=p.margin;this.padding=p.padding;this.highestHeadingLevel=p.highestHeadingLevel;this.data=undefined;this.uniqueID=undefined;this.localization=p.localization;this.ordinalAccessor=p.ordinalAccessor;this.valueAccessor=p.valueAccessor;this.groupAccessor=p.groupAccessor;this.reverseOrder=p.reverseOrder;this.xAxis=p.xAxis;this.yAxis=p.yAxis;this.wrapLabel=p.wrapLabel;this.colorPalette=p.colorPalette;this.colors=undefined;this.hoverStyle=p.hoverStyle;this.clickStyle=p.clickStyle;this.referenceStyle=p.referenceStyle;this.cursor=p.cursor;this.roundedCorner=p.roundedCorner;this.barIntervalRatio=p.barIntervalRatio;this.groupIntervalRatio=p.groupIntervalRatio;this.hoverOpacity=p.hoverOpacity;this.animationConfig=p.animationConfig;this.dataLabel=p.dataLabel;this.dataKeyNames=undefined;this.showTooltip=p.showTooltip;this.tooltipLabel=p.tooltipLabel;this.accessibility=p.accessibility;this.legend=p.legend;this.annotations=p.annotations;this.minValueOverride=undefined;this.maxValueOverride=undefined;this.referenceLines=p.referenceLines;this.suppressEvents=p.suppressEvents;this.hoverHighlight=undefined;this.clickHighlight=p.clickHighlight;this.interactionKeys=undefined;this.unitTest=false}dataWatcher(t,s){this.updated=true;this.shouldUpdateData=true;this.shouldSetColors=true;this.shouldSetTextures=true;this.shouldUpdateTableData=true;this.shouldSetGlobalSelections=true;this.shouldSetTestingAttributes=true;this.shouldEnterUpdateExit=true;this.shouldSetLabelContent=true;this.shouldSetLabelPosition=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetGeometryAriaLabels=true;this.shouldUpdateLegendData=true;this.shouldUpdateScales=true;this.shouldValidate=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;this.shouldUpdateXGrid=true;this.shouldUpdateYGrid=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true;this.shouldSetStrokes=true}idWatcher(t,s){console.error("Change detected in prop uniqueID from value "+s+" to value "+t+". This prop cannot be changed after component has loaded.")}headingWatcher(t,s){this.shouldRedrawWrapper=true;this.shouldSetTagLevels=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldSetAnnotationAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetSubTitle=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}titleWatcher(t,s){this.shouldValidate=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetParentSVGAccessibility=true}subtitleWatcher(t,s){this.shouldSetSubTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetParentSVGAccessibility=true}dimensionWatcher(t,s){this.shouldSetDimensions=true;this.shouldUpdateScales=true;this.shouldResetRoot=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true;this.shouldUpdateXGrid=true;this.shouldUpdateYGrid=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true}layoutWatcher(t,s){this.shouldValidateLabelPlacement=true;this.shouldUpdateScales=true;this.shouldValidateAxes=true;this.shouldResetRoot=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true;this.shouldUpdateXGrid=true;this.shouldUpdateYGrid=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetTestingAttributes=true}ordinalAccessorWatcher(t,s){this.shouldUpdateTableData=true;this.shouldUpdateLegendData=true;this.shouldUpdateScales=true;this.shouldSetColors=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetStrokes=true;this.shouldSetTextures=true;if(!(this.interactionKeys&&this.interactionKeys.length)){this.shouldValidateInteractionKeys=true;this.shouldSetSelectionClass=true}}valueAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldUpdateTableData=true;this.shouldUpdateScales=true;this.shouldSetColors=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldCheckValueAxis=true;this.shouldValidateDataLabelAccessor=true;this.shouldSetLabelContent=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetStrokes=true;this.shouldSetTextures=true}groupAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldSetGlobalSelections=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldCheckLabelAxis=true;this.shouldUpdateBaseline=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetGroupAccessibilityLabel=true;this.shouldSetStrokes=true;this.shouldSetTextures=true;if(!(this.interactionKeys&&this.interactionKeys.length)){this.shouldValidateInteractionKeys=true;this.shouldSetSelectionClass=true}}reverseOrderWatcher(t,s){this.shouldUpdateTableData=true;this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetGeometryAriaLabels=true;if(this.layout==="vertical"){this.shouldValidateAxes=true;this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true}else if(this.layout==="horizontal"){this.shouldValidateAxes=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true}}xAxisWatcher(t,s){this.shouldValidateAxes=true;this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;const i=t&&t.gridVisible;const e=s&&s.gridVisible;const h=t&&t.tickInterval?t.tickInterval:0;const a=s&&s.tickInterval?s.tickInterval:0;if(i!==e||h!==a){this.shouldUpdateXGrid=true}}yAxisWatcher(t,s){this.shouldValidateAxes=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;const i=t&&t.gridVisible;const e=s&&s.gridVisible;const h=t&&t.tickInterval?t.tickInterval:0;const a=s&&s.tickInterval?s.tickInterval:0;if(i!==e||h!==a){this.shouldUpdateYGrid=true}}wrapLabelWatcher(t,s){this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true}colorsWatcher(t,s){this.shouldSetColors=true;this.shouldDrawInteractionState=true;this.shouldUpdateLegend=true;this.shouldCheckLabelColor=true;this.shouldSetStrokes=true;this.shouldSetTextures=true}hoverStyleWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetStrokes=true}clickStyleWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetStrokes=true}referenceWatcher(t,s){this.shouldUpdateReferenceLines=true}cursorWatcher(t,s){this.shouldUpdateCursor=true;this.shouldSetLegendCursor=true}cornerWatcher(t,s){this.shouldUpdateCorners=true}intervalRatioWatcher(t,s){this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldCheckLabelAxis=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateAnnotations=true}groupIntervalRatioWatcher(t,s){this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateAnnotations=true}hoverOpacityWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true}labelWatcher(t,s){const i=t&&t.placement?t.placement:false;const e=s&&s.placement?s.placement:false;const h=t&&t.collisionPlacement?t.collisionPlacement:false;const a=s&&s.collisionPlacement?s.collisionPlacement:false;const r=t&&t.visible;const l=s&&s.visible;const c=t&&t.labelAccessor?t.labelAccessor:false;const o=s&&s.labelAccessor?s.labelAccessor:false;const n=t&&t.format?t.format:false;const u=s&&s.format?s.format:false;const d=t&&t.collisionHideOnly?t.collisionHideOnly:false;const f=s&&s.collisionHideOnly?s.collisionHideOnly:false;if(r!==l){this.shouldSetLabelOpacity=true}if(i!==e||h!==a||d!==f){this.shouldValidateLabelPlacement=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true}if(c!==o||n!==u){this.shouldValidateDataLabelAccessor=true;this.shouldUpdateTableData=true;this.shouldSetLabelContent=true;this.shouldCheckLabelColor=true}}tooltipLabelWatcher(t,s){this.shouldUpdateTableData=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGeometryAriaLabels=true}accessibilityWatcher(t,s){this.shouldValidate=true;const i=t&&t.title?t.title:false;const e=s&&s.title?s.title:false;if(i!==e){this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetParentSVGAccessibility=true}const h=t&&t.executiveSummary?t.executiveSummary:false;const a=s&&s.executiveSummary?s.executiveSummary:false;if(h!==a){this.shouldSetChartAccessibilityExecutiveSummary=true}const r=t&&t.purpose?t.purpose:false;const l=s&&s.purpose?s.purpose:false;if(r!==l){this.shouldSetChartAccessibilityPurpose=true}const c=t&&t.longDescription?t.longDescription:false;const o=s&&s.longDescription?s.longDescription:false;if(c!==o){this.shouldSetChartAccessibilityLongDescription=true}const n=t&&t.contextExplanation?t.contextExplanation:false;const u=s&&s.contextExplanation?s.contextExplanation:false;if(n!==u){this.shouldSetChartAccessibilityContext=true}const d=t&&t.statisticalNotes?t.statisticalNotes:false;const f=s&&s.statisticalNotes?s.statisticalNotes:false;if(d!==f){this.shouldSetChartAccessibilityStatisticalNotes=true}const b=t&&t.structureNotes?t.structureNotes:false;const p=s&&s.structureNotes?s.structureNotes:false;if(b!==p){this.shouldSetChartAccessibilityStructureNotes=true}const g=t&&t.includeDataKeyNames;const v=s&&s.includeDataKeyNames;const m=t&&t.elementDescriptionAccessor?t.elementDescriptionAccessor:false;const y=s&&s.elementDescriptionAccessor?s.elementDescriptionAccessor:false;if(g!==v||m!==y){if(g!==v){this.shouldSetGroupAccessibilityLabel=true}this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}const x=t&&t.hideTextures?t.hideTextures:false;const w=s&&s.hideTextures?s.hideTextures:false;if(x!==w){this.shouldSetTextures=true;this.shouldUpdateLegend=true;this.shouldDrawInteractionState=true}const k=t&&t.showSmallLabels?t.showSmallLabels:false;const A=s&&s.showSmallLabels?s.showSmallLabels:false;if(k!==A){this.shouldSetLabelOpacity=true}const W=t&&t.hideStrokes?t.hideStrokes:false;const L=s&&s.hideStrokes?s.hideStrokes:false;if(W!==L){this.shouldUpdateLegend=true;this.shouldSetStrokes=true;this.shouldDrawInteractionState=true}const S=t&&t.keyboardNavConfig&&t.keyboardNavConfig.disabled?t.keyboardNavConfig.disabled:false;const T=s&&s.keyboardNavConfig&&s.keyboardNavConfig.disabled?s.keyboardNavConfig.disabled:false;const C=t&&t.elementsAreInterface?t.elementsAreInterface:false;const D=s&&s.elementsAreInterface?s.elementsAreInterface:false;if(S!==T||C!==D){this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldRedrawWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}if(C!==D){this.shouldDrawInteractionState=true}}legendWatcher(t,s){this.shouldUpdateLegend=true;const i=t&&t.interactive;const e=s&&s.interactive;if(i!==e){this.shouldSetLegendCursor=true;this.shouldUpdateLegendInteractivity=true}}localizationWatcher(t,s){this.shouldValidate=true;const i=t&&t.language?t.language:false;const e=s&&s.language?s.language:false;if(i!==e){this.shouldSetLocalizationConfig=true;this.shouldUpdateTableData=true;this.shouldValidateDataLabelAccessor=true;this.shouldSetLabelContent=true;this.shouldCheckLabelColor=true;this.shouldRedrawWrapper=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}const h=t&&t.numeralLocale?t.numeralLocale:false;const a=s&&s.numeralLocale?s.numeralLocale:false;if(h!==a){this.shouldSetLocalizationConfig=true;this.shouldUpdateTableData=true;this.shouldValidateDataLabelAccessor=true;this.shouldSetLabelContent=true;this.shouldCheckLabelColor=true;this.shouldRedrawWrapper=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}}annotationsWatcher(t,s){this.shouldValidate=true;this.shouldUpdateAnnotations=true;this.shouldSetAnnotationAccessibility=true}valueOverrideWatcher(t,s){this.shouldUpdateScales=true;this.shouldCheckValueAxis=true;this.shouldUpdateGeometries=true;this.shouldSetLabelPosition=true;this.shouldCheckLabelColor=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true}clickWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetSelectionClass=true}hoverWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true}interactionWatcher(t,s){this.shouldValidateInteractionKeys=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetSelectionClass=true;this.shouldUpdateTableData=true;this.shouldSetGeometryAriaLabels=true}dataKeyNamesWatcher(t,s){this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGroupAccessibilityLabel=true;this.shouldSetGeometryAriaLabels=true}suppressWatcher(t,s){this.shouldBindInteractivity=true;this.shouldUpdateCursor=true;this.shouldSetLegendCursor=true;this.shouldUpdateLegendInteractivity=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldRedrawWrapper=true;this.shouldValidate=true;this.shouldSetSubTitle=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}unitTestWatcher(t,s){this.shouldSetTestingAttributes=true}componentWillLoad(){const t=this.uniqueID||"clustered-bar-chart-"+n();this.initialLoadEvent.emit({chartID:t});return new Promise((s=>{this.duration=0;this.defaults=true;this.chartID=t;this.clusteredBarChartEl.id=this.chartID;this.setLocalizationConfig();this.setTagLevels();this.prepareData();this.prepareLegendData();this.setDimensions();this.prepareScales();this.validateInteractionKeys();this.validateDataLabelAccessor();this.validateAxes();this.validateLabelPlacement();this.setTableData();this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.setColors();s("component will load")}))}componentWillUpdate(){return new Promise((t=>{t("component will update")}))}componentDidLoad(){return new Promise((t=>{this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.renderRootElements();this.setTooltipInitialStyle();this.setChartDescriptionWrapper();this.setChartAccessibilityTitle();this.setChartAccessibilitySubtitle();this.setChartAccessibilityLongDescription();this.setChartAccessibilityExecutiveSummary();this.setChartAccessibilityPurpose();this.setChartAccessibilityContext();this.setChartAccessibilityStatisticalNotes();this.setChartAccessibilityStructureNotes();this.setParentSVGAccessibility();this.reSetRoot();this.setTextures();this.setStrokes();this.setSubTitleElements();this.drawXGrid();this.drawYGrid();this.setGlobalSelections();this.setTestingAttributes();this.enterGeometries();this.updateGeometries();this.exitGeometries();this.enterDataLabels();this.updateDataLabels();this.exitDataLabels();this.drawGeometries();this.setChartCountAccessibility();this.setGeometryAccessibilityAttributes();this.setGeometryAriaLabels();this.drawLegendElements();this.bindLegendInteractivity();this.setLabelContent();this.processLabelPosition(this.updateLabels,false,true,false);this.drawReferenceLines();this.setSelectedClass();this.checkLabelColorAgainstBackground();this.updateCursor();this.bindInteractivity();this.drawAnnotations();this.setAnnotationAccessibility();this.drawXAxis();this.setXAxisAccessibility();this.drawYAxis();this.setYAxisAccessibility();this.drawBaseline();this.onChangeHandler();E(this.root.node(),this.barG.node());this.setGroupAccessibilityID();this.defaults=false;this.updateLabels.classed("entering",false);t("component did load")})).then((()=>this.initialLoadEndEvent.emit({chartID:this.chartID})))}componentDidUpdate(){return new Promise((t=>{this.duration=!this.animationConfig||!this.animationConfig.disabled?750:0;if(this.shouldUpdateDescriptionWrapper){this.setChartDescriptionWrapper();this.shouldUpdateDescriptionWrapper=false}if(this.shouldSetChartAccessibilityCount){this.setChartCountAccessibility();this.shouldSetChartAccessibilityCount=false}if(this.shouldSetChartAccessibilityTitle){this.setChartAccessibilityTitle();this.shouldSetChartAccessibilityTitle=false}if(this.shouldSetChartAccessibilitySubtitle){this.setChartAccessibilitySubtitle();this.shouldSetChartAccessibilitySubtitle=false}if(this.shouldSetChartAccessibilityLongDescription){this.setChartAccessibilityLongDescription();this.shouldSetChartAccessibilityLongDescription=false}if(this.shouldSetChartAccessibilityExecutiveSummary){this.setChartAccessibilityExecutiveSummary();this.shouldSetChartAccessibilityExecutiveSummary=false}if(this.shouldSetChartAccessibilityPurpose){this.setChartAccessibilityPurpose();this.shouldSetChartAccessibilityPurpose=false}if(this.shouldSetChartAccessibilityContext){this.setChartAccessibilityContext();this.shouldSetChartAccessibilityContext=false}if(this.shouldSetChartAccessibilityStatisticalNotes){this.setChartAccessibilityStatisticalNotes();this.shouldSetChartAccessibilityStatisticalNotes=false}if(this.shouldSetChartAccessibilityStructureNotes){this.setChartAccessibilityStructureNotes();this.shouldSetChartAccessibilityStructureNotes=false}if(this.shouldSetParentSVGAccessibility){this.setParentSVGAccessibility();this.shouldSetParentSVGAccessibility=false}if(this.shouldResetRoot){this.reSetRoot();this.shouldResetRoot=false}if(this.shouldSetTextures){this.setTextures();this.shouldSetTextures=false}if(this.shouldSetStrokes){this.setStrokes();this.shouldSetStrokes=false}if(this.shouldSetGlobalSelections){this.setGlobalSelections();this.shouldSetGlobalSelections=false}if(this.shouldSetTestingAttributes){this.setTestingAttributes();this.shouldSetTestingAttributes=false}if(this.shouldSetSubTitle){this.setSubTitleElements();this.shouldSetSubTitle=false}if(this.shouldUpdateXGrid){this.drawXGrid();this.shouldUpdateXGrid=false}if(this.shouldUpdateYGrid){this.drawYGrid();this.shouldUpdateYGrid=false}if(this.shouldEnterUpdateExit){this.enterGeometries();this.updateGeometries();this.exitGeometries();this.enterDataLabels();this.updateDataLabels();this.exitDataLabels();this.shouldEnterUpdateExit=false}if(this.shouldUpdateGeometries){this.drawGeometries();this.shouldUpdateGeometries=false}if(this.shouldSetGeometryAccessibilityAttributes){this.setGeometryAccessibilityAttributes();this.shouldSetGeometryAccessibilityAttributes=false}if(this.shouldSetGeometryAriaLabels){this.setGeometryAriaLabels();this.shouldSetGeometryAriaLabels=false}if(this.shouldSetGroupAccessibilityLabel){this.setGroupAccessibilityID();this.shouldSetGroupAccessibilityLabel=false}if(this.shouldUpdateCorners){this.setRoundedCorners();this.shouldUpdateCorners=false}if(this.shouldUpdateLegend){this.drawLegendElements();this.shouldUpdateLegend=false}if(this.shouldSetLabelContent){this.setLabelContent();this.shouldSetLabelContent=false}if(this.shouldSetLabelPosition){this.setLabelPosition();this.shouldSetLabelPosition=false}if(this.shouldUpdateReferenceLines){this.drawReferenceLines();this.shouldUpdateReferenceLines=false}if(this.shouldDrawInteractionState){this.updateInteractionState();this.shouldDrawInteractionState=false}if(this.shouldSetLabelOpacity){this.setLabelOpacity();this.shouldSetLabelOpacity=false}if(this.shouldCheckLabelColor){this.checkLabelColorAgainstBackground();this.shouldCheckLabelColor=false}if(this.shouldSetSelectionClass){this.setSelectedClass();this.shouldSetSelectionClass=false}if(this.shouldUpdateLegendInteractivity){this.bindLegendInteractivity();this.shouldUpdateLegendInteractivity=false}if(this.shouldSetLegendCursor){this.setLegendCursor();this.shouldSetLegendCursor=false}if(this.shouldUpdateCursor){this.updateCursor();this.shouldUpdateCursor=false}if(this.shouldBindInteractivity){this.bindInteractivity();this.shouldBindInteractivity=false}if(this.shouldUpdateAnnotations){this.drawAnnotations();this.shouldUpdateAnnotations=false}if(this.shouldSetAnnotationAccessibility){this.setAnnotationAccessibility();this.shouldSetAnnotationAccessibility=false}if(this.shouldUpdateXAxis){this.drawXAxis();this.shouldUpdateXAxis=false}if(this.shouldSetXAxisAccessibility){this.setXAxisAccessibility();this.shouldSetXAxisAccessibility=false}if(this.shouldUpdateYAxis){this.drawYAxis();this.shouldUpdateYAxis=false}if(this.shouldSetYAxisAccessibility){this.setYAxisAccessibility();this.shouldSetYAxisAccessibility=false}if(this.shouldUpdateBaseline){this.drawBaseline();this.shouldUpdateBaseline=false}this.onChangeHandler();this.updateLabels.classed("entering",false);t("component did update")})).then((()=>this.drawEndEvent.emit({chartID:this.chartID})))}shouldValidateLocalizationProps(){const t=y();const s=t.i18Next.language;const i=t.i18Next.getResourceBundle(s);const e=t.numeral.localeData();if(this.shouldValidateLocalization&&!this.localization.skipValidation){this.shouldValidateLocalization=false;wt(this.chartID,Object.assign(Object.assign({},this.localization),{language:i,numeralLocale:e}))}}shouldValidateAccessibilityProps(){if(this.shouldValidateAccessibility&&!this.accessibility.disableValidation){this.shouldValidateAccessibility=false;xt(this.chartID,Object.assign({},this.accessibility),{annotations:this.annotations,data:this.data,uniqueID:this.uniqueID,context:{mainTitle:this.mainTitle,onClickEvent:!this.suppressEvents?this.clickEvent.emit:undefined}})}}validateInteractionKeys(){this.innerInteractionKeys=this.interactionKeys&&this.interactionKeys.length?this.interactionKeys:[this.ordinalAccessor]}validateDataLabelAccessor(){this.innerLabelAccessor=this.dataLabel.labelAccessor?this.dataLabel.labelAccessor:this.valueAccessor}validateLabelPlacement(){if(this.layout==="vertical"){if(this.dataLabel.placement!=="top"&&this.dataLabel.placement!=="bottom"&&this.dataLabel.placement!=="auto"){this.dataLabel.placement="top"}}else{if(this.dataLabel.placement!=="right"&&this.dataLabel.placement!=="left"&&this.dataLabel.placement!=="auto"){this.dataLabel.placement="right"}}}getLanguageString(){return x(this.localization)}setLocalizationConfig(){m(this.localization)}setDimensions(){this.padding=typeof this.padding==="string"?dt(this.padding):this.padding;this.innerHeight=this.height-this.margin.top-this.margin.bottom;this.innerWidth=this.width-this.margin.left-this.margin.right;this.innerPaddedHeight=this.innerHeight-this.padding.top-this.padding.bottom;this.innerPaddedWidth=this.innerWidth-this.padding.left-this.padding.right}prepareData(){this.data.map((t=>{t[this.valueAccessor]=parseFloat(t[this.valueAccessor]);t[this.groupAccessor]=t[this.groupAccessor]instanceof Date?ot({date:t[this.groupAccessor],format:this.layout==="vertical"?this.xAxis.format:this.yAxis.format,offsetTimezone:true}):t[this.groupAccessor]}));this.nest=a().key((t=>t[this.groupAccessor])).entries(this.data);this.datakeys=this.nest.map((t=>t.key))}setTableData(){const t=vt(this,Q,"clustered-bar-chart");this.tableData=ft(this.data,t);this.tableColumns=Object.keys(t)}prepareScales(){const t=this.minValueOverride&&this.minValueOverride<u(this.data,(t=>t[this.valueAccessor]))?this.minValueOverride:u(this.data,(t=>t[this.valueAccessor]));const s=this.maxValueOverride&&this.maxValueOverride>d(this.data,(t=>t[this.valueAccessor]))?this.maxValueOverride:d(this.data,(t=>t[this.valueAccessor]));if(this.layout==="vertical"){this.y=r().domain([Math.min(0,t),Math.max(0,s)]).range([this.innerPaddedHeight,0]);this.x0=h().domain(this.datakeys).range(this.reverseOrder?[this.innerPaddedWidth,0]:[0,this.innerPaddedWidth]).padding(this.groupIntervalRatio);this.x1=h().domain(this.nest[0].values.map((t=>t[this.ordinalAccessor]))).rangeRound([0,this.x0.bandwidth()]).padding(this.barIntervalRatio)}else if(this.layout==="horizontal"){this.x=r().domain([Math.min(0,t),Math.max(0,s)]).range([0,this.innerPaddedWidth]);this.y0=h().domain(this.datakeys).range(this.reverseOrder?[this.innerPaddedHeight,0]:[0,this.innerPaddedHeight]).padding(this.groupIntervalRatio);this.y1=h().domain(this.nest[0].values.map((t=>t[this.ordinalAccessor]))).rangeRound([0,this.y0.bandwidth()]).padding(this.barIntervalRatio)}}validateAxes(){this.innerXAxis=Object.assign(Object.assign({},this.xAxis),{gridVisible:!(this.layout==="vertical")&&this.xAxis.gridVisible});this.innerYAxis=Object.assign(Object.assign({},this.yAxis),{gridVisible:this.layout==="vertical"&&this.yAxis.gridVisible})}setSubTitleElements(){St({root:this.subTitleG,subTitle:this.subTitle})}setColors(){this.preparedColors=this.colors?Z(this.colors):nt(this.colorPalette,this.nest[0].values.length)}setTextures(){const t=this.preparedColors.range?this.preparedColors.range():this.preparedColors;if(this.accessibility.hideTextures||t.length>6){this.colorArr=this.preparedColors}else{const s=t;const i=T({colors:s,rootSVG:this.svg.node(),id:this.chartID,scheme:"categorical",disableTransitions:!this.duration});this.colorArr=this.preparedColors.range?this.preparedColors.copy().range(i):i}}setStrokes(){this.strokes=S({root:this.svg.node(),id:this.chartID,colors:this.preparedColors.range?this.preparedColors.range():this.preparedColors,clickStyle:this.clickStyle,hoverStyle:this.hoverStyle})}renderRootElements(){this.svg=c(this.clusteredBarChartEl).select(".visa-viz-d3-clustered-bar-container").append("svg").attr("width",this.width).attr("height",this.height).attr("viewBox","0 0 "+this.width+" "+this.height);this.root=this.svg.append("g").attr("id","visa-viz-margin-container-g-"+this.chartID);this.rootG=this.root.append("g").attr("id","visa-viz-padding-container-g-"+this.chartID);this.gridG=this.rootG.append("g").attr("class","grid-group");this.barG=this.rootG.append("g").attr("class","clustered-bar-group");this.labelG=this.rootG.append("g").attr("class","clustered-bar-dataLabel-group");this.legendG=c(this.clusteredBarChartEl).select(".clustered-bar-legend").append("svg");this.subTitleG=c(this.clusteredBarChartEl).select(".clustered-bar-sub-title");this.tooltipG=c(this.clusteredBarChartEl).select(".clustered-bar-tooltip");this.referencesG=this.rootG.append("g").attr("class","clustered-bar-reference-line-group")}setTestingAttributes(){if(this.unitTest){c(this.clusteredBarChartEl).select(".visa-viz-d3-clustered-bar-container").attr("data-testid","chart-container");c(this.clusteredBarChartEl).select(".clustered-bar-main-title").attr("data-testid","main-title");c(this.clusteredBarChartEl).select(".clustered-bar-sub-title").attr("data-testid","sub-title");this.svg.attr("data-testid","root-svg");this.root.attr("data-testid","margin-container");this.rootG.attr("data-testid","padding-container");this.legendG.attr("data-testid","legend-container");this.tooltipG.attr("data-testid","tooltip-container");this.barG.attr("data-testid","clustered-bar-group");this.updateBarWrappers.attr("data-testid","clustered-bar-wrapper").attr("data-id",(t=>`clustered-bar-wrapper-${t.key}`));this.update.attr("data-testid","bar").attr("data-id",(t=>`bar-${t[this.groupAccessor]}-${t[this.ordinalAccessor]}`));this.labelG.attr("data-testid","clustered-bar-dataLabel-group");this.updateLabelWrappers.attr("data-testid","clustered-bar-dataLabel-wrapper").attr("data-id",(t=>`clustered-bar-dataLabel-wrapper-${t.key}`));this.updateLabels.attr("data-testid","dataLabel").attr("data-id",(t=>`dataLabel-${t[this.groupAccessor]}-${t[this.ordinalAccessor]}`));this.referencesG.attr("data-testid","reference-line-group");this.svg.select("defs").attr("data-testid","pattern-defs");this.referencesG.selectAll(".clustered-bar-reference-line").attr("data-testid","reference-line");this.referencesG.selectAll(".clustered-bar-reference-line-label").attr("data-testid","reference-line-label")}else{c(this.clusteredBarChartEl).select(".visa-viz-d3-clustered-bar-container").attr("data-testid",null);c(this.clusteredBarChartEl).select(".clustered-bar-main-title").attr("data-testid",null);c(this.clusteredBarChartEl).select(".clustered-bar-sub-title").attr("data-testid",null);this.svg.attr("data-testid",null);this.root.attr("data-testid",null);this.rootG.attr("data-testid",null);this.legendG.attr("data-testid",null);this.tooltipG.attr("data-testid",null);this.barG.attr("data-testid",null);this.updateBarWrappers.attr("data-testid",null).attr("data-id",null);this.update.attr("data-testid",null).attr("data-id",null);this.labelG.attr("data-testid",null);this.updateLabelWrappers.attr("data-testid",null).attr("data-id",null);this.updateLabels.attr("data-testid",null).attr("data-id",null);this.referencesG.attr("data-testid",null);this.svg.select("defs").attr("data-testid",null);this.referencesG.selectAll(".clustered-bar-reference-line").attr("data-testid",null);this.referencesG.selectAll(".clustered-bar-reference-line-label").attr("data-testid",null)}}reSetRoot(){const t=At({selection:this.svg,duration:this.duration,namespace:"root_reset",easing:f});t.attr("width",this.width).attr("height",this.height).attr("viewBox","0 0 "+this.width+" "+this.height);const s=At({selection:this.root,duration:this.duration,namespace:"root_reset",easing:f});s.attr("transform",`translate(${this.margin.left}, ${this.margin.top})`);const i=At({selection:this.rootG,duration:this.duration,namespace:"root_reset",easing:f});i.attr("transform",`translate(${this.padding.left}, ${this.padding.top})`);Y(this.chartID,this.width)}drawXAxis(){const t=this.layout==="vertical"?this.groupAccessor:this.valueAccessor;const s=this.xAxis.label||this.xAxis.label===""?this.xAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.xAxis.label;et({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.layout==="vertical"?this.x0:this.x,left:false,wrapLabel:this.wrapLabel&&this.layout==="vertical"?this.x0.bandwidth():"",format:this.xAxis.format,tickInterval:this.xAxis.tickInterval,label:s,padding:this.padding,hide:!this.innerXAxis.visible,duration:this.duration})}drawYAxis(){const t=this.layout==="vertical"?this.valueAccessor:this.groupAccessor;const s=this.yAxis.label&&this.yAxis.label!==""?this.yAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.yAxis.label;et({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.layout==="vertical"?this.y:this.y0,left:true,wrapLabel:this.wrapLabel?this.padding.left||100:"",format:this.yAxis.format,tickInterval:this.yAxis.tickInterval,label:s,padding:this.padding,hide:!this.innerYAxis.visible,duration:this.duration})}setXAxisAccessibility(){const t=this.layout==="vertical"?this.groupAccessor:this.valueAccessor;const s=this.xAxis.label||this.xAxis.label===""?this.xAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.xAxis.label;R({rootEle:this.clusteredBarChartEl,hasXAxis:this.innerXAxis?this.innerXAxis.visible:false,xAxis:this.layout==="vertical"?this.x0||false:this.x||false,xAxisLabel:s?s:""})}setYAxisAccessibility(){const t=this.layout==="vertical"?this.valueAccessor:this.groupAccessor;const s=this.yAxis.label&&this.yAxis.label!==""?this.yAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.yAxis.label;V({rootEle:this.clusteredBarChartEl,hasYAxis:this.innerYAxis?this.innerYAxis.visible:false,yAxis:this.layout==="vertical"?this.y||false:this.y0||false,yAxisLabel:s?s:""})}drawBaseline(){et({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.layout==="vertical"?this.x0:this.x,left:false,padding:this.padding,markOffset:this.layout==="vertical"?this.y(0)||-1:this.y0(0)||-1,hide:!(this.layout==="vertical"),duration:this.duration});et({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.layout==="vertical"?this.y:this.y0,left:true,padding:this.padding,markOffset:this.layout==="vertical"?this.x0(0)||-1:this.x(0)||-1,hide:this.layout==="vertical",duration:this.duration})}drawXGrid(){ht(this.gridG,this.innerPaddedHeight,this.innerPaddedWidth,this.layout==="vertical"?this.x0:this.x,false,!this.innerXAxis.gridVisible,this.xAxis.tickInterval,this.duration)}drawYGrid(){ht(this.gridG,this.innerPaddedHeight,this.innerPaddedWidth,this.layout==="vertical"?this.y:this.y0,true,!this.innerYAxis.gridVisible,this.yAxis.tickInterval,this.duration)}setGlobalSelections(){const t=this.barG.selectAll(".clustered-bar-wrapper").data(this.nest,(t=>t.key));this.enterBarWrappers=t.enter().append("g");this.exitBarWrappers=t.exit();this.updateBarWrappers=t.merge(this.enterBarWrappers);const s=this.updateBarWrappers.selectAll(".clustered-bar").data((t=>t.values),(t=>t[this.ordinalAccessor]));this.enter=s.enter().append("rect");this.exit=s.exit();this.update=s.merge(this.enter);this.enterSize=this.enter.size();this.exitSize=this.exit.size();const i=this.labelG.selectAll("g").data(this.nest,(t=>t.key));this.enterLabelWrappers=i.enter().append("g");this.exitLabelWrappers=i.exit();this.updateLabelWrappers=i.merge(this.enterLabelWrappers);const e=this.updateLabelWrappers.selectAll("text").data((t=>t.values),(t=>t[this.ordinalAccessor]));this.enterLabels=e.enter().append("text");this.exitLabels=e.exit();this.updateLabels=e.merge(this.enterLabels)}enterGeometries(){this.enter.interrupt();const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"width":"height";const i=this.layout==="vertical"?"y":"x";const e=this.layout==="vertical"?"height":"width";const h=this.layout==="vertical"?"max":"min";this.enterBarWrappers.attr("class","clustered-bar-wrapper").classed("entering",true).attr("transform",(t=>this.layout==="vertical"?"translate("+this.x0(t.key)+",0)":"translate(0,"+this.y0(t.key)+")")).each(((t,s,i)=>{D(i[s])}));this.enter.attr("class","clustered-bar").attr("cursor",!this.suppressEvents?this.cursor:null).attr("rx",this.roundedCorner).attr("ry",this.roundedCorner).each(((t,s,i)=>{D(i[s])})).on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null).attr("fill",((t,s)=>{const i=this.clickHighlight&&this.clickHighlight.length>0&&st(t,this.clickHighlight,this.innerInteractionKeys);const e=this.hoverHighlight&&it(t,this.hoverHighlight,this.innerInteractionKeys);const h=this.colorArr[s];return i&&this.clickStyle.color?yt[this.clickStyle.color]||this.clickStyle.color:i?h:e&&this.hoverStyle.color?yt[this.hoverStyle.color]||this.hoverStyle.color:h})).attr("opacity",0).attr(i,(t=>this[i](Math[h](0,t[this.valueAccessor])))).attr(e,(t=>Math.abs(this.layout==="vertical"?this[i](0)-this[i](t[this.valueAccessor]):this[i](t[this.valueAccessor])-this[i](0))||1e-6)).attr(t,(s=>this[t+"1"](s[this.ordinalAccessor]))).attr(s,this[t+"1"].bandwidth());if(!this.defaults){this.enter.classed("entering",true).attr(t,((s,i,e)=>{const h=c(e[i].parentNode);const a=h.classed("entering");let r=a?this[t+"0"](h.datum().key):this[t+"1"](s[this.ordinalAccessor]);const l=a?this[t+"0"].bandwidth()/2:this[t+"1"].bandwidth()/2;const o=(r+l)/(this.innerPaddedWidth/2);r=a?0:r;const n=r+l*o;return n})).attr(s,0)}this.enterBarWrappers.order();this.enter.order()}updateGeometries(){this.update.interrupt();this.update.transition("opacity").duration(((t,s,i)=>{if(c(i[s]).classed("entering")){c(i[s]).classed("entering",false);return this.duration}return 0})).ease(f).attr("opacity",(t=>tt(t,1,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)))}exitGeometries(){this.exitBarWrappers.interrupt();this.exit.interrupt();const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"width":"height";const i="innerPadded"+s[0].toUpperCase()+s.substring(1);this.exit.transition("exit").duration(this.duration).ease(f).attr("opacity",0).attr(t,((e,h,a)=>{const r=c(a[h]);let l=+r.attr(t)+ +r.attr(s)/2;l=+r.attr(t)+ +r.attr(s)/2*(l/(this[i]/2));return l})).attr(s,0);this.exitSize+=this.exitBarWrappers.selectAll(".clustered-bar").size();this.exitBarWrappers.selectAll(".clustered-bar").transition("exit_wrappers").duration(this.duration*.75).ease(f).attr("opacity",0).attr(t,((s,e,h)=>{const a=h[e].parentNode;const r=a.transform.baseVal.consolidate().matrix.e;const l=this[t+"0"].bandwidth()/2;const c=(r+l)/(this[i]/2);const o=l*c;return o})).attr(s,0);this.update.transition("accessibilityAfterExit").duration(this.duration).ease(f).call(mt,(()=>{const t=_(this.rootG.node());this.exit.remove();this.exitBarWrappers.remove();this.setChartCountAccessibility();this.setGroupAccessibilityID();this.setGeometryAriaLabels();F({parentGNode:this.rootG.node(),focusDidExist:t})}))}drawGeometries(){const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"width":"height";const i=this.layout==="vertical"?"y":"x";const e=this.layout==="vertical"?"height":"width";const h=this.layout==="vertical"?"max":"min";this.updateBarWrappers.transition("update").duration(this.duration).ease(f).attr("transform",(t=>this.layout==="vertical"?"translate("+this.x0(t.key)+",0)":"translate(0,"+this.y0(t.key)+")")).call(mt,(()=>{this.updateBarWrappers.classed("entering",false)}));this.update.classed("geometryIsMoving",((a,r,l)=>{const o=k(c(l[r]),[{attr:t,numeric:true,newValue:this[t+"1"](a[this.ordinalAccessor])},{attr:s,numeric:true,newValue:this[t+"1"].bandwidth()},{attr:i,numeric:true,newValue:this[i](Math[h](0,a[this.valueAccessor]))},{attr:e,numeric:true,newValue:Math.abs(this.layout==="vertical"?this[i](0)-this[i](a[this.valueAccessor]):this[i](a[this.valueAccessor])-this[i](0))||1e-6}]);return o})).attr(`data-${t}`,(s=>this.layout==="vertical"?this[t+"1"](s[this.ordinalAccessor]):this[t+"1"](s[this.ordinalAccessor]))).attr(`data-translate-x`,(t=>(this.layout==="vertical"?this.x0(t[this.groupAccessor]):0)+this.padding.left+this.margin.left)).attr(`data-translate-y`,(t=>(this.layout==="vertical"?0:this.y0(t[this.groupAccessor]))+this.padding.top+this.margin.top)).attr(`data-${s}`,this[t+"1"].bandwidth()).attr(`data-${i}`,(t=>this[i](Math[h](0,t[this.valueAccessor])))).attr(`data-${e}`,(t=>Math.abs(this.layout==="vertical"?this[i](0)-this[i](t[this.valueAccessor]):this[i](t[this.valueAccessor])-this[i](0))||1e-6)).transition("update").duration(((t,s,i)=>c(i[s]).classed("entering")?this.duration/2:this.duration)).delay(((t,s,i)=>c(i[s]).classed("entering")?this.duration/2:0)).ease(f).attr(i,(t=>this[i](Math[h](0,t[this.valueAccessor])))).attr(e,(t=>Math.abs(this.layout==="vertical"?this[i](0)-this[i](t[this.valueAccessor]):this[i](t[this.valueAccessor])-this[i](0))||1e-6)).attr(t,(s=>this[t+"1"](s[this.ordinalAccessor]))).attr(s,this[t+"1"].bandwidth()).call(mt,(()=>{this.update.classed("geometryIsMoving",false);this.updateInteractionState();this.checkLabelColorAgainstBackground();F({parentGNode:this.rootG.node()});this.transitionEndEvent.emit({chartID:this.chartID})}))}updateInteractionState(){L(this.svg.node());this.update.interrupt("opacity");this.update.attr("opacity",(t=>tt(t,1,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys))).attr("fill",((t,s)=>{const i=this.clickHighlight&&this.clickHighlight.length>0&&st(t,this.clickHighlight,this.innerInteractionKeys);const e=this.hoverHighlight&&it(t,this.hoverHighlight,this.innerInteractionKeys);const h=this.colorArr[s];return i&&this.clickStyle.color?yt[this.clickStyle.color]||this.clickStyle.color:i?h:e&&this.hoverStyle.color?yt[this.hoverStyle.color]||this.hoverStyle.color:h})).attr("filter",((t,s,i)=>{if(!this.accessibility.hideStrokes&&!c(i[s]).classed("geometryIsMoving")){const e=this.clickHighlight&&this.clickHighlight.length>0&&st(t,this.clickHighlight,this.innerInteractionKeys);const h=this.hoverHighlight&&it(t,this.hoverHighlight,this.innerInteractionKeys);const a=this.preparedColors[s];const r=e?"click":h&&!c(i[s]).classed("geometryIsMoving")?"hover":"rest";const l=e&&this.clickStyle.color?yt[this.clickStyle.color]||this.clickStyle.color:e?a:h&&this.hoverStyle.color?yt[this.hoverStyle.color]||this.hoverStyle.color:a;if(r==="hover"){W({inputElement:i[s],id:this.chartID,key:t[this.ordinalAccessor]+t[this.groupAccessor],strokeWidth:this.hoverStyle.strokeWidth,fill:l})}return this.strokes[r+l]}return null}));F({parentGNode:this.rootG.node()});rt({root:this.legendG,uniqueID:this.chartID,interactionKeys:this.innerInteractionKeys,groupAccessor:this.ordinalAccessor,hoverHighlight:this.hoverHighlight,clickHighlight:this.clickHighlight,hoverStyle:this.hoverStyle,clickStyle:this.clickStyle,hoverOpacity:this.hoverOpacity});this.updateLabels.interrupt("opacity");const t=this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly;const s=this.dataLabel.placement!=="auto"&&this.dataLabel.collisionHideOnly;this.processLabelOpacity(this.updateLabels,t);if(t){const t=this.updateLabels.filter(((t,s,i)=>c(i[s]).classed("collision-added")));const i=this.updateLabels.filter(((t,s,i)=>c(i[s]).classed("collision-removed"))).attr("data-use-dx",s).attr("data-use-dy",s);if(i.size()>0){this.bitmaps=Lt({bitmaps:this.bitmaps,labelSelection:i,avoidMarks:[],validPositions:["middle"],offsets:[1],accessors:["key"],size:[Wt(this.width,0),Wt(this.height,0)],hideOnly:false,removeOnly:true});i.classed("collision-removed",false)}if(t.size()>0){this.processLabelPosition(t,false,false,true);t.classed("collision-added",false)}}}setLabelOpacity(){this.processLabelOpacity(this.updateLabels)}processLabelOpacity(t,s){const i=this.dataLabel.visible?1:0;const e=this.layout==="vertical"?"x":"y";const h=this.layout==="vertical"?"width":"height";const a=this.layout==="vertical"?"y":"x";const r=this.layout==="vertical"?"height":"width";const l=this[e+"0"].bandwidth()/this.nest[0].values.length;t.attr("opacity",((t,o,n)=>{const u=+c(n[o]).attr("opacity");const d=c(n[o]).style("visibility");const f={};f[h]=this.dataLabel.placement==="left"||this.dataLabel.placement==="bottom"?this[e+"1"].bandwidth():l;if(this.dataLabel.placement==="left"||this.dataLabel.placement==="bottom"){f[r]=Math.abs(this.layout==="vertical"?this[a](0)-this[a](t[this.valueAccessor]):this[a](t[this.valueAccessor])-this[a](0))}const b=this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly||this.accessibility.showSmallLabels||w({text:ct(t,this.innerLabelAccessor,this.dataLabel.format),dimensions:f,fontSize:14});const p=b?tt(t,i,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)<1?0:1:0;if((p===1&&d==="hidden"||u!==p)&&s){if(p===1){c(n[o]).classed("collision-added",true).style("visibility",null)}else{c(n[o]).classed("collision-removed",true)}}return p}))}checkLabelColorAgainstBackground(){this.updateLabels.attr("fill",((t,s,i)=>this.textTreatmentHandler(t,s,i)))}setRoundedCorners(){this.update.transition("corners").duration(this.duration).ease(f).attr("rx",this.roundedCorner).attr("ry",this.roundedCorner)}setSelectedClass(){this.update.classed("highlight",((t,s,i)=>{let e=tt(t,true,false,"",this.clickHighlight,this.innerInteractionKeys);e=this.clickHighlight&&this.clickHighlight.length?e:false;const h=this.accessibility.elementsAreInterface;X(i[s],e,h);return e}))}updateCursor(){this.update.attr("cursor",!this.suppressEvents?this.cursor:null);this.updateLabels.attr("cursor",!this.suppressEvents?this.cursor:null)}enterDataLabels(){const t=this.layout==="vertical"?"x":"y";const s=this.dataLabel.visible?1:0;this.enterLabelWrappers.attr("class","clustered-bar-label-wrapper").classed("entering",true).attr("transform",(t=>this.layout==="vertical"?"translate("+this.x0(t.key)+",0)":"translate(0,"+this.y0(t.key)+")"));this.enterLabels.attr("class","clustered-bar-dataLabel").classed("entering",true).classed("clustered-bar-dataLabel-horizontal",false).classed("clustered-bar-dataLabel-vertical",false).classed("clustered-bar-dataLabel-"+this.layout,true).attr("cursor",!this.suppressEvents?this.cursor:null).attr("opacity",(t=>tt(t,s,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)<1?0:Number.EPSILON)).attr("fill",this.textTreatmentHandler).on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null);this.enterLabels.attr(t,((s,i,e)=>{const h=t+"0";const a=t+"1";const r=t==="x"?"innerPaddedWidth":"innerPaddedHeight";const l=c(e[i].parentNode);const o=l.classed("entering");let n=o?this[h](l.datum().key):this[a](s[this.ordinalAccessor]);const u=o?this[h].bandwidth()/2:this[a].bandwidth()/2;const d=(n+u)/(this[r]/2);n=o?0:n;const f=n+u*d;return f}))}updateDataLabels(){this.updateLabels.interrupt();const t=this.dataLabel.visible?1:0;this.updateLabels.transition("opacity").duration(((t,s,i)=>{if(c(i[s]).classed("entering")){return this.duration/4}return 0})).delay(((t,s,i)=>{if(c(i[s]).classed("entering")){return this.duration/4*3}return 0})).ease(f).attr("opacity",(s=>tt(s,t,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)<1?0:1)).call(mt,(()=>{this.updateLabels.classed("entering",false)}))}exitDataLabels(){this.exitLabelWrappers.selectAll("text").transition("exit").ease(f).duration(this.duration/3).attr("opacity",0).call(mt,(()=>{this.exitLabelWrappers.remove()}));this.exitLabels.transition("exit").ease(f).duration(this.duration/3).attr("opacity",0).remove()}setLabelContent(){this.updateLabels.text((t=>ct(t,this.innerLabelAccessor,this.dataLabel.format)))}setLabelPosition(){this.updateLabelWrappers.classed("clustered-bar-dataLabel-horizontal",false).classed("clustered-bar-dataLabel-vertical",false).classed("clustered-bar-dataLabel-"+this.layout,true);const t=At({selection:this.updateLabelWrappers,duration:this.duration,namespace:"position-label-wrappers",easing:f});t.attr("transform",(t=>this.layout==="vertical"?"translate("+this.x0(t.key)+",0)":"translate(0,"+this.y0(t.key)+")")).call(mt,(()=>{this.updateLabelWrappers.classed("entering",false)}));const s=this.enterLabels.filter(((t,s,i)=>c(i[s]).classed("entering")));const i=this.updateLabels.filter(((t,s,i)=>!c(i[s]).classed("entering")));if(s.size()>0){this.processLabelPosition(s,false,true,false);this.processLabelPosition(i,true,false,true)}else{this.processLabelPosition(i,true,true,false)}}processLabelPosition(t,s,i,e){const h=this.layout==="vertical"?"x":"y";const a=this.layout==="vertical"?"width":"height";const r=this.layout==="vertical"?"y":"x";const l=this.layout==="vertical"?"height":"width";const o=this.layout==="vertical"?"max":"min";const n=this.dataLabel.placement!=="auto"&&this.dataLabel.collisionHideOnly;let u=15;const d={vertical:{top:{validPositions:["top","bottom"],offsets:[4,1]},middle:{validPositions:["middle","top"],offsets:[1,u/2]},bottom:{validPositions:["middle","top"],offsets:[1,u/2]}},horizontal:{right:{validPositions:["right","left"],offsets:[4,8]},middle:{validPositions:["middle","right"],offsets:[1,15]},left:{validPositions:["left","right"],offsets:[1,20]}}};const b=this.dataLabel&&this.dataLabel.collisionPlacement;const p=b&&d[this.layout][b]?this.dataLabel.collisionPlacement:this.layout==="vertical"?"top":"right";t.style("visibility",((t,s,i)=>this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly?c(i[s]).style("visibility"):null)).attr(`data-${h}`,((t,s,i)=>{if(s===0){const t=i[s];const e=getComputedStyle(t);const h=parseFloat(e.fontSize);u=Math.max(h-1,1)}return this[h+"1"](t[this.ordinalAccessor])})).attr(`data-translate-x`,(t=>(this.layout==="vertical"?this.x0(t[this.groupAccessor]):0)+this.padding.left+this.margin.left)).attr(`data-translate-y`,(t=>(this.layout==="vertical"?0:this.y0(t[this.groupAccessor]))+this.padding.top+this.margin.top)).attr(`data-${a}`,this[h+"1"].bandwidth()).attr(`data-${r}`,(t=>this[r](Math[o](0,t[this.valueAccessor])))).attr(`data-${l}`,(t=>Math.abs(this.layout==="vertical"?this[r](0)-this[r](t[this.valueAccessor]):this[r](t[this.valueAccessor])-this[r](0))||1e-6));const g=At({selection:t,duration:!s?0:this.duration,namespace:"position-labels",easing:f});this.bitmaps=gt({root:g,xScale:this.layout==="vertical"?this.x1:this.x,yScale:this.layout==="vertical"?this.y:this.y1,ordinalAccessor:this.ordinalAccessor,valueAccessor:this.valueAccessor,placement:this.dataLabel.placement,layout:this.layout,chartType:"bar",avoidCollision:{runOccupancyBitmap:this.dataLabel.visible&&this.dataLabel.placement==="auto",bitmaps:!i?this.bitmaps:undefined,labelSelection:g,avoidMarks:[this.update],validPositions:n?["middle"]:d[this.layout][p].validPositions,offsets:n?[1]:d[this.layout][p].offsets,accessors:[this.groupAccessor,this.ordinalAccessor,"key"],size:[Wt(this.width,0),Wt(this.height,0)],boundsScope:n?undefined:p,hideOnly:this.dataLabel.visible&&this.dataLabel.collisionHideOnly,suppressMarkDraw:e}})}drawReferenceLines(){Tt({groupName:"cluster",root:this.referencesG,referenceLines:this.referenceLines,referenceStyle:this.referenceStyle,innerPaddedWidth:this.innerPaddedWidth,innerPaddedHeight:this.innerPaddedHeight,duration:this.duration,layout:this.layout,x:this.x,y:this.y,unitTest:this.unitTest})}prepareLegendData(){this.legendData=this.nest[0].values}drawLegendElements(){at({root:this.legendG,uniqueID:this.chartID,width:this.innerPaddedWidth,height:this.margin.top+20,colorArr:this.colorArr,baseColorArr:this.preparedColors,hideStrokes:this.accessibility.hideStrokes,margin:this.margin,padding:this.padding,duration:this.duration,type:"bar",fontSize:16,data:this.legendData,labelKey:this.ordinalAccessor,label:this.legend.labels,hide:!this.legend.visible,interactionKeys:this.innerInteractionKeys,groupAccessor:this.ordinalAccessor,hoverHighlight:this.hoverHighlight,clickHighlight:this.clickHighlight,hoverStyle:this.hoverStyle,clickStyle:this.clickStyle,hoverOpacity:this.hoverOpacity})}bindLegendInteractivity(){c(this.clusteredBarChartEl).selectAll(".legend").style("cursor",this.legend.interactive&&!this.suppressEvents?this.cursor:"").on("click",this.legend.interactive&&!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",this.legend.interactive&&!this.suppressEvents?(t,s,i)=>{this.hoverEvent.emit({data:t,target:i[s]})}:null).on("mouseout",this.legend.interactive&&!this.suppressEvents?()=>this.onMouseOutHandler():null)}setLegendCursor(){c(this.clusteredBarChartEl).selectAll(".legend").style("cursor",this.legend.interactive&&!this.suppressEvents?this.cursor:null)}bindInteractivity(){this.update.on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null);this.updateLabels.on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null)}drawAnnotations(){J({source:this.rootG.node(),data:this.annotations,xScale:this.layout!=="horizontal"?this.x0:this.x,xAccessor:this.layout!=="horizontal"?this.groupAccessor:this.valueAccessor,yScale:this.layout!=="horizontal"?this.y:this.y0,yAccessor:this.layout!=="horizontal"?this.valueAccessor:this.groupAccessor,width:this.width,height:this.height,padding:this.padding,margin:this.margin,bitmaps:this.bitmaps})}setAnnotationAccessibility(){B(this.getLanguageString(),this.clusteredBarChartEl,this.annotations,this.referenceLines)}setTagLevels(){this.topLevel=kt(this.highestHeadingLevel);this.bottomLevel=kt(this.highestHeadingLevel,3)}setChartDescriptionWrapper(){C({language:this.getLanguageString(),rootEle:this.clusteredBarChartEl,title:this.accessibility.title||this.mainTitle,chartTag:"clustered-bar-chart",uniqueID:this.chartID,highestHeadingLevel:this.highestHeadingLevel,redraw:this.shouldRedrawWrapper,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled,hideDataTable:this.accessibility.hideDataTableButton});this.shouldRedrawWrapper=false}setParentSVGAccessibility(){O({chartTag:"clustered-bar-chart",language:this.getLanguageString(),node:this.svg.node(),title:this.accessibility.title||this.mainTitle,description:this.subTitle,uniqueID:this.chartID,geomType:"bar",includeKeyNames:this.accessibility.includeDataKeyNames,dataKeys:vt(this,Q,"clustered-bar-chart"),dataKeyNames:this.dataKeyNames,groupAccessor:this.groupAccessor,groupName:"cluster",disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled})}setGeometryAccessibilityAttributes(){this.update.each(((t,s,i)=>{D(i[s])}))}setGeometryAriaLabels(){const t=vt(this,Q,"clustered-bar-chart");this.update.each(((s,i,e)=>{I({chartTag:"clustered-bar-chart",language:this.getLanguageString(),node:e[i],geomType:"bar",includeKeyNames:this.accessibility.includeDataKeyNames,dataKeys:t,dataKeyNames:this.dataKeyNames,groupName:"cluster",uniqueID:this.chartID,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled});z({node:e[i],uniqueID:this.chartID})}))}setGroupAccessibilityID(){this.updateBarWrappers.each(((t,s,i)=>{z({node:i[s],uniqueID:this.chartID})}))}setChartAccessibilityTitle(){P(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.title||this.mainTitle)}setChartAccessibilitySubtitle(){N(this.getLanguageString(),this.clusteredBarChartEl,this.subTitle)}setChartAccessibilityLongDescription(){M(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.longDescription)}setChartAccessibilityExecutiveSummary(){j(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.executiveSummary)}setChartAccessibilityPurpose(){H(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.purpose)}setChartAccessibilityContext(){K(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.contextExplanation)}setChartAccessibilityStatisticalNotes(){$(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.statisticalNotes)}setChartCountAccessibility(){G({rootEle:this.clusteredBarChartEl,parentGNode:this.barG.node(),chartTag:"clustered-bar-chart",geomType:"bar",groupName:"cluster"})}setChartAccessibilityStructureNotes(){q(this.getLanguageString(),this.clusteredBarChartEl,this.accessibility.structureNotes)}onChangeHandler(){if(this.accessibility&&typeof this.accessibility.onChangeFunc==="function"){const t={updated:this.updated,added:this.enterSize,removed:this.exitSize};this.accessibility.onChangeFunc(t)}this.updated=false;this.enterSize=0;this.exitSize=0}onClickHandler(t,s){this.clickEvent.emit({data:t,target:s})}onHoverHandler(t,s){pt(this.chartID,true);this.hoverEvent.emit({data:t,target:s});if(this.showTooltip&&t[this.ordinalAccessor]){this.eventsTooltip({data:t,evt:o,isToShow:true})}}onMouseOutHandler(){pt(this.chartID,false);this.mouseOutEvent.emit();if(this.showTooltip){this.eventsTooltip({isToShow:false})}}setTooltipInitialStyle(){bt(this.tooltipG)}eventsTooltip({data:t,evt:s,isToShow:i}){lt({root:this.tooltipG,data:t,event:s,isToShow:i,tooltipLabel:this.tooltipLabel,xAxis:this.xAxis,yAxis:this.yAxis,dataLabel:this.dataLabel,dataKeyNames:this.dataKeyNames,layout:this.layout,ordinalAccessor:this.groupAccessor,groupAccessor:this.ordinalAccessor,valueAccessor:this.valueAccessor,chartType:"clustered"})}render(){this.drawStartEvent.emit({chartID:this.chartID});const t="light";this.init();if(this.shouldSetLocalizationConfig){this.setLocalizationConfig();this.shouldSetLocalizationConfig=false}if(this.shouldSetTagLevels){this.setTagLevels();this.shouldSetTagLevels=false}if(this.shouldCheckValueAxis){if(this.layout==="horizontal"){this.shouldUpdateXAxis=true;this.shouldUpdateXGrid=true}else if(this.layout==="vertical"){this.shouldUpdateYAxis=true;this.shouldUpdateYGrid=true}this.shouldCheckValueAxis=false}if(this.shouldCheckLabelAxis){if(this.layout==="vertical"){this.shouldUpdateXAxis=true;this.shouldUpdateXGrid=true;this.shouldSetXAxisAccessibility=true}else if(this.layout==="horizontal"){this.shouldUpdateYAxis=true;this.shouldUpdateYGrid=true;this.shouldSetYAxisAccessibility=true}this.shouldCheckLabelAxis=false}if(this.shouldUpdateData){this.prepareData();this.shouldUpdateData=false}if(this.shouldUpdateLegendData){this.prepareLegendData();this.shouldUpdateLegendData=false}if(this.shouldSetDimensions){this.setDimensions();this.shouldSetDimensions=false}if(this.shouldUpdateScales){this.prepareScales();this.shouldUpdateScales=false}if(this.shouldValidateInteractionKeys){this.validateInteractionKeys();this.shouldValidateInteractionKeys=false}if(this.shouldValidateDataLabelAccessor){this.validateDataLabelAccessor();this.shouldValidateDataLabelAccessor=false}if(this.shouldValidateAxes){this.validateAxes();this.shouldValidateAxes=false}if(this.shouldUpdateTableData){this.setTableData();this.shouldUpdateTableData=false}if(this.shouldValidate){this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.shouldValidate=false}if(this.shouldSetColors){this.setColors();this.shouldSetColors=false}if(this.shouldValidateLabelPlacement){this.validateLabelPlacement();this.shouldValidateLabelPlacement=false}return i("div",{key:"655d50cd007ed19689c72c54a65ec370f2616534",class:`o-layout is--${this.layout} ${t}`},i("div",{key:"6368d0c93419b787be534de0ed228c7b951edbfd",class:"o-layout--chart"},i(this.topLevel,{key:"219b3779486b8231884f877b01e2770f68b89419",class:"clustered-bar-main-title vcl-main-title"},this.mainTitle),i(this.bottomLevel,{key:"80f6249bd25e54ff49204974b0fdb9a30aad0131",class:"visa-ui-text--instructions clustered-bar-sub-title vcl-sub-title"}),i("div",{key:"bc922958dbb7f8cca02b27bf455735fbd9a2c462",class:"clustered-bar-legend vcl-legend",style:{display:this.legend.visible?"block":"none"}}),i("keyboard-instructions",{key:"8d5e59373c9fc9368b1ff2b06005fb40dcd0c1f3",uniqueID:this.chartID,geomType:"bar",groupName:"cluster",language:this.getLanguageString(),chartTag:"clustered-bar-chart",width:this.width-(this.margin?this.margin.right||0:0),isInteractive:this.accessibility.elementsAreInterface,hasCousinNavigation:true,disabled:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled}),i("div",{key:"e55b4ad8776710ba2c7571b85c39104fd354dcc7",class:"visa-viz-d3-clustered-bar-container"}),i("div",{key:"bdf63720f6dc6c32db649bc8349c2730b43989b1",class:"clustered-bar-tooltip vcl-tooltip",style:{display:this.showTooltip?"block":"none"}}),i("data-table",{key:"98178b70d0da1ff4f49948513dc7548dd081b5f4",uniqueID:this.chartID,isCompact:true,language:this.getLanguageString(),tableColumns:this.tableColumns,dataKeyNames:this.dataKeyNames,data:this.tableData,padding:this.padding,margin:this.margin,hideDataTable:this.accessibility.hideDataTableButton,unitTest:this.unitTest})))}init(){const t=Object.keys(p);let s=0;const i={mainTitle:{exception:""},subTitle:{exception:""},barIntervalRatio:{exception:0},groupIntervalRatio:{exception:0},showTooltip:{exception:false},wrapLabel:{exception:false},hoverOpacity:{exception:0}};for(s=0;s<t.length;s++){const e=!i[t[s]]?false:this[t[s]]===i[t[s]].exception;this[t[s]]=this[t[s]]||e?this[t[s]]:p[t[s]]}}get clusteredBarChartEl(){return e(this)}static get watchers(){return{data:["dataWatcher"],uniqueID:["idWatcher"],highestHeadingLevel:["headingWatcher"],mainTitle:["titleWatcher"],subTitle:["subtitleWatcher"],height:["dimensionWatcher"],width:["dimensionWatcher"],padding:["dimensionWatcher"],margin:["dimensionWatcher"],layout:["layoutWatcher"],ordinalAccessor:["ordinalAccessorWatcher"],valueAccessor:["valueAccessorWatcher"],groupAccessor:["groupAccessorWatcher"],reverseOrder:["reverseOrderWatcher"],xAxis:["xAxisWatcher"],yAxis:["yAxisWatcher"],wrapLabel:["wrapLabelWatcher"],colors:["colorsWatcher"],colorPalette:["colorsWatcher"],hoverStyle:["hoverStyleWatcher"],clickStyle:["clickStyleWatcher"],referenceLines:["referenceWatcher"],referenceStyle:["referenceWatcher"],cursor:["cursorWatcher"],roundedCorner:["cornerWatcher"],barIntervalRatio:["intervalRatioWatcher"],groupIntervalRatio:["groupIntervalRatioWatcher"],hoverOpacity:["hoverOpacityWatcher"],dataLabel:["labelWatcher"],tooltipLabel:["tooltipLabelWatcher"],accessibility:["accessibilityWatcher"],legend:["legendWatcher"],localization:["localizationWatcher"],annotations:["annotationsWatcher"],maxValueOverride:["valueOverrideWatcher"],minValueOverride:["valueOverrideWatcher"],clickHighlight:["clickWatcher"],hoverHighlight:["hoverWatcher"],interactionKeys:["interactionWatcher"],dataKeyNames:["dataKeyNamesWatcher"],suppressEvents:["suppressWatcher"],unitTest:["unitTestWatcher"]}}};window["VisaChartsLibOSSLicenses"]=ut();Ct.style=v;export{Ct as clustered_bar_chart};
//# sourceMappingURL=p-40772726.entry.js.map