/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent.structure;

import dr.evolution.coalescent.IntervalType;

public class Event
implements Comparable {
    double time;
    int[] lineageChanges;
    private IntervalType type;
    private int aboveColour;
    private int belowColour;

    public static Event createCoalescentEvent(double d, int n, int n2) {
        int[] nArray = new int[n2];
        nArray[n] = -1;
        return new Event(d, IntervalType.COALESCENT, nArray, n, n);
    }

    public static Event createAddSampleEvent(double d, int n, int n2) {
        int[] nArray = new int[n2];
        nArray[n] = 1;
        return new Event(d, IntervalType.SAMPLE, nArray, n, n);
    }

    public static Event createMigrationEvent(double d, int n, int n2, int n3) {
        int[] nArray = new int[n3];
        nArray[n] = -1;
        nArray[n2] = 1;
        return new Event(d, IntervalType.MIGRATION, nArray, n2, n);
    }

    private Event(double d, IntervalType intervalType, int[] nArray, int n, int n2) {
        this.time = d;
        this.type = intervalType;
        this.lineageChanges = nArray;
        this.aboveColour = n;
        this.belowColour = n2;
    }

    public int getAboveColour() {
        return this.aboveColour;
    }

    public int getBelowColour() {
        return this.belowColour;
    }

    public IntervalType getType() {
        return this.type;
    }

    public String toString() {
        return (Object)((Object)this.type) + " event at time " + this.time + " (above=" + this.aboveColour + ", below=" + this.belowColour + ")";
    }

    public int compareTo(Object object) {
        Event event = (Event)object;
        return new Double(this.time).compareTo(event.time);
    }
}

