/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;

public class RandomEffectsTreeTraitProvider
implements TreeTraitProvider,
TreeTrait<Double> {
    private final ArbitraryBranchRates branchRates;
    private final String traitName;
    private final boolean takeLog;

    public RandomEffectsTreeTraitProvider(ArbitraryBranchRates arbitraryBranchRates, String string, boolean bl) {
        this.branchRates = arbitraryBranchRates;
        this.traitName = string;
        this.takeLog = bl;
    }

    @Override
    public String getTraitName() {
        return this.traitName;
    }

    @Override
    public TreeTrait.Intent getIntent() {
        return TreeTrait.Intent.BRANCH;
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return new TreeTrait[]{this};
    }

    @Override
    public Class getTraitClass() {
        return Double.class;
    }

    @Override
    public boolean getLoggable() {
        return true;
    }

    @Override
    public Double getTrait(Tree tree, NodeRef nodeRef) {
        double d = this.branchRates.getUntransformedBranchRate(tree, nodeRef);
        if (this.takeLog) {
            d = Math.log(d);
        }
        return d;
    }

    @Override
    public String getTraitString(Tree tree, NodeRef nodeRef) {
        return Double.toString(this.getTrait(tree, nodeRef));
    }
}

