/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.IntersectionBounds;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.inference.parallel.MPIServices;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface Parameter
extends Statistic,
Variable<Double> {
    public static final Set<Parameter> FULL_PARAMETER_SET = new LinkedHashSet<Parameter>();
    public static final Set<Parameter> CONNECTED_PARAMETER_SET = new LinkedHashSet<Parameter>();

    public double getParameterValue(int var1);

    public double[] getParameterValues();

    public void setParameterValue(int var1, double var2);

    public void setParameterValueQuietly(int var1, double var2);

    public void setParameterValueNotifyChangedAll(int var1, double var2);

    public String getParameterName();

    public void addParameterListener(VariableListener var1);

    public void removeParameterListener(VariableListener var1);

    public void storeParameterValues();

    public void restoreParameterValues();

    public void acceptParameterValues();

    public void adoptParameterValues(Parameter var1);

    public boolean isWithinBounds();

    public boolean check();

    public void setDimension(int var1);

    @Override
    public void addBounds(Bounds<Double> var1);

    @Override
    public Bounds<Double> getBounds();

    public void addDimension(int var1, double var2);

    public double removeDimension(int var1);

    public void fireParameterChangedEvent();

    public void fireParameterChangedEvent(int var1, Variable.ChangeType var2);

    public boolean isUsed();

    public double getParameterUntransformedValue(int var1);

    public void setParameterUntransformedValue(int var1, double var2);

    default public void setAllParameterValuesQuietly(double[] dArray) {
        if (dArray.length != this.getDimension()) {
            throw new IllegalArgumentException("supplied values must be of same dimension as parameter");
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            this.setParameterValueQuietly(i, dArray[i]);
        }
    }

    public boolean isImmutable();

    public static abstract class Proxy
    extends Abstract {
        private final String name;
        protected final int dim;

        public Proxy(String string, int n) {
            this.name = string;
            this.dim = n;
        }

        @Override
        public int getDimension() {
            return this.dim;
        }

        @Override
        public String getParameterName() {
            return this.name;
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
            throw new RuntimeException("Not implemented for proxy '" + this.name + "'");
        }

        @Override
        public Bounds<Double> getBounds() {
            throw new RuntimeException("Not implemented for proxy '" + this.name + "'");
        }

        @Override
        public void addDimension(int n, double d) {
            throw new RuntimeException("Not implemented for proxy '" + this.name + "'");
        }

        @Override
        public double removeDimension(int n) {
            throw new RuntimeException("Not implemented for proxy '" + this.name + "'");
        }

        @Override
        protected void storeValues() {
        }

        @Override
        protected void restoreValues() {
        }

        @Override
        protected void acceptValues() {
        }

        @Override
        protected void adoptValues(Parameter parameter) {
        }
    }

    public static class DefaultBounds
    implements Bounds<Double> {
        private final double[] uppers;
        private final double[] lowers;

        public DefaultBounds(double d, double d2, int n) {
            this.uppers = new double[n];
            this.lowers = new double[n];
            for (int i = 0; i < n; ++i) {
                this.uppers[i] = d;
                this.lowers[i] = d2;
            }
        }

        public DefaultBounds(double[] dArray, double[] dArray2) {
            if (dArray.length != dArray2.length) {
                throw new IllegalArgumentException("upper and lower limits must be defined on the same number of dimensions.");
            }
            this.uppers = dArray;
            this.lowers = dArray2;
        }

        @Override
        public Double getUpperLimit(int n) {
            return this.uppers[n];
        }

        @Override
        public Double getLowerLimit(int n) {
            return this.lowers[n];
        }

        @Override
        public int getBoundsDimension() {
            return this.uppers.length;
        }

        public boolean isConstant() {
            return true;
        }
    }

    public static class Default
    extends Abstract {
        private double[] values;
        private double[] storedValues;
        private Bounds<Double> bounds = null;

        public Default(String string, int n) {
            this(n);
            this.setId(string);
        }

        public Default(String string) {
            this(1);
            this.setId(string);
        }

        public Default(int n) {
            this(n, 1.0);
        }

        public Default(String string, double d) {
            this(d);
            this.setId(string);
        }

        public Default(double d) {
            this.values = new double[1];
            this.values[0] = d;
            this.bounds = null;
        }

        public Default(String string, double d, double d2, double d3) {
            this(d);
            this.setId(string);
            this.addBounds(new DefaultBounds(d3, d2, 1));
        }

        public Default(int n, double d) {
            this.values = new double[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = d;
            }
            this.bounds = null;
        }

        public Default(String string, double[] dArray) {
            this(dArray);
            this.setId(string);
        }

        public Default(double[] dArray) {
            this.values = new double[dArray.length];
            System.arraycopy(dArray, 0, this.values, 0, dArray.length);
        }

        public Default(String string, int n, double d) {
            this(n, d);
            this.setId(string);
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
            if (this.bounds == null) {
                this.bounds = bounds;
            } else {
                if (!(this.bounds instanceof IntersectionBounds)) {
                    IntersectionBounds intersectionBounds = new IntersectionBounds(this.getDimension());
                    intersectionBounds.addBounds(this.bounds);
                    this.bounds = intersectionBounds;
                }
                ((IntersectionBounds)this.bounds).addBounds(bounds);
            }
        }

        @Override
        public final int getDimension() {
            return this.values.length;
        }

        @Override
        public final int getSize() {
            return this.getDimension();
        }

        @Override
        public final double getParameterValue(int n) {
            return this.values[n];
        }

        @Override
        public final double[] getParameterValues() {
            double[] dArray = new double[this.values.length];
            System.arraycopy(this.values, 0, dArray, 0, dArray.length);
            return dArray;
        }

        public final double[] inspectParameterValues() {
            return this.values;
        }

        @Override
        public Bounds<Double> getBounds() {
            if (this.bounds == null) {
                throw new NullPointerException(this.getParameterName() + " parameter: Bounds not set");
            }
            return this.bounds;
        }

        @Override
        public String getParameterName() {
            return this.getId();
        }

        @Override
        public void setDimension(int n) {
            int n2;
            int n3 = this.getDimension();
            if (n3 == n) {
                return;
            }
            assert (this.storedValues == null) : "Can't change dimension after store has been called! storedValues=" + Arrays.toString(this.storedValues) + " bounds=" + this.bounds;
            double[] dArray = new double[n];
            System.arraycopy(this.values, 0, dArray, 0, Math.min(n3, n));
            for (n2 = n3; n2 < n; ++n2) {
                dArray[n2] = this.values[0];
            }
            this.values = dArray;
            if (this.bounds != null) {
                for (n2 = 1; n2 < n3; ++n2) {
                    assert (this.bounds.getLowerLimit(n2).doubleValue() == this.bounds.getLowerLimit(0).doubleValue() && this.bounds.getUpperLimit(n2).doubleValue() == this.bounds.getUpperLimit(0).doubleValue()) : "Can't change dimension when bounds are not all equal";
                }
                double d = this.bounds.getLowerLimit(0);
                double d2 = this.bounds.getUpperLimit(0);
                this.bounds = null;
                this.addBounds(d, d2);
            }
        }

        @Override
        public void addDimension(int n, double d) {
            assert (this.bounds == null);
            int n2 = this.values.length;
            double[] dArray = new double[n2 + 1];
            System.arraycopy(this.values, 0, dArray, 0, n);
            dArray[n] = d;
            System.arraycopy(this.values, n, dArray, n + 1, n2 - n);
            this.values = dArray;
            this.fireParameterChangedEvent(n, Variable.ChangeType.ADDED);
        }

        @Override
        public double removeDimension(int n) {
            assert (this.bounds == null);
            int n2 = this.values.length;
            double d = this.values[n];
            double[] dArray = new double[n2 - 1];
            System.arraycopy(this.values, 0, dArray, 0, n);
            System.arraycopy(this.values, n, dArray, n - 1, n2 - n);
            this.values = dArray;
            this.fireParameterChangedEvent(n, Variable.ChangeType.REMOVED);
            return d;
        }

        @Override
        public void setParameterValue(int n, double d) {
            this.values[n] = d;
            this.fireParameterChangedEvent(n, Variable.ChangeType.VALUE_CHANGED);
        }

        @Override
        public void setParameterValueQuietly(int n, double d) {
            this.values[n] = d;
        }

        @Override
        public void setParameterValueNotifyChangedAll(int n, double d) {
            this.values[n] = d;
            this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
        }

        @Override
        protected final void storeValues() {
            if (this.storedValues == null || this.storedValues.length != this.values.length) {
                this.storedValues = new double[this.values.length];
            }
            System.arraycopy(this.values, 0, this.storedValues, 0, this.storedValues.length);
        }

        @Override
        protected final void restoreValues() {
            double[] dArray = this.storedValues;
            this.storedValues = this.values;
            this.values = dArray;
        }

        @Override
        protected final void acceptValues() {
        }

        @Override
        protected final void adoptValues(Parameter parameter) {
            if (this.getDimension() != parameter.getDimension()) {
                throw new RuntimeException("The two parameters don't have the same number of dimensions");
            }
            int n = this.getDimension();
            for (int i = 0; i < n; ++i) {
                this.values[i] = parameter.getParameterValue(i);
            }
        }

        public void addBounds(double d, double d2) {
            this.addBounds(new DefaultBounds(d2, d, this.getDimension()));
        }
    }

    public static abstract class Abstract
    extends Statistic.Abstract
    implements Parameter,
    Reportable {
        private boolean isValid = true;
        private ArrayList<VariableListener> listeners;
        private String[] dimensionNames = null;

        protected Abstract() {
            FULL_PARAMETER_SET.add(this);
        }

        protected Abstract(String string) {
            super(string);
            FULL_PARAMETER_SET.add(this);
        }

        void sendState(int n) {
            double[] dArray = this.getParameterValues();
            MPIServices.sendDoubleArray(dArray, n);
        }

        void receiveState(int n) {
            int n2 = this.getDimension();
            double[] dArray = MPIServices.receiveDoubleArray(n, n2);
            for (int i = 0; i < n2; ++i) {
                this.setParameterValueQuietly(i, dArray[i]);
            }
            this.fireParameterChangedEvent();
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public void fireParameterChangedEvent() {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.VALUE_CHANGED);
        }

        @Override
        public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
            if (this.listeners != null) {
                for (VariableListener variableListener : this.listeners) {
                    variableListener.variableChangedEvent(this, n, changeType);
                }
            }
        }

        @Override
        public final void addParameterListener(VariableListener variableListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(variableListener);
        }

        @Override
        public final void removeParameterListener(VariableListener variableListener) {
            if (this.listeners != null) {
                this.listeners.remove(variableListener);
            }
        }

        @Override
        public final String getStatisticName() {
            return this.getParameterName();
        }

        @Override
        public final double getStatisticValue(int n) {
            return this.getParameterValue(n);
        }

        @Override
        public String getDimensionName(int n) {
            if (this.dimensionNames == null) {
                return super.getDimensionName(n);
            }
            return this.dimensionNames[n];
        }

        @Override
        public final void setDimensionNames(String[] stringArray) {
            if (stringArray != null && stringArray.length != this.getDimension()) {
                throw new IllegalArgumentException("Length of dimension name array doesn't match the number of dimensions");
            }
            this.dimensionNames = stringArray;
        }

        @Override
        public void setDimension(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] getParameterValues() {
            double[] dArray = new double[this.getDimension()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.getParameterValue(i);
            }
            return dArray;
        }

        @Override
        public final void storeParameterValues() {
            if (this.isValid) {
                this.storeValues();
                this.isValid = false;
            }
        }

        @Override
        public final void restoreParameterValues() {
            if (!this.isValid) {
                this.restoreValues();
                this.isValid = true;
            }
        }

        @Override
        public final void acceptParameterValues() {
            if (!this.isValid) {
                this.acceptValues();
                this.isValid = true;
            }
        }

        @Override
        public final void adoptParameterValues(Parameter parameter) {
            this.adoptValues(parameter);
            this.isValid = true;
        }

        @Override
        public boolean isWithinBounds() {
            Bounds<Double> bounds = this.getBounds();
            for (int i = 0; i < this.getDimension(); ++i) {
                double d = this.getParameterValue(i);
                if (!(d < bounds.getLowerLimit(i)) && !(d > bounds.getUpperLimit(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean check() {
            return true;
        }

        @Override
        public void setParameterUntransformedValue(int n, double d) {
            this.setParameterValue(n, d);
        }

        @Override
        public double getParameterUntransformedValue(int n) {
            return this.getParameterValue(n);
        }

        @Override
        public final String getVariableName() {
            return this.getParameterName();
        }

        @Override
        public final Double getValue(int n) {
            return this.getParameterValue(n);
        }

        @Override
        public final void setValue(int n, Double d) {
            this.setParameterValue(n, d);
        }

        public Double[] getValues() {
            Double[] doubleArray = new Double[this.getDimension()];
            for (int i = 0; i < this.getDimension(); ++i) {
                doubleArray[i] = this.getValue(i);
            }
            return doubleArray;
        }

        @Override
        public int getSize() {
            return this.getDimension();
        }

        @Override
        public final void addVariableListener(VariableListener variableListener) {
            this.addParameterListener(variableListener);
        }

        @Override
        public final void removeVariableListener(VariableListener variableListener) {
            this.removeParameterListener(variableListener);
        }

        @Override
        public void storeVariableValues() {
            this.storeParameterValues();
        }

        @Override
        public void restoreVariableValues() {
            this.restoreParameterValues();
        }

        @Override
        public void acceptVariableValues() {
            this.acceptParameterValues();
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public boolean isUsed() {
            return this.listeners != null && this.listeners.size() > 0;
        }

        protected abstract void storeValues();

        protected abstract void restoreValues();

        protected abstract void acceptValues();

        protected abstract void adoptValues(Parameter var1);

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getParameterValue(0)));
            Bounds<Double> bounds = null;
            try {
                bounds = this.getBounds();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            String string = this.getId();
            if (string != null) {
                stringBuilder.append(", ").append(string);
            }
            if (bounds != null) {
                stringBuilder.append("=[").append(String.valueOf(bounds.getLowerLimit(0)));
                stringBuilder.append(", ").append(String.valueOf(bounds.getUpperLimit(0))).append("]");
            }
            for (int i = 1; i < this.getDimension(); ++i) {
                stringBuilder.append(", ").append(String.valueOf(this.getParameterValue(i)));
                if (bounds == null) continue;
                stringBuilder.append("[").append(String.valueOf(bounds.getLowerLimit(i)));
                stringBuilder.append(", ").append(String.valueOf(bounds.getUpperLimit(i))).append("]");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getReport() {
            StringBuilder stringBuilder = new StringBuilder();
            Bounds<Double> bounds = null;
            try {
                bounds = this.getBounds();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            for (int i = 0; i < this.getDimension(); ++i) {
                if (this.getDimensionName(i) != null) {
                    stringBuilder.append(this.getDimensionName(i)).append("=");
                }
                stringBuilder.append(String.valueOf(this.getParameterValue(i)));
                if (bounds != null) {
                    stringBuilder.append("[");
                    try {
                        stringBuilder.append(String.valueOf(bounds.getLowerLimit(i)));
                        stringBuilder.append(", ").append(String.valueOf(bounds.getUpperLimit(i)));
                    }
                    catch (NullPointerException nullPointerException) {
                        stringBuilder.append("no bounds");
                    }
                    stringBuilder.append("]");
                }
                if (i >= this.getDimension() - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }

        public Element createElement(Document document) {
            throw new IllegalArgumentException();
        }
    }
}

