/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.shrinkage.BayesianBridgeRNG;
import dr.inference.distribution.shrinkage.JointBayesianBridgeDistributionModel;
import dr.inference.model.Statistic;
import dr.inference.operators.shrinkage.BayesianBridgeShrinkageOperator;
import dr.math.distributions.GammaDistribution;
import dr.math.matrixAlgebra.Vector;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class BayesianBridgeGlobalScaleEffectivePriorSampler
extends Statistic.Abstract
implements Reportable {
    public static final String PRIOR_SAMPLER = "bayesianBridgeGlobalScaleEffectivePriorSampler";
    BayesianBridgeShrinkageOperator operator;
    JointBayesianBridgeDistributionModel bridge;
    private final GammaDistribution globalScalePrior;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(JointBayesianBridgeDistributionModel.class), new ElementRule(DistributionLikelihood.class)};

        @Override
        public String getParserName() {
            return BayesianBridgeGlobalScaleEffectivePriorSampler.PRIOR_SAMPLER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            JointBayesianBridgeDistributionModel jointBayesianBridgeDistributionModel = (JointBayesianBridgeDistributionModel)xMLObject.getChild(JointBayesianBridgeDistributionModel.class);
            GammaDistribution gammaDistribution = null;
            DistributionLikelihood distributionLikelihood = (DistributionLikelihood)xMLObject.getChild(DistributionLikelihood.class);
            if (distributionLikelihood != null) {
                if (distributionLikelihood.getDistribution() instanceof GammaDistribution) {
                    gammaDistribution = (GammaDistribution)distributionLikelihood.getDistribution();
                } else {
                    throw new XMLParseException("Currently only gamma prior on global scale implemented.");
                }
            }
            BayesianBridgeGlobalScaleEffectivePriorSampler bayesianBridgeGlobalScaleEffectivePriorSampler = new BayesianBridgeGlobalScaleEffectivePriorSampler(jointBayesianBridgeDistributionModel, gammaDistribution);
            return bayesianBridgeGlobalScaleEffectivePriorSampler;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Samples from the conditional of the global scale (conditioned on the shrunken-shoulder-regularization) for a Bayesian Bridge distribution.";
        }

        @Override
        public Class getReturnType() {
            return BayesianBridgeGlobalScaleEffectivePriorSampler.class;
        }
    };

    public BayesianBridgeGlobalScaleEffectivePriorSampler(JointBayesianBridgeDistributionModel jointBayesianBridgeDistributionModel, GammaDistribution gammaDistribution) {
        this.bridge = new JointBayesianBridgeDistributionModel(jointBayesianBridgeDistributionModel.getGlobalScale(), jointBayesianBridgeDistributionModel.getLocalScale(), jointBayesianBridgeDistributionModel.getExponent(), jointBayesianBridgeDistributionModel.getSlabWidth(), jointBayesianBridgeDistributionModel.getDimension(), false);
        this.globalScalePrior = gammaDistribution;
        this.operator = new BayesianBridgeShrinkageOperator(this.bridge, gammaDistribution, null, Double.MIN_VALUE);
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Using bridge with following parameters:").append("\n");
        stringBuilder.append("  globalScale named ").append(this.bridge.getGlobalScale().getParameterName()).append(" and current value ").append(this.bridge.getGlobalScale().getParameterValue(0)).append("\n");
        stringBuilder.append("  localScale named ").append(this.bridge.getLocalScale().getParameterName()).append(" and current value ").append(new Vector(this.bridge.getLocalScale().getParameterValues())).append("\n");
        stringBuilder.append("  exponent named ").append(this.bridge.getExponent().getParameterName()).append(" and current value ").append(this.bridge.getExponent().getParameterValue(0)).append("\n");
        stringBuilder.append("  slabWidth named ").append(this.bridge.getSlabWidth().getParameterName()).append(" and current value ").append(this.bridge.getSlabWidth().getParameterValue(0)).append("\n");
        stringBuilder.append("Bridge gamma prior has shape with current value ").append(this.globalScalePrior.getShape()).append("and scale with current value ").append(this.globalScalePrior.getScale()).append("\n");
        return stringBuilder.toString();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    private double sampleGlobalScalePrior() {
        double d = this.globalScalePrior.getShape();
        double d2 = this.globalScalePrior.getScale();
        double d3 = this.bridge.getExponent().getParameterValue(0);
        double d4 = GammaDistribution.nextGamma(d, d2);
        double d5 = Math.pow(d4, -1.0 / d3);
        return d5;
    }

    private double[] nextRandom() {
        double d = this.sampleGlobalScalePrior();
        double[] dArray = this.bridge.getSlabWidth() != null ? BayesianBridgeRNG.nextRandom(d, this.bridge.getExponent().getParameterValue(0), this.bridge.getSlabWidth().getParameterValue(0), this.bridge.getDimension()) : BayesianBridgeRNG.nextRandom(d, this.bridge.getExponent().getParameterValue(0), this.bridge.getDimension());
        return dArray;
    }

    @Override
    public double getStatisticValue(int n) {
        double d = this.bridge.getExponent().getParameterValue(0);
        double[] dArray = this.nextRandom();
        double d2 = 0.0;
        for (int i = 0; i < this.bridge.getDimension(); ++i) {
            d2 += Math.pow(dArray[i], 2.0);
        }
        return d2;
    }
}

