/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.materializer;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.conversions.ConversionUtil;
import com.amazon.sqlengine.executor.conversions.ISqlConverter;
import com.amazon.sqlengine.executor.conversions.SqlConverterGenerator;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalConvert;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.value.ETConstant;
import com.amazon.sqlengine.executor.etree.value.ETConvert;
import com.amazon.sqlengine.executor.etree.value.ETDefault;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public final class ConvMaterializeUtil {
    private ConvMaterializeUtil() {
    }

    public static ETRelationalExpr makeNewRelationConvertNode(IColumn iColumn, ETRelationalExpr eTRelationalExpr, boolean bl, boolean bl2, MaterializerContext materializerContext) throws ErrorException {
        if (1 != eTRelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("column number mismatch");
        }
        SqlConverterGenerator sqlConverterGenerator = materializerContext.getSqlConverterGenerator();
        ISqlConverter iSqlConverter = ConversionUtil.createConverter(sqlConverterGenerator, eTRelationalExpr.getColumn(0), iColumn);
        if (iSqlConverter == null) {
            return eTRelationalExpr;
        }
        ArrayList<ISqlConverter> arrayList = new ArrayList<ISqlConverter>(0);
        arrayList.add(iSqlConverter);
        ArrayList<IColumn> arrayList2 = new ArrayList<IColumn>(1);
        arrayList2.add(iColumn);
        boolean[] blArray = new boolean[]{bl};
        return new ETRelationalConvert(arrayList2, arrayList, bl2, eTRelationalExpr, blArray);
    }

    public static ETRelationalConvert makeNewRelationConvertNode(List<IColumn> list, ETRelationalExpr eTRelationalExpr, boolean[] blArray, boolean bl, MaterializerContext materializerContext) throws ErrorException {
        if (list.size() != eTRelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("column number mismatch");
        }
        ArrayList<ISqlConverter> arrayList = new ArrayList<ISqlConverter>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(ConversionUtil.createConverter(materializerContext.getSqlConverterGenerator(), eTRelationalExpr.getColumn(i), list.get(i)));
        }
        return new ETRelationalConvert(list, arrayList, bl, eTRelationalExpr, blArray);
    }

    public static ETValueExpr addConversionNodeWhenNeeded(ETValueExpr eTValueExpr, IColumn iColumn, IColumn iColumn2, MaterializerContext materializerContext) throws ErrorException {
        return ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, iColumn, iColumn2, false, materializerContext);
    }

    public static ETValueExpr addConversionNodeWhenNeeded(ETValueExpr eTValueExpr, IColumn iColumn, IColumn iColumn2, boolean bl, MaterializerContext materializerContext) throws ErrorException {
        if (eTValueExpr instanceof ETConstant ? ((ETConstant)eTValueExpr).isNull() : eTValueExpr instanceof ETDefault) {
            return eTValueExpr;
        }
        SqlConverterGenerator sqlConverterGenerator = materializerContext.getSqlConverterGenerator();
        ISqlConverter iSqlConverter = ConversionUtil.createConverter(sqlConverterGenerator, iColumn, iColumn2);
        if (iSqlConverter == null) {
            return eTValueExpr;
        }
        return new ETConvert(eTValueExpr, iColumn, iSqlConverter, bl);
    }
}

