/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.DeducerWidget;

public class TextFieldWidget
extends JPanel
implements DeducerWidget,
FocusListener {
    private JLabel titleLabel;
    private JTextField textField;
    private String title = null;
    private boolean show = true;
    private String initialModel;
    private String lastModel;
    private boolean numeric = false;
    private boolean integer = false;
    private boolean hasLowerBound = false;
    private double lowerBound = 0.0;
    private boolean hasUpperBound = false;
    private double upperBound = 0.0;
    public static Color labelColor = new Color(90, 90, 90);

    public TextFieldWidget(String string) {
        this.initGUI();
        this.title = string;
        if (string == null) {
            this.show = false;
        } else {
            this.titleLabel.setText(string);
        }
        this.resetLayout();
    }

    public TextFieldWidget() {
        this((String)null);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(187, 47));
            this.titleLabel = new JLabel();
            this.add((Component)this.titleLabel, new AnchorConstraint(0, 1000, 22, 0, 1, 1, 0, 1));
            this.titleLabel.setText("title");
            this.titleLabel.setPreferredSize(new Dimension(187, 20));
            this.titleLabel.setBounds(0, 0, 187, 20);
            this.titleLabel.setVerticalAlignment(3);
            this.titleLabel.setForeground(labelColor);
            this.textField = new JTextField();
            this.add((Component)this.textField, new AnchorConstraint(22, 1000, 1000, 0, 2, 1, 1, 1));
            this.textField.setPreferredSize(new Dimension(186, 19));
            this.textField.addFocusListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resetLayout() {
        if (this.title == null || !this.show) {
            this.remove(this.titleLabel);
            this.remove(this.textField);
            this.setPreferredSize(new Dimension(187, 22));
            this.add((Component)this.textField, new AnchorConstraint(0, 1000, 1000, 0, 2, 1, 1, 1));
            this.textField.setPreferredSize(new Dimension(186, 19));
        } else {
            this.remove(this.titleLabel);
            this.remove(this.textField);
            this.setPreferredSize(new Dimension(187, 47));
            this.add((Component)this.titleLabel, new AnchorConstraint(0, 1000, 22, 0, 1, 1, 0, 1));
            this.titleLabel.setPreferredSize(new Dimension(187, 20));
            this.titleLabel.setBounds(0, 0, 187, 20);
            this.titleLabel.setVerticalAlignment(3);
            this.add((Component)this.textField, new AnchorConstraint(22, 1000, 1000, 0, 2, 1, 1, 1));
            this.textField.setPreferredSize(new Dimension(186, 19));
        }
    }

    public JLabel getLabel() {
        return this.titleLabel;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setInteger(boolean bl) {
        this.integer = bl;
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setLowerBound(double d) {
        if (!this.numeric && !this.integer) {
            this.numeric = true;
        }
        this.hasLowerBound = true;
        this.lowerBound = d;
    }

    public void removeLowerBound() {
        this.hasLowerBound = false;
        this.lowerBound = Double.MIN_VALUE;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(double d) {
        if (!this.numeric && !this.integer) {
            this.numeric = true;
        }
        this.hasUpperBound = true;
        this.upperBound = d;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void removeUpperBound() {
        this.hasUpperBound = false;
        this.upperBound = Double.MAX_VALUE;
    }

    public String getValidatedText() {
        double d;
        String string = this.textField.getText();
        if (string == null) {
            string = "";
        }
        if (this.integer) {
            try {
                d = Double.parseDouble(string);
                int n = (int)Math.round(d);
                string = "" + n;
                if (this.hasLowerBound && (double)n < this.lowerBound) {
                    string = "" + Math.ceil(this.lowerBound);
                }
                if (this.hasUpperBound && (double)n > this.upperBound) {
                    string = "" + Math.floor(this.upperBound);
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = "";
            }
        }
        if (this.numeric) {
            try {
                d = Double.parseDouble(string);
                if (this.hasLowerBound && d < this.lowerBound) {
                    string = "" + this.lowerBound;
                }
                if (this.hasUpperBound && d > this.upperBound) {
                    string = "" + this.upperBound;
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        String string = this.getValidatedText();
        this.textField.setText(string);
    }

    @Override
    public Object getModel() {
        return this.textField.getText();
    }

    @Override
    public String getRModel() {
        return "\"" + Deducer.addSlashes((String)this.getModel()) + "\"";
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void reset() {
        this.setModel(this.initialModel);
    }

    @Override
    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    @Override
    public void setDefaultModel(Object object) {
        this.initialModel = (String)object;
        if (this.lastModel == null) {
            this.lastModel = (String)object;
        }
    }

    @Override
    public void setLastModel(Object object) {
        this.lastModel = (String)object;
    }

    @Override
    public void setModel(Object object) {
        if (object == null) {
            object = "";
        }
        this.textField.setText((String)object);
    }

    @Override
    public void setTitle(String string, boolean bl) {
        this.title = string;
        this.titleLabel.setText(this.title);
        this.show = bl;
        this.resetLayout();
    }

    @Override
    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

