/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.sampling.DoubleRandomSampler;
import cern.jet.stat.tdouble.DoubleDescriptive;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.DoubleIHistogram3D;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DynamicDoubleBin1D;
import hep.aida.tdouble.ref.DoubleHistogram2D;
import hep.aida.tdouble.ref.DoubleHistogram3D;
import hep.aida.tdouble.ref.DoubleVariableAxis;
import java.util.concurrent.Future;

public class DoubleStatistic {
    private static final DoubleFunctions F = DoubleFunctions.functions;
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return Math.sqrt(doubleMatrix1D.aggregate(doubleMatrix1D2, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.square, DoubleFunctions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return doubleMatrix1D.aggregate(doubleMatrix1D2, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.abs, DoubleFunctions.minus)) / doubleMatrix1D.aggregate(doubleMatrix1D2, DoubleFunctions.plus, DoubleFunctions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        DoubleDoubleFunction fun = new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return Math.abs(d - d2) / Math.abs(d + d2);
            }
        };

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return doubleMatrix1D.aggregate(doubleMatrix1D2, DoubleFunctions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return doubleMatrix1D.aggregate(doubleMatrix1D2, DoubleFunctions.max, DoubleFunctions.chain(DoubleFunctions.abs, DoubleFunctions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return doubleMatrix1D.aggregate(doubleMatrix1D2, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.abs, DoubleFunctions.minus));
        }
    };

    protected DoubleStatistic() {
    }

    public static DoubleMatrix2D aggregate(DoubleMatrix2D doubleMatrix2D, DoubleBinFunction1D[] doubleBinFunction1DArray, DoubleMatrix2D doubleMatrix2D2) {
        DynamicDoubleBin1D dynamicDoubleBin1D = new DynamicDoubleBin1D();
        double[] dArray = new double[doubleMatrix2D.rows()];
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        int n = doubleMatrix2D.columns();
        while (--n >= 0) {
            doubleMatrix2D.viewColumn(n).toArray(dArray);
            dynamicDoubleBin1D.clear();
            dynamicDoubleBin1D.addAllOf(doubleArrayList);
            int n2 = doubleBinFunction1DArray.length;
            while (--n2 >= 0) {
                doubleMatrix2D2.set(n2, n, doubleBinFunction1DArray[n2].apply(dynamicDoubleBin1D));
            }
        }
        return doubleMatrix2D2;
    }

    public static DynamicDoubleBin1D bin(DoubleMatrix1D doubleMatrix1D) {
        DynamicDoubleBin1D dynamicDoubleBin1D = new DynamicDoubleBin1D();
        dynamicDoubleBin1D.addAllOf(DoubleFactory1D.dense.toList(doubleMatrix1D));
        return dynamicDoubleBin1D;
    }

    public static DoubleMatrix2D correlation(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.columns();
        while (--n >= 0) {
            int n2 = n;
            while (--n2 >= 0) {
                double d = Math.sqrt(doubleMatrix2D.getQuick(n, n));
                double d2 = Math.sqrt(doubleMatrix2D.getQuick(n2, n2));
                double d3 = doubleMatrix2D.getQuick(n, n2);
                double d4 = d3 / (d * d2);
                doubleMatrix2D.setQuick(n, n2, d4);
                doubleMatrix2D.setQuick(n2, n, d4);
            }
        }
        n = doubleMatrix2D.columns();
        while (--n >= 0) {
            doubleMatrix2D.setQuick(n, n, 1.0);
        }
        return doubleMatrix2D;
    }

    public static DoubleMatrix2D covariance(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n2);
        double[] dArray = new double[n2];
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            doubleMatrix1DArray[n3] = doubleMatrix2D.viewColumn(n3);
            dArray[n3] = doubleMatrix1DArray[n3].zSum();
        }
        n3 = n2;
        while (--n3 >= 0) {
            int n4 = n3 + 1;
            while (--n4 >= 0) {
                double d = doubleMatrix1DArray[n3].zDotProduct(doubleMatrix1DArray[n4]);
                double d2 = (d - dArray[n3] * dArray[n4] / (double)n) / (double)n;
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n3, n4, d2);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n4, n3, d2);
            }
        }
        return denseDoubleMatrix2D;
    }

    public static DoubleIHistogram2D cube(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D2.size() != doubleMatrix1D3.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        double d = 1.0E-5f;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        double[] dArray = new double[(int)doubleMatrix1D.size()];
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray);
        doubleMatrix1D.toArray(dArray);
        doubleArrayList2.sort();
        DoubleDescriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        DoubleVariableAxis doubleVariableAxis = new DoubleVariableAxis(doubleArrayList.elements());
        doubleMatrix1D2.toArray(dArray);
        doubleArrayList2.sort();
        DoubleDescriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        DoubleVariableAxis doubleVariableAxis2 = new DoubleVariableAxis(doubleArrayList.elements());
        DoubleHistogram2D doubleHistogram2D = new DoubleHistogram2D("Cube", doubleVariableAxis, doubleVariableAxis2);
        return DoubleStatistic.histogram(doubleHistogram2D, doubleMatrix1D, doubleMatrix1D2, doubleMatrix1D3);
    }

    public static DoubleIHistogram3D cube(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3, DoubleMatrix1D doubleMatrix1D4) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D.size() != doubleMatrix1D3.size() || doubleMatrix1D.size() != doubleMatrix1D4.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        double d = 1.0E-5f;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        double[] dArray = new double[(int)doubleMatrix1D.size()];
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray);
        doubleMatrix1D.toArray(dArray);
        doubleArrayList2.sort();
        DoubleDescriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        DoubleVariableAxis doubleVariableAxis = new DoubleVariableAxis(doubleArrayList.elements());
        doubleMatrix1D2.toArray(dArray);
        doubleArrayList2.sort();
        DoubleDescriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        DoubleVariableAxis doubleVariableAxis2 = new DoubleVariableAxis(doubleArrayList.elements());
        doubleMatrix1D3.toArray(dArray);
        doubleArrayList2.sort();
        DoubleDescriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        DoubleVariableAxis doubleVariableAxis3 = new DoubleVariableAxis(doubleArrayList.elements());
        DoubleHistogram3D doubleHistogram3D = new DoubleHistogram3D("Cube", doubleVariableAxis, doubleVariableAxis2, doubleVariableAxis3);
        return DoubleStatistic.histogram(doubleHistogram3D, doubleMatrix1D, doubleMatrix1D2, doubleMatrix1D3, doubleMatrix1D4);
    }

    public static void demo1() {
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {2.0, 4.0, 6.0}, {3.0, 6.0, 9.0}, {4.0, -8.0, -10.0}};
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray);
        System.out.println("\n\nmatrix=" + doubleMatrix2D);
        System.out.println("\ncovar1=" + DoubleStatistic.covariance(doubleMatrix2D));
    }

    public static void demo2(int n, int n2, boolean bl) {
        System.out.println("\n\ninitializing...");
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.ascending(n, n2);
        System.out.println("benchmarking correlation...");
        Timer timer = new Timer().start();
        DoubleMatrix2D doubleMatrix2D2 = DoubleStatistic.correlation(DoubleStatistic.covariance(doubleMatrix2D));
        timer.stop().display();
        if (bl) {
            System.out.println("printing result...");
            System.out.println(doubleMatrix2D2);
        }
        System.out.println("done.");
    }

    public static void demo3(VectorVectorFunction vectorVectorFunction) {
        double[][] dArrayArray = new double[][]{{-0.961105227470398, -0.2542109489440918}, {0.4308269f, -0.6993264555931091}, {-1.20710289478302, 0.6203059554100037}, {1.5345165729522705, 0.02135884016752243}, {-1.134154200553894, 0.2038843035697937}};
        System.out.println("\n\ninitializing...");
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray).viewDice();
        System.out.println("\nA=" + doubleMatrix2D.viewDice());
        System.out.println("\ndist=" + DoubleStatistic.distance(doubleMatrix2D, vectorVectorFunction).viewDice());
    }

    public static DoubleMatrix2D distance(DoubleMatrix2D doubleMatrix2D, VectorVectorFunction vectorVectorFunction) {
        int n = doubleMatrix2D.columns();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n);
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n];
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1DArray[n2] = doubleMatrix2D.viewColumn(n2);
        }
        n2 = n;
        while (--n2 >= 0) {
            int n3 = n2;
            while (--n3 >= 0) {
                double d = vectorVectorFunction.apply(doubleMatrix1DArray[n2], doubleMatrix1DArray[n3]);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n2, n3, d);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n3, n2, d);
            }
        }
        return denseDoubleMatrix2D;
    }

    public static DoubleIHistogram1D histogram(DoubleIHistogram1D doubleIHistogram1D, DoubleMatrix1D doubleMatrix1D) {
        int n = (int)doubleMatrix1D.size();
        while (--n >= 0) {
            doubleIHistogram1D.fill(doubleMatrix1D.getQuick(n));
        }
        return doubleIHistogram1D;
    }

    public static DoubleIHistogram1D histogram(DoubleIHistogram1D doubleIHistogram1D, DoubleMatrix2D doubleMatrix2D) {
        doubleIHistogram1D.fill_2D((double[])doubleMatrix2D.elements(), doubleMatrix2D.rows(), doubleMatrix2D.columns(), (int)doubleMatrix2D.index(0, 0), doubleMatrix2D.rowStride(), doubleMatrix2D.columnStride());
        return doubleIHistogram1D;
    }

    public static DoubleIHistogram1D[][] histogram(final DoubleIHistogram1D[][] doubleIHistogram1DArray, final DoubleMatrix2D doubleMatrix2D, int n, final int n2) {
        int n3;
        int n4 = doubleMatrix2D.rows();
        int n5 = doubleMatrix2D.columns();
        if (n >= n4) {
            throw new IllegalArgumentException("Parameter m must be smaller than the number of rows in the matrix");
        }
        if (n2 >= n5) {
            throw new IllegalArgumentException("Parameter n must be smaller than the number of columns in the matrix");
        }
        final int n6 = n4 / n;
        final int n7 = n5 / n2;
        final int[] nArray = new int[n];
        final int[] nArray2 = new int[n2];
        for (n3 = 0; n3 < n - 1; ++n3) {
            nArray[n3] = n6;
        }
        nArray[n - 1] = n4 - (n - 1) * n6;
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            nArray2[n3] = n7;
        }
        nArray2[n2 - 1] = n5 - (n2 - 1) * n7;
        n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n4 * n5 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n8 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n3 - 1 ? n : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        DoubleMatrix2D doubleMatrix2D2 = null;
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                doubleMatrix2D2 = doubleMatrix2D.viewPart(i * n6, j * n7, nArray[i], nArray2[j]);
                                doubleIHistogram1DArray[i][j].fill_2D((double[])doubleMatrix2D2.elements(), doubleMatrix2D2.rows(), doubleMatrix2D2.columns(), (int)doubleMatrix2D2.index(0, 0), doubleMatrix2D2.rowStride(), doubleMatrix2D2.columnStride());
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            DoubleMatrix2D doubleMatrix2D2 = null;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    doubleMatrix2D2 = doubleMatrix2D.viewPart(i * n6, j * n7, nArray[i], nArray2[j]);
                    doubleIHistogram1DArray[i][j].fill_2D((double[])doubleMatrix2D2.elements(), doubleMatrix2D2.rows(), doubleMatrix2D2.columns(), (int)doubleMatrix2D2.index(0, 0), doubleMatrix2D2.rowStride(), doubleMatrix2D2.columnStride());
                }
            }
        }
        return doubleIHistogram1DArray;
    }

    public static DoubleIHistogram2D histogram(DoubleIHistogram2D doubleIHistogram2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = (int)doubleMatrix1D.size();
        while (--n >= 0) {
            doubleIHistogram2D.fill(doubleMatrix1D.getQuick(n), doubleMatrix1D2.getQuick(n));
        }
        return doubleIHistogram2D;
    }

    public static DoubleIHistogram2D histogram(DoubleIHistogram2D doubleIHistogram2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D2.size() != doubleMatrix1D3.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = (int)doubleMatrix1D.size();
        while (--n >= 0) {
            doubleIHistogram2D.fill(doubleMatrix1D.getQuick(n), doubleMatrix1D2.getQuick(n), doubleMatrix1D3.getQuick(n));
        }
        return doubleIHistogram2D;
    }

    public static DoubleIHistogram3D histogram(DoubleIHistogram3D doubleIHistogram3D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3, DoubleMatrix1D doubleMatrix1D4) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D.size() != doubleMatrix1D3.size() || doubleMatrix1D.size() != doubleMatrix1D4.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = (int)doubleMatrix1D.size();
        while (--n >= 0) {
            doubleIHistogram3D.fill(doubleMatrix1D.getQuick(n), doubleMatrix1D2.getQuick(n), doubleMatrix1D3.getQuick(n), doubleMatrix1D4.getQuick(n));
        }
        return doubleIHistogram3D;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        boolean bl = stringArray[2].equals("print");
        DoubleStatistic.demo2(n, n2, bl);
    }

    public static DoubleMatrix1D viewSample(DoubleMatrix1D doubleMatrix1D, double d, DoubleRandomEngine doubleRandomEngine) {
        int n;
        double d2 = 1.0E-5f;
        if (d < 0.0 - d2 || d > 1.0 + d2) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (doubleRandomEngine == null) {
            doubleRandomEngine = new DoubleMersenneTwister((int)System.currentTimeMillis());
        }
        int n2 = n = (int)Math.round((double)doubleMatrix1D.size() * d);
        long[] lArray = new long[n2];
        int n3 = n;
        int n4 = (int)doubleMatrix1D.size();
        DoubleRandomSampler.sample(n3, n4, n3, 0L, lArray, 0, doubleRandomEngine);
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return doubleMatrix1D.viewSelection(nArray);
    }

    public static DoubleMatrix2D viewSample(DoubleMatrix2D doubleMatrix2D, double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        double d3 = 1.0E-5f;
        if (d < 0.0 - d3 || d > 1.0 + d3) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d2 < 0.0 - d3 || d2 > 1.0 + d3) {
            throw new IllegalArgumentException();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (doubleRandomEngine == null) {
            doubleRandomEngine = new DoubleMersenneTwister((int)System.currentTimeMillis());
        }
        int n = (int)Math.round((double)doubleMatrix2D.rows() * d);
        int n2 = (int)Math.round((double)doubleMatrix2D.columns() * d2);
        int n3 = Math.max(n, n2);
        long[] lArray = new long[n3];
        int n4 = n;
        int n5 = doubleMatrix2D.rows();
        DoubleRandomSampler.sample(n4, n5, n4, 0L, lArray, 0, doubleRandomEngine);
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = (int)lArray[i];
        }
        n4 = n2;
        n5 = doubleMatrix2D.columns();
        DoubleRandomSampler.sample(n4, n5, n4, 0L, lArray, 0, doubleRandomEngine);
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = (int)lArray[i];
        }
        return doubleMatrix2D.viewSelection(nArray, nArray2);
    }

    public static DoubleMatrix3D viewSample(DoubleMatrix3D doubleMatrix3D, double d, double d2, double d3, DoubleRandomEngine doubleRandomEngine) {
        double d4 = 1.0E-5f;
        if (d < 0.0 - d4 || d > 1.0 + d4) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d2 < 0.0 - d4 || d2 > 1.0 + d4) {
            throw new IllegalArgumentException();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d3 < 0.0 - d4 || d3 > 1.0 + d4) {
            throw new IllegalArgumentException();
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (doubleRandomEngine == null) {
            doubleRandomEngine = new DoubleMersenneTwister((int)System.currentTimeMillis());
        }
        int n = (int)Math.round((double)doubleMatrix3D.slices() * d);
        int n2 = (int)Math.round((double)doubleMatrix3D.rows() * d2);
        int n3 = (int)Math.round((double)doubleMatrix3D.columns() * d3);
        int n4 = Math.max(n, Math.max(n2, n3));
        long[] lArray = new long[n4];
        int n5 = n;
        int n6 = doubleMatrix3D.slices();
        DoubleRandomSampler.sample(n5, n6, n5, 0L, lArray, 0, doubleRandomEngine);
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = (int)lArray[i];
        }
        n5 = n2;
        n6 = doubleMatrix3D.rows();
        DoubleRandomSampler.sample(n5, n6, n5, 0L, lArray, 0, doubleRandomEngine);
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray2[i] = (int)lArray[i];
        }
        n5 = n3;
        n6 = doubleMatrix3D.columns();
        DoubleRandomSampler.sample(n5, n6, n5, 0L, lArray, 0, doubleRandomEngine);
        int[] nArray3 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray3[i] = (int)lArray[i];
        }
        return doubleMatrix3D.viewSelection(nArray, nArray2, nArray3);
    }

    public static interface VectorVectorFunction {
        public double apply(DoubleMatrix1D var1, DoubleMatrix1D var2);
    }
}

