/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.CrossCovarianceFunction;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.RationalFilter;
import ec.tstoolkit.maths.linearfilters.RationalForeFilter;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimator;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;

public class WienerKolmogorovPreliminaryEstimatorProperties {
    private WienerKolmogorovEstimators m_wk;
    private int m_cmp;
    private int m_lag;
    private boolean m_signal = true;
    private RationalFilter m_wcmp;
    private RationalFilter m_wrev;
    private LinearModel m_stcmp;
    private LinearModel m_strev;
    private AutoCovarianceFunction m_acgfcmp;
    private AutoCovarianceFunction m_acgfrev;
    private CrossCovarianceFunction m_ccgf;
    private BackFilter m_ur;

    public WienerKolmogorovPreliminaryEstimatorProperties() {
    }

    public WienerKolmogorovPreliminaryEstimatorProperties(WienerKolmogorovEstimators wk) {
        this.m_wk = wk;
    }

    public WienerKolmogorovEstimators getWienerKolmogorovEstimators() {
        return this.m_wk;
    }

    public void setWienerKolmogorovEstimators(WienerKolmogorovEstimators wk) {
        this.m_wk = wk;
        this.clear();
    }

    public UcarimaModel getModel() {
        return this.m_wk.getUcarimaModel();
    }

    public int getSelectedComponent() {
        return this.m_cmp;
    }

    public boolean isSignalSelected() {
        return this.m_signal;
    }

    public int getLag() {
        return this.m_lag;
    }

    public void setLag(int lag) {
        if (this.m_lag != lag) {
            this.m_lag = lag;
            this.pclear();
        }
    }

    public boolean isValid() {
        return this.init();
    }

    public void select(int cmp, boolean signal) {
        if (cmp != this.m_cmp || signal != this.m_signal) {
            this.m_cmp = cmp;
            this.m_signal = signal;
            this.clear();
        }
    }

    public double getWeight(int idx) {
        if (!this.init()) {
            return 0.0;
        }
        if (this.m_signal) {
            return this.m_wcmp.getWeight(idx) - this.m_wrev.getWeight(idx - this.m_lag - 1);
        }
        return this.m_wcmp.getWeight(idx) + this.m_wrev.getWeight(idx - this.m_lag - 1);
    }

    public double getStationaryAutoCovariance(int order) {
        if (!this.init()) {
            return 0.0;
        }
        int lp1 = this.m_lag + 1;
        double ac = this.m_acgfcmp.get(order) + this.m_acgfrev.get(order);
        ac = this.m_signal ? (ac -= this.m_ccgf.get(order - lp1) + this.m_ccgf.get(-order - lp1)) : (ac += this.m_ccgf.get(order - lp1) + this.m_ccgf.get(-order - lp1));
        return ac;
    }

    public Complex getFrequencyResponse(double frequency) {
        if (!this.init()) {
            return Complex.cart(0.0, 0.0);
        }
        double lw = frequency * (double)(1 + this.m_lag);
        Complex cfr = Complex.cart(Math.cos(lw), Math.sin(lw));
        if (!this.m_signal) {
            cfr = cfr.negate();
        }
        return this.m_wcmp.frequencyResponse(frequency).minus(cfr.times(this.m_wrev.frequencyResponse(frequency)));
    }

    public void prepare(int from, int to) {
        if (this.init()) {
            this.m_wcmp.prepare(from, to);
            this.m_wrev.prepare(from - this.m_lag - 1, to - this.m_lag - 1);
        }
    }

    public BackFilter getDifferencingFilter() {
        if (!this.init()) {
            return null;
        }
        return this.m_ur;
    }

    public CrossCovarianceFunction getCcgf() {
        if (!this.init()) {
            return null;
        }
        return this.m_ccgf;
    }

    public AutoCovarianceFunction getStationaryAcgf() {
        if (!this.init()) {
            return null;
        }
        return this.m_acgfcmp;
    }

    public AutoCovarianceFunction getRevisionAcgf() {
        if (!this.init()) {
            return null;
        }
        return this.m_acgfrev;
    }

    private void clear() {
        this.m_wcmp = null;
        this.m_stcmp = null;
        this.m_acgfcmp = null;
        this.m_ur = null;
        this.pclear();
    }

    private void pclear() {
        this.m_wrev = null;
        this.m_strev = null;
        this.m_acgfrev = null;
        this.m_ccgf = null;
    }

    private boolean init() {
        if (this.m_wk == null) {
            return false;
        }
        if (this.m_ccgf != null) {
            return true;
        }
        try {
            IArimaModel model = this.m_wk.getUcarimaModel().getModel();
            WienerKolmogorovEstimator fest = this.m_wk.finalEstimator(this.m_cmp, this.m_signal);
            if (this.m_wcmp == null) {
                this.m_wcmp = fest.getFilter();
                StationaryTransformation st = this.m_wk.finalStationaryEstimator(this.m_cmp, this.m_signal);
                this.m_stcmp = (LinearModel)st.stationaryModel;
                this.m_ur = st.unitRoots;
                this.m_acgfcmp = this.m_stcmp.getAutoCovarianceFunction();
            }
            if (this.m_wrev == null) {
                LinearModel errmodel = this.m_wk.revisionModel(this.m_cmp, this.m_lag);
                RationalForeFilter rferr = errmodel.getFilter().getRationalForeFilter();
                this.m_wrev = new RationalFilter(FiniteFilter.multiply((IFiniteFilter)rferr.getNumerator(), model.getAR()), model.getMA(), rferr.getDenominator());
                RationalFilter ferr = new RationalFilter(FiniteFilter.multiply((IFiniteFilter)this.m_ur, rferr.getNumerator()), BackFilter.ONE, rferr.getDenominator());
                this.m_strev = new LinearModel(ferr, errmodel.getInnovationVariance());
                this.m_acgfrev = this.m_strev.getAutoCovarianceFunction();
                this.m_ccgf = new CrossCovarianceFunction(this.m_strev, this.m_stcmp);
            }
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }
}

