## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
# library(devtools)
# devtools::install_github("Kuan-Liu-Lab/causens")

## ----include=FALSE, message=FALSE, warning=FALSE------------------------------
library(causens)

## -----------------------------------------------------------------------------
# Simulate data
data <- simulate_data(
  N = 10000, seed = 123, alpha_uz = 1,
  beta_uy = 1, treatment_effects = 1
)

# Treatment model is incorrect since U is "missing"
causens_sf(Z ~ X.1 + X.2 + X.3, "Y", data = data,
           c1 = 0.25, c0 = 0.25)$estimated_ate

## -----------------------------------------------------------------------------
plot_causens(Z ~ X.1 + X.2 + X.3, data, "Y",
             c1_upper = 0.5, c1_lower = 0, r = 1, by = 0.01)

## ----eval = FALSE-------------------------------------------------------------
# data <- simulate_data(
#   N = 1000, alpha_uz = 0.5, beta_uy = 0.2,
#   seed = 123, treatment_effects = 1,
#   y_type = "continuous"
# )
# 
# bayesian_causens(
#   Z ~ X.1 + X.2 + X.3, Y ~ X.1 + X.2 + X.3,
#   U ~ X.1 + X.2 + X.3, data
# )

## -----------------------------------------------------------------------------
data <- simulate_data(
  N = 1000, alpha_uz = 0.2, beta_uy = 0.5,
  seed = 123, treatment_effects = 1, y_type = "binary",
  informative_u = FALSE
)

causens_monte_carlo("Y", "Z", c("X.1", "X.2", "X.3"), data)$estimated_ate

