/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.cp.solver.constraints.global.OrderedSparseArray;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;

public final class IncreasingNValue
extends AbstractLargeIntSConstraint {
    IntDomainVar[] x;
    int n;
    IntDomainVar occ;
    OrderedSparseArray infSuffix;
    OrderedSparseArray supSuffix;
    OrderedSparseArray minS;
    OrderedSparseArray maxS;
    OrderedSparseArray infPrefix;
    OrderedSparseArray supPrefix;
    OrderedSparseArray minP;
    OrderedSparseArray maxP;
    Mode m;

    public static IntDomainVar[] concat(IntDomainVar occ, IntDomainVar[] vars) {
        IntDomainVar[] mesVars = new IntDomainVar[vars.length + 1];
        System.arraycopy(vars, 0, mesVars, 0, vars.length);
        mesVars[vars.length] = occ;
        return mesVars;
    }

    public IncreasingNValue(IntDomainVar occ, IntDomainVar[] x, Mode m) {
        super(ConstraintEvent.LINEAR, IncreasingNValue.concat(occ, x));
        this.x = x;
        this.n = x.length;
        this.occ = occ;
        this.m = m;
        this.infSuffix = new OrderedSparseArray(this.n);
        this.supSuffix = new OrderedSparseArray(this.n);
        this.minS = new OrderedSparseArray(this.n, true);
        this.maxS = new OrderedSparseArray(this.n, true);
        this.infPrefix = new OrderedSparseArray(this.n);
        this.supPrefix = new OrderedSparseArray(this.n);
        this.minP = new OrderedSparseArray(this.n, true);
        this.maxP = new OrderedSparseArray(this.n, true);
    }

    public static int getPrev(IntDomainVar v, int val) {
        if (val > v.getInf()) {
            return v.getPrevDomainValue(val);
        }
        return val;
    }

    public static int getNext(IntDomainVar v, int val) {
        if (val < v.getSup()) {
            return v.getNextDomainValue(val);
        }
        return val;
    }

    public final void buildSuffix() {
        int w;
        this.minS.allocate(this.x, this.n + 1);
        this.maxS.allocate(this.x, 0);
        this.infSuffix.scanInit(this.n - 1, false);
        this.supSuffix.scanInit(this.n - 1, false);
        int v = this.x[this.n - 1].getSup();
        do {
            this.infSuffix.set(this.n - 1, v, 1);
            this.supSuffix.set(this.n - 1, v, 1);
        } while ((w = v) != (v = IncreasingNValue.getPrev(this.x[this.n - 1], v)));
        for (int i = this.n - 2; i >= 0; --i) {
            this.infSuffix.scanInit(i + 1, false);
            this.supSuffix.scanInit(i + 1, false);
            this.minS.scanInit(i + 1, false);
            this.maxS.scanInit(i + 1, false);
            v = this.x[i + 1].getSup();
            do {
                if (v < this.x[i + 1].getSup()) {
                    int t = Math.min(this.minS.get(i + 1, v + 1), this.infSuffix.get(i + 1, v));
                    this.minS.set(i + 1, v, t);
                    t = Math.max(this.maxS.get(i + 1, v + 1), this.supSuffix.get(i + 1, v));
                    this.maxS.set(i + 1, v, t);
                    continue;
                }
                this.minS.set(i + 1, v, this.infSuffix.get(i + 1, v));
                this.maxS.set(i + 1, v, this.supSuffix.get(i + 1, v));
            } while ((w = v) != (v = IncreasingNValue.getPrev(this.x[i + 1], v)));
            this.infSuffix.scanInit(i, false);
            this.supSuffix.scanInit(i, false);
            this.infSuffix.scanInit(i + 1, false);
            this.supSuffix.scanInit(i + 1, false);
            this.minS.scanInit(i + 1, false);
            this.maxS.scanInit(i + 1, false);
            v = this.x[i].getSup();
            do {
                if (v == this.x[i + 1].getSup()) {
                    this.infSuffix.set(i, v, this.infSuffix.get(i + 1, v));
                    this.supSuffix.set(i, v, this.supSuffix.get(i + 1, v));
                    continue;
                }
                if (v >= this.x[i + 1].getInf()) {
                    this.infSuffix.set(i, v, Math.min(this.infSuffix.get(i + 1, v), this.minS.get(i + 1, v + 1) + 1));
                    this.supSuffix.set(i, v, Math.max(this.supSuffix.get(i + 1, v), this.maxS.get(i + 1, v + 1) + 1));
                    continue;
                }
                this.infSuffix.set(i, v, this.minS.get(i + 1, this.x[i + 1].getInf()) + 1);
                this.supSuffix.set(i, v, this.maxS.get(i + 1, this.x[i + 1].getInf()) + 1);
            } while ((w = v) != (v = IncreasingNValue.getPrev(this.x[i], v)));
        }
    }

    public final void buildPrefix() {
        int w;
        this.minP.allocate(this.x, this.n + 1);
        this.maxP.allocate(this.x, 0);
        this.infPrefix.scanInit(0, true);
        this.supPrefix.scanInit(0, true);
        int v = this.x[0].getInf();
        do {
            this.infPrefix.set(0, v, 1);
            this.supPrefix.set(0, v, 1);
        } while ((w = v) != (v = IncreasingNValue.getNext(this.x[0], v)));
        for (int i = 1; i < this.n; ++i) {
            this.infPrefix.scanInit(i - 1, true);
            this.supPrefix.scanInit(i - 1, true);
            this.minP.scanInit(i - 1, true);
            this.maxP.scanInit(i - 1, true);
            v = this.x[i - 1].getInf();
            do {
                if (v > this.x[i - 1].getInf()) {
                    int t = Math.min(this.minP.get(i - 1, v - 1), this.infPrefix.get(i - 1, v));
                    this.minP.set(i - 1, v, t);
                    t = Math.max(this.maxP.get(i - 1, v - 1), this.supPrefix.get(i - 1, v));
                    this.maxP.set(i - 1, v, t);
                    continue;
                }
                this.minP.set(i - 1, v, this.infPrefix.get(i - 1, v));
                this.maxP.set(i - 1, v, this.supPrefix.get(i - 1, v));
            } while ((w = v) != (v = IncreasingNValue.getNext(this.x[i - 1], v)));
            this.infPrefix.scanInit(i, true);
            this.supPrefix.scanInit(i, true);
            this.infPrefix.scanInit(i - 1, true);
            this.supPrefix.scanInit(i - 1, true);
            this.minP.scanInit(i - 1, true);
            this.maxP.scanInit(i - 1, true);
            v = this.x[i].getInf();
            do {
                if (v == this.x[i - 1].getInf()) {
                    this.infPrefix.set(i, v, this.infPrefix.get(i - 1, v));
                    this.supPrefix.set(i, v, this.supPrefix.get(i - 1, v));
                    continue;
                }
                if (v <= this.x[i - 1].getSup()) {
                    this.infPrefix.set(i, v, Math.min(this.infPrefix.get(i - 1, v), this.minP.get(i - 1, v - 1) + 1));
                    this.supPrefix.set(i, v, Math.max(this.supPrefix.get(i - 1, v), this.maxP.get(i - 1, v - 1) + 1));
                    continue;
                }
                this.infPrefix.set(i, v, this.minP.get(i - 1, this.x[i - 1].getSup()) + 1);
                this.supPrefix.set(i, v, this.maxP.get(i - 1, this.x[i - 1].getSup()) + 1);
            } while ((w = v) != (v = IncreasingNValue.getNext(this.x[i], v)));
        }
    }

    public final void adjustMin(int idx, int val) throws ContradictionException {
        ((IntDomainVar[])this.vars)[idx].updateInf(val, this, false);
    }

    public final void adjustMax(int idx, int val) throws ContradictionException {
        ((IntDomainVar[])this.vars)[idx].updateSup(val, this, false);
    }

    public final int minInfSuffix(int k) {
        int min = Integer.MAX_VALUE;
        DisposableIntIterator it = this.x[k].getDomain().getIterator();
        while (it.hasNext()) {
            int v = it.next();
            int w = this.infSuffix.get(k, v);
            if (min <= w) continue;
            min = w;
        }
        it.dispose();
        return min;
    }

    public final int maxSupSuffix(int k) {
        int max = Integer.MIN_VALUE;
        DisposableIntIterator it = this.x[k].getDomain().getIterator();
        while (it.hasNext()) {
            int v = it.next();
            int w = this.supSuffix.get(k, v);
            if (max >= w) continue;
            max = w;
        }
        it.dispose();
        return max;
    }

    @Override
    public void propagate() throws ContradictionException {
        int i;
        if (this.n == 1) {
            this.occ.instantiate(1, this, false);
        }
        for (i = 1; i < this.n; ++i) {
            this.adjustMin(i, this.x[i - 1].getInf());
        }
        for (i = this.n - 2; i >= 0; --i) {
            this.adjustMax(i, this.x[i + 1].getSup());
        }
        this.infSuffix.allocate(this.x, this.n + 1);
        this.supSuffix.allocate(this.x, 0);
        this.infPrefix.allocate(this.x, this.n + 1);
        this.supPrefix.allocate(this.x, 0);
        this.buildSuffix();
        this.buildPrefix();
        this.infSuffix.scanInit(0, true);
        this.supSuffix.scanInit(0, true);
        if (this.m == Mode.ATMOST || this.m == Mode.BOTH) {
            this.adjustMin(this.n, this.minInfSuffix(0));
        }
        if (this.m == Mode.ATLEAST || this.m == Mode.BOTH) {
            this.adjustMax(this.n, this.maxSupSuffix(0));
        }
        for (int i2 = 0; i2 < this.n; ++i2) {
            int w;
            this.infPrefix.scanInit(i2, true);
            this.supPrefix.scanInit(i2, true);
            this.infSuffix.scanInit(i2, true);
            this.supSuffix.scanInit(i2, true);
            int v = this.x[i2].getInf();
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            do {
                int mind = this.infPrefix.get(i2, v) + this.infSuffix.get(i2, v) - 1;
                int maxd = this.supPrefix.get(i2, v) + this.supSuffix.get(i2, v) - 1;
                if (this.m == Mode.ATMOST && mind > this.occ.getSup()) {
                    if (v == right + 1) {
                        right = v;
                    } else {
                        this.x[i2].removeInterval(left, right, this, false);
                        left = right = v;
                    }
                }
                if (this.m == Mode.ATLEAST && maxd < this.occ.getInf()) {
                    if (v == right + 1) {
                        right = v;
                    } else {
                        this.x[i2].removeInterval(left, right, this, false);
                        left = right = v;
                    }
                }
                if (this.m != Mode.BOTH || !this.test(mind, maxd)) continue;
                if (v == right + 1) {
                    right = v;
                    continue;
                }
                this.x[i2].removeInterval(left, right, this, false);
                left = right = v;
            } while ((w = v) != (v = IncreasingNValue.getNext(this.x[i2], v)));
            this.x[i2].removeInterval(left, right, this, false);
        }
    }

    public final boolean test(int min, int max) {
        int i;
        for (i = min; i <= max && !this.occ.canBeInstantiatedTo(i); ++i) {
        }
        return i > max;
    }

    public String printer() {
        StringBuilder s = new StringBuilder();
        for (IntDomainVar v : this.x) {
            s.append(v.pretty()).append('\n');
        }
        return s.toString();
    }

    @Override
    public boolean isSatisfied() {
        if (this.isCompletelyInstantiated()) {
            TIntHashSet values = new TIntHashSet();
            values.add(((IntDomainVar[])this.vars)[0].getVal());
            for (int i = 1; i < this.n; ++i) {
                if (((IntDomainVar[])this.vars)[i - 1].getVal() > ((IntDomainVar[])this.vars)[i].getVal()) {
                    return false;
                }
                values.add(((IntDomainVar[])this.vars)[i].getVal());
            }
            return values.size() == this.occ.getVal();
        }
        return false;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        TIntHashSet values = new TIntHashSet();
        values.add(tuple[0]);
        for (int i = 1; i < this.n; ++i) {
            if (tuple[i - 1] > tuple[i]) {
                return false;
            }
            values.add(tuple[i]);
        }
        return values.size() == tuple[this.n];
    }

    public static enum Mode {
        ATMOST,
        ATLEAST,
        BOTH;

    }
}

