/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.table;

import com.qarks.util.ui.swing.table.ColumnTable;
import com.qarks.util.ui.swing.table.ColumnTableSorter;
import com.qarks.util.ui.swing.table.NamedDirective;
import com.qarks.util.ui.swing.table.SortableColumn;
import com.qarks.util.ui.swing.table.UnsupportedColumnTypeException;
import java.util.ArrayList;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class SortedColumnTable<E>
extends ColumnTable<E> {
    private ColumnTableSorter sorter;

    public SortedColumnTable() {
        JTableHeader jTableHeader = this.getTableHeader();
        this.sorter = new ColumnTableSorter(this.model, jTableHeader);
        this.setModel(this.sorter);
    }

    public void removeRowAtViewIndex(int n) {
        int n2 = this.sorter.modelIndex(n);
        this.model.removeRow(n2);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        if (!(tableColumn instanceof SortableColumn)) {
            throw new UnsupportedColumnTypeException("can only add SortableColumn type columns");
        }
        super.addColumn(tableColumn);
    }

    public boolean isAscendingSort(int n) {
        return this.sorter.getSortingStatus(n) == 1;
    }

    public NamedDirective[] getSelectedDirectives() {
        ArrayList<NamedDirective> arrayList = new ArrayList<NamedDirective>();
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            int n = this.sorter.getSortingStatus(i);
            if (n == 0) continue;
            String string = (String)this.columnModel.getColumn(i).getHeaderValue();
            NamedDirective namedDirective = new NamedDirective(string, i, n);
            arrayList.add(namedDirective);
        }
        return arrayList.toArray(new NamedDirective[0]);
    }
}

