/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class MappingGenerator
implements IGenerator<IReaction> {
    private final IGeneratorParameter<Color> atomAtomMappingLineColor = new AtomAtomMappingLineColor();
    private final IGeneratorParameter<Double> mappingLineWidth = new MappingLineWidth();
    private final IGeneratorParameter<Boolean> showAtomAtomMapping = new ShowAtomAtomMapping();

    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        if (!((Boolean)this.showAtomAtomMapping.getValue()).booleanValue()) {
            return null;
        }
        ElementGroup elementGroup = new ElementGroup();
        Color mappingColor = (Color)this.atomAtomMappingLineColor.getValue();
        for (IMapping mapping : reaction.mappings()) {
            IAtom endPointA = (IAtom)mapping.getChemObject(0);
            IAtom endPointB = (IAtom)mapping.getChemObject(1);
            Point2d pointA = endPointA.getPoint2d();
            Point2d pointB = endPointB.getPoint2d();
            elementGroup.add((IRenderingElement)new LineElement(pointA.x, pointA.y, pointB.x, pointB.y, this.getWidthForMappingLine(model), mappingColor));
        }
        return elementGroup;
    }

    private double getWidthForMappingLine(RendererModel model) {
        double scale = (Double)((BasicSceneGenerator.Scale)model.getParameter(BasicSceneGenerator.Scale.class)).getValue();
        return (Double)this.mappingLineWidth.getValue() / scale;
    }

    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.showAtomAtomMapping, this.mappingLineWidth, this.atomAtomMappingLineColor);
    }

    public static class ShowAtomAtomMapping
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class MappingLineWidth
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 1.0;
        }
    }

    public static class AtomAtomMappingLineColor
    extends AbstractGeneratorParameter<Color> {
        public Color getDefault() {
            return Color.gray;
        }
    }
}

