/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import java.util.Iterator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.Generated;

public final class Iterables {
    public static Iterable<Double> of(DoubleSeq seq) {
        return () -> new DoubleSeqIterator(seq);
    }

    public static Iterable<Double> of(double[] data) {
        return () -> new DoublesIterator(data);
    }

    @Generated
    private Iterables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class DoublesIterator
    implements Iterator<Double> {
        private final double[] data;
        private int pos;

        DoublesIterator(double[] data) {
            this.data = data;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.data != null && this.pos < this.data.length;
        }

        @Override
        public Double next() {
            return this.data[this.pos++];
        }
    }

    static class DoubleSeqIterator
    implements Iterator<Double> {
        private final DoubleSeqCursor cursor;
        private final int n;
        private int pos;

        DoubleSeqIterator(DoubleSeq seq) {
            this.cursor = seq.cursor();
            this.n = seq.length();
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.n;
        }

        @Override
        public Double next() {
            ++this.pos;
            return this.cursor.getAndNext();
        }
    }
}

