/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramoseats;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.processing.GenericResults;
import jdplus.toolkit.base.api.processing.ProcResults;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsException;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsLoader;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsSpec;
import lombok.Generated;

public final class TramoSeats {
    private static final TramoSeatsLoader.Processor ENGINE = new TramoSeatsLoader.Processor();
    private static final AtomicReference<Processor> LEGACYENGINE = new AtomicReference();

    public static void setEngine(Processor algorithm) {
        ENGINE.set(algorithm);
    }

    public static Processor getEngine() {
        return ENGINE.get();
    }

    public static ProcResults process(TsData series, TramoSeatsSpec spec, ModellingContext context, List<String> addtionalItems) {
        return ENGINE.get().process(series, spec, context, addtionalItems);
    }

    public static Map<String, Class> outputDictionary(boolean compact) {
        return ENGINE.get().outputDictionary(compact);
    }

    public static void setLegacyEngine(Processor algorithm) {
        LEGACYENGINE.set(algorithm);
    }

    public static Processor getLegacyEngine() {
        return LEGACYENGINE.get();
    }

    public static ProcResults processLegacy(TsData series, TramoSeatsSpec spec, ModellingContext context, List<String> addtionalItems) {
        Processor cp = LEGACYENGINE.get();
        if (cp == null) {
            throw new TramoSeatsException("No legacy engine");
        }
        return cp.process(series, spec, context, addtionalItems);
    }

    @Generated
    private TramoSeats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor {
        public ProcResults process(TsData var1, TramoSeatsSpec var2, ModellingContext var3, List<String> var4);

        public Map<String, Class> outputDictionary(boolean var1);
    }

    public static final class DefProcessor
    implements Processor {
        @Override
        public ProcResults process(TsData series, TramoSeatsSpec spec, ModellingContext context, List<String> addtionalItems) {
            return GenericResults.notImplemented();
        }

        @Override
        public Map<String, Class> outputDictionary(boolean compact) {
            return Collections.emptyMap();
        }
    }
}

