% Generated by roxygen2: do not edit by hand
\name{coplot}
\alias{coplot}
\title{Conditional Plots}
\arguments{
  \item{formula}{an R formula of the form `y ~ x | a` (or `| a * b`)}
  \item{data}{a data frame containing the variables in `formula`}
  \item{number}{how many conditioning intervals to create}
  \item{overlap}{fraction of overlap between adjacent intervals}
  \item{panel}{function used to draw each panel, e.g. \{.fun panel.smooth\}}
  \item{...}{\{.help [graphical parameters](graphics::par)\}, e.g. `col`, `pch`
}
}

\details{
Explore ozone vs solar radiation by month
\code{
coplot(Ozone ~ Solar.R | Month, data = airquality)
}

Condition on two variables with custom interval settings
\code{
coplot(Ozone ~ Solar.R | Month * Wind, data = airquality,
       number = 3, overlap = 0.2)
}

Use a smoothing panel and custom color
\code{
coplot(Ozone ~ Wind | factor(Month), data = airquality,
       panel = panel.smooth, col = "darkgreen")
}}

