/*
 * Decompiled with CFR 0.152.
 */
package com.github.lbfgs4j;

import com.github.lbfgs4j.liblbfgs.Function;
import com.github.lbfgs4j.liblbfgs.Lbfgs;
import com.github.lbfgs4j.liblbfgs.LbfgsConstant;
import com.github.lbfgs4j.liblbfgs.MutableDouble;

public class LbfgsMinimizer {
    private LbfgsConstant.LBFGS_Param param;
    private boolean verbose;

    public LbfgsMinimizer() {
        this(Lbfgs.defaultParams(), true);
    }

    public LbfgsMinimizer(double c) {
        this(c, true);
    }

    public LbfgsMinimizer(LbfgsConstant.LBFGS_Param param) {
        this(param, true);
    }

    public LbfgsMinimizer(boolean verbose) {
        this(Lbfgs.defaultParams(), verbose);
    }

    public LbfgsMinimizer(double c, boolean verbose) {
        this(Lbfgs.defaultParams(), verbose);
        if (c < 0.0) {
            throw new IllegalArgumentException("c must be zero or positive");
        }
        this.param.orthantwise_c = c;
    }

    public LbfgsMinimizer(LbfgsConstant.LBFGS_Param param, boolean verbose) {
        this.param = param;
        this.verbose = verbose;
    }

    public double[] minimize(Function f) {
        return this.minimize(f, null);
    }

    public double[] minimize(Function f, double[] x0) {
        int dim = f.getDimension();
        double[] x = x0 != null ? x0 : new double[dim];
        MutableDouble fx = new MutableDouble();
        Evaluate eval = new Evaluate(f);
        Progress progress = this.verbose ? new Progress() : null;
        Lbfgs.lbfgs(dim, x, fx, eval, progress, null, this.param);
        return x;
    }

    class Progress
    implements LbfgsConstant.LBFGS_Progress {
        Progress() {
        }

        @Override
        public LbfgsConstant.ReturnValue eval(Object instance, double[] x, double[] g, double fx, double xnorm, double gnorm, double step, int n, int k, int ls) {
            System.out.printf("Iteration %d:\n", k);
            System.out.printf("\tfx = %f, xnorm = %f, gnorm = %f, step = %f\n", fx, xnorm, gnorm, step);
            System.out.printf("\tn = %d, k = %d, ls = %d\n\n", n, k, ls);
            return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
        }
    }

    class Evaluate
    implements LbfgsConstant.LBFGS_Evaluate {
        private Function func;

        public Evaluate(Function func) {
            this.func = func;
        }

        @Override
        public double eval(Object instance, double[] x, double[] g, int n, double step) {
            double[] grad = this.func.gradientAt(x);
            System.arraycopy(grad, 0, g, 0, grad.length);
            return this.func.valueAt(x);
        }
    }
}

