/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.VariableDemographicModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.NormalDistribution;

@Deprecated
public class OrnsteinUhlenbeckPriorLikelihood
extends AbstractModelLikelihood {
    private final Parameter mean;
    private final Parameter sigma;
    private final Parameter lambda;
    private final boolean logSpace;
    private final boolean normalize;
    private Parameter data;
    private Parameter times;
    private ParametricDistributionModel popMeanPrior = null;
    private VariableDemographicModel m = null;
    private final double logNormalCoef = -0.5 * Math.log(Math.PI * 2);
    double lastValue = -1.0;

    private OrnsteinUhlenbeckPriorLikelihood(Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl, boolean bl2) {
        super("Ornstein-Uhlenbeck");
        this.logSpace = bl;
        this.normalize = bl2;
        this.mean = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
        }
        this.sigma = parameter2;
        this.addVariable(parameter2);
        this.lambda = parameter3;
        if (parameter3 != null) {
            this.addVariable(parameter3);
        }
    }

    public OrnsteinUhlenbeckPriorLikelihood(Parameter parameter, Parameter parameter2, Parameter parameter3, VariableDemographicModel variableDemographicModel, boolean bl, boolean bl2, ParametricDistributionModel parametricDistributionModel) {
        this(parameter, parameter2, parameter3, bl, bl2);
        this.m = variableDemographicModel;
        this.times = null;
        this.data = null;
        this.popMeanPrior = parametricDistributionModel;
    }

    public OrnsteinUhlenbeckPriorLikelihood(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, boolean bl, boolean bl2) {
        this(parameter, parameter2, parameter3, bl, bl2);
        parameter4.addParameterListener(this);
        parameter5.addParameterListener(this);
        this.data = parameter4;
        this.times = parameter5;
    }

    private double reNormalize(VariableDemographicModel variableDemographicModel) {
        double d;
        int n;
        double[] dArray = variableDemographicModel.getDemographicFunction().allTimePoints();
        double[] dArray2 = variableDemographicModel.getPopulationValues().getParameterValues();
        assert (!this.logSpace) : "not implemented yet";
        double d2 = dArray[dArray.length - 1];
        double d3 = 0.0;
        if (variableDemographicModel.getType() == VariableDemographicModel.Type.LINEAR) {
            for (n = 0; n < dArray.length; ++n) {
                d = dArray[n] - (n > 0 ? dArray[n - 1] : 0.0);
                d3 += d * (dArray2[n + 1] + dArray2[n]);
            }
            d3 /= 2.0 * d2;
        } else {
            for (n = 0; n < dArray.length; ++n) {
                d = dArray[n] - (n > 0 ? dArray[n - 1] : 0.0);
                d3 += d * dArray2[n];
            }
            d3 /= d2;
        }
        double d4 = this.sigma.getStatisticValue(0) / Math.sqrt(d2);
        double d5 = 0.5 * d2;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = (dArray2[i] - d3) / d2;
        }
        double d6 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d7 = (dArray[i] - (i > 0 ? dArray[i - 1] : 0.0)) / d2;
            double d8 = Math.exp(-d5 * d7);
            double d9 = dArray2[i + 1] - dArray2[i] * d8;
            double d10 = 1.0 - d8 * d8;
            d6 += d9 * d9 / d10 - 0.5 * Math.log(d10);
        }
        double d11 = 2.0 * d5 / (d4 * d4);
        d6 = (double)dArray.length * (this.logNormalCoef - Math.log(d4)) + d6 * d11 / -2.0;
        d6 = this.popMeanPrior != null ? (d6 += this.popMeanPrior.logPdf(d3)) : (d6 -= Math.log(d3));
        return d6;
    }

    @Override
    public double getLogLikelihood() {
        double d;
        if (this.lastValue > 0.0) {
            return this.lastValue;
        }
        if (this.normalize) {
            assert (this.m != null);
            d = this.reNormalize(this.m);
        } else {
            double[] dArray = this.times.getParameterValues();
            double[] dArray2 = this.data.getParameterValues();
            if (this.logSpace) {
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = Math.log(dArray2[i]);
                }
            }
            double d2 = this.lambda.getStatisticValue(0);
            double d3 = this.mean.getStatisticValue(0);
            double d4 = this.sigma.getStatisticValue(0);
            if (this.normalize) {
                d4 *= Math.sqrt(2.0 * d2);
            }
            d = NormalDistribution.logPdf(dArray2[0], d3, d4);
            double d5 = -d2 * (this.normalize ? 1.0 / dArray[dArray.length - 1] : 1.0);
            for (int i = 0; i < dArray.length; ++i) {
                double d6 = dArray[i] - (i > 0 ? dArray[i - 1] : 0.0);
                double d7 = Math.exp(d5 * d6);
                double d8 = d4 * Math.sqrt((1.0 - d7 * d7) / (2.0 * d2));
                double d9 = (dArray2[i + 1] - (dArray2[i] * d7 + d3 * (1.0 - d7))) / d8;
                d += NormalDistribution.logPdf(d9, 0.0, 1.0);
            }
        }
        this.lastValue = d;
        return d;
    }

    @Override
    public void makeDirty() {
        this.lastValue = -1.0;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.makeDirty();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.makeDirty();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

