/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeShape;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeStatistic;

public class TreeShapeStatistic
extends TreeStatistic {
    private Tree target = null;
    private boolean ultrametric = false;

    public TreeShapeStatistic(String string, TreeModel treeModel) {
        super(string);
        this.target = treeModel;
        this.ultrametric = TreeUtils.isUltrametric(treeModel);
    }

    @Override
    public void setTree(Tree tree) {
        this.target = tree;
    }

    @Override
    public Tree getTree() {
        return this.target;
    }

    @Override
    public int getDimension() {
        if (this.ultrametric) {
            return 5;
        }
        return 4;
    }

    @Override
    public String getDimensionName(int n) {
        switch (n) {
            case 0: {
                return "N-bar";
            }
            case 1: {
                return "N-bar-var";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "B1";
            }
            case 4: {
                return "gamma";
            }
        }
        throw new IllegalArgumentException("Dimension doesn't exist!");
    }

    @Override
    public double getStatisticValue(int n) {
        switch (n) {
            case 0: {
                return TreeShape.getNBarStatistic(this.target);
            }
            case 1: {
                return TreeShape.getVarNBarStatistic(this.target);
            }
            case 2: {
                return TreeShape.getCStatistic(this.target);
            }
            case 3: {
                return TreeShape.getB1Statistic(this.target);
            }
            case 4: {
                return TreeShape.getGammaStatistic(this.target);
            }
        }
        throw new IllegalArgumentException("Dimension doesn't exist!");
    }
}

