/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class CopyParameterValuesParser
extends AbstractXMLObjectParser {
    public static final String RESET_PARAMETER = "copyParameterValues";
    public static final String SOURCE = "source";
    public static final String DESTINATION = "destination";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("source", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("destination", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

    @Override
    public String getParserName() {
        return RESET_PARAMETER;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Parameter parameter = (Parameter)xMLObject.getChild(SOURCE).getChild(Parameter.class);
        Parameter parameter2 = (Parameter)xMLObject.getChild(DESTINATION).getChild(Parameter.class);
        if (parameter.getDimension() != parameter2.getDimension()) {
            throw new XMLParseException("Source (" + parameter.getDimension() + ") and destination (" + parameter2.getDimension() + ") dimensions do not match");
        }
        for (int i = 0; i < parameter.getDimension(); ++i) {
            parameter2.setParameterValueQuietly(i, parameter.getParameterValue(i));
        }
        parameter2.fireParameterChangedEvent();
        return parameter2;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Copy parameter values from source to destination";
    }

    @Override
    public Class getReturnType() {
        return Parameter.class;
    }
}

