/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IndependentGammaSampler
extends SimpleMCMCOperator {
    public static final String OPERATOR_NAME = "independentGammaSampler";
    public static final String SHAPE = "shape";
    public static final String SCALE = "scale";
    private Variable<Double> variable = null;
    private GammaDistribution gamma = null;
    private boolean updateAllIndependently = true;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("shape"), AttributeRule.newDoubleRule("scale"), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return IndependentGammaSampler.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(IndependentGammaSampler.SHAPE);
            double d3 = xMLObject.getDoubleAttribute(IndependentGammaSampler.SCALE);
            if (!(d2 > 0.0) || !(d3 > 0.0)) {
                throw new XMLParseException("Shape and scale must be positive values.");
            }
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new IndependentGammaSampler(parameter, new GammaDistribution(d2, d3), d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence sampler from a provided gamma prior.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public IndependentGammaSampler(Variable variable, GammaDistribution gammaDistribution) {
        this(variable, gammaDistribution, 1.0);
    }

    public IndependentGammaSampler(Variable variable, GammaDistribution gammaDistribution, double d) {
        this(variable, gammaDistribution, d, true);
    }

    public IndependentGammaSampler(Variable variable, GammaDistribution gammaDistribution, double d, boolean bl) {
        this.variable = variable;
        this.gamma = gammaDistribution;
        this.updateAllIndependently = bl;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "independentGamma(" + this.variable.getVariableName() + ")";
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        Bounds<Double> bounds = this.variable.getBounds();
        int n = this.variable.getSize();
        if (this.updateAllIndependently) {
            for (int i = 0; i < n; ++i) {
                double d2 = this.variable.getValue(i);
                double d3 = this.gamma.nextGamma();
                while (d3 == 0.0) {
                    d3 = this.gamma.nextGamma();
                }
                d += this.gamma.logPdf(d2) - this.gamma.logPdf(d3);
                if (d3 < bounds.getLowerLimit(i) || d3 > bounds.getUpperLimit(i)) {
                    throw new RuntimeException("proposed value outside boundaries");
                }
                this.variable.setValue(i, d3);
            }
        }
        return d;
    }
}

