/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.ReadableMatrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.WritableMatrix;
import dr.math.matrixAlgebra.WritableVector;
import java.util.Arrays;
import org.ejml.data.DenseMatrix64F;

public interface WrappedMatrix
extends ReadableMatrix,
WritableVector,
WritableMatrix {
    public static final double[] data = null;

    @Override
    public void set(int var1, int var2, double var3);

    public double[] getBuffer();

    public int getOffset();

    public String toString();

    public static final class WrappedStrictlyUpperTriangularMatrix
    extends Abstract {
        private final double diagonalValue;

        public WrappedStrictlyUpperTriangularMatrix(double[] dArray, int n, double d) {
            super(dArray, 0, n, n);
            assert (dArray.length == n * (n - 1) / 2);
            this.diagonalValue = d;
        }

        public WrappedStrictlyUpperTriangularMatrix(double[] dArray, int n) {
            super(dArray, 0, n, n);
            assert (dArray.length == n * (n - 1) / 2);
            this.diagonalValue = 0.0;
        }

        public WrappedStrictlyUpperTriangularMatrix(int n, double d) {
            super(new double[n * (n - 1) / 2], 0, n, n);
            this.diagonalValue = d;
        }

        public WrappedStrictlyUpperTriangularMatrix(int n) {
            super(new double[n * (n - 1) / 2], 0, n, n);
            this.diagonalValue = 0.0;
        }

        @Override
        public final double get(int n) {
            return this.buffer[this.offset + n];
        }

        @Override
        public final void set(int n, double d) {
            this.buffer[this.offset + n] = d;
        }

        @Override
        public final double get(int n, int n2) {
            assert (n <= n2);
            if (n == n2) {
                return this.diagonalValue;
            }
            return this.buffer[this.offset + this.pos(n, n2)];
        }

        @Override
        public final void set(int n, int n2, double d) {
            assert (n < n2);
            this.buffer[this.offset + this.pos((int)n, (int)n2)] = d;
        }

        @Override
        public final int getDim() {
            return this.buffer.length;
        }

        private int pos(int n, int n2) {
            return n * (2 * this.dimMajor - n - 1) / 2 + (n2 - n - 1);
        }
    }

    public static final class WrappedUpperTriangularMatrix
    extends Abstract {
        public WrappedUpperTriangularMatrix(double[] dArray, int n) {
            super(dArray, 0, n, n);
            assert (dArray.length == n * (n + 1) / 2);
        }

        public WrappedUpperTriangularMatrix(int n) {
            super(new double[n * (n + 1) / 2], 0, n, n);
        }

        @Override
        public final double get(int n) {
            return this.buffer[this.offset + n];
        }

        @Override
        public final void set(int n, double d) {
            this.buffer[this.offset + n] = d;
        }

        @Override
        public final double get(int n, int n2) {
            assert (n <= n2);
            return this.buffer[this.offset + this.pos(n, n2)];
        }

        @Override
        public final void set(int n, int n2, double d) {
            assert (n <= n2);
            this.buffer[this.offset + this.pos((int)n, (int)n2)] = d;
        }

        private int pos(int n, int n2) {
            return n * (2 * this.dimMajor - n + 1) / 2 + (n2 - n);
        }

        public final SymmetricMatrix transposedProduct() {
            SymmetricMatrix symmetricMatrix = new SymmetricMatrix(this.dimMajor);
            for (int i = 0; i < this.dimMajor; ++i) {
                for (int j = i; j < this.dimMajor; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < i + 1; ++k) {
                        d += this.get(k, i) * this.get(k, j);
                    }
                    symmetricMatrix.setSymmetric(i, j, d);
                }
            }
            return symmetricMatrix;
        }

        public static WrappedUpperTriangularMatrix fillDiagonal(double[] dArray, int n) {
            WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix = new WrappedStrictlyUpperTriangularMatrix(dArray, n);
            WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = new WrappedUpperTriangularMatrix(n);
            for (int i = 0; i < n; ++i) {
                double d = 0.0;
                for (int j = 0; j < i; ++j) {
                    double d2 = wrappedStrictlyUpperTriangularMatrix.get(j, i);
                    wrappedUpperTriangularMatrix.set(j, i, d2);
                    d += d2 * d2;
                }
                if (d > 1.0) {
                    if (Math.abs(d - 1.0) > 1.0E-6) {
                        throw new RuntimeException("Values are not consistent with the cholesky decomposition of a correlation matrix. Sum of squared values must be less than 1 (got " + d + ")");
                    }
                    d = 1.0;
                }
                wrappedUpperTriangularMatrix.set(i, i, Math.sqrt(1.0 - d));
            }
            return wrappedUpperTriangularMatrix;
        }

        @Override
        public final int getDim() {
            return this.buffer.length;
        }
    }

    public static final class Utils {
        public static String makeString(ReadableMatrix readableMatrix) {
            StringBuilder stringBuilder = new StringBuilder("[ ");
            if (readableMatrix.getDim() > 0) {
                stringBuilder.append(readableMatrix.get(0));
            }
            for (int i = 1; i < readableMatrix.getDim(); ++i) {
                stringBuilder.append(", ").append(readableMatrix.get(i));
            }
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }

        public static void gatherRowsAndColumns(WrappedMatrix wrappedMatrix, WrappedMatrix wrappedMatrix2, int[] nArray, int[] nArray2) {
            int n = nArray.length;
            int n2 = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                for (int j = 0; j < n2; ++j) {
                    wrappedMatrix2.set(i, j, wrappedMatrix.get(n3, nArray2[j]));
                }
            }
        }

        public static void scatterRowsAndColumns(WrappedMatrix wrappedMatrix, WrappedMatrix wrappedMatrix2, int[] nArray, int[] nArray2) {
            Utils.scatterRowsAndColumns(wrappedMatrix, wrappedMatrix2, nArray, nArray2, true);
        }

        public static void scatterRowsAndColumns(WrappedMatrix wrappedMatrix, WrappedMatrix wrappedMatrix2, int[] nArray, int[] nArray2, boolean bl) {
            int n;
            int n2;
            if (bl) {
                double[] dArray = wrappedMatrix2.getBuffer();
                n2 = wrappedMatrix2.getOffset();
                n = n2 + wrappedMatrix2.getMajorDim() * wrappedMatrix2.getMinorDim();
                Arrays.fill(dArray, n2, n, 0.0);
            }
            int n3 = nArray.length;
            n2 = nArray2.length;
            for (n = 0; n < n3; ++n) {
                int n4 = nArray[n];
                for (int i = 0; i < n2; ++i) {
                    wrappedMatrix2.set(n4, nArray2[n], wrappedMatrix.get(n, i));
                }
            }
        }

        public static Indexed wrapBlockDiagonalMatrix(double[] dArray, int n, int n2, int n3) {
            int[] nArray = new int[n3];
            int n4 = n2;
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n4++;
            }
            return new Indexed(dArray, n, nArray, nArray, n3, n3);
        }

        public static void transferSymmetricBlockDiagonal(WrappedMatrix wrappedMatrix, WrappedMatrix wrappedMatrix2, int n) {
            int n2 = wrappedMatrix.getMajorDim();
            int n3 = wrappedMatrix2.getMajorDim();
            if (wrappedMatrix.getMinorDim() != n2 || wrappedMatrix2.getMinorDim() != n3) {
                throw new RuntimeException("Matrices must be square.");
            }
            int n4 = n;
            for (int i = 0; i < n2; ++i) {
                wrappedMatrix2.set(n4, n4, wrappedMatrix.get(i, i));
                int n5 = n4 + 1;
                for (int j = i + 1; j < n2; ++j) {
                    double d = wrappedMatrix.get(i, j);
                    wrappedMatrix2.set(n4, n5, d);
                    wrappedMatrix2.set(n5, n4, d);
                    ++n5;
                }
                ++n4;
            }
        }
    }

    public static final class Indexed
    extends Abstract {
        private final int[] indicesMajor;
        private final int[] indicesMinor;
        final int dimMajorFull;
        final int dimMinorFull;

        public Indexed(double[] dArray, int n, int[] nArray, int[] nArray2, int n2, int n3) {
            super(dArray, n, nArray.length, nArray2.length);
            this.indicesMajor = nArray;
            this.indicesMinor = nArray2;
            this.dimMajorFull = n2;
            this.dimMinorFull = n3;
        }

        @Override
        public final double get(int n, int n2) {
            return this.buffer[this.getIndex(n, n2)];
        }

        @Override
        public final void set(int n, int n2, double d) {
            this.buffer[this.getIndex((int)n, (int)n2)] = d;
        }

        @Override
        public final double get(int n) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public final void set(int n, double d) {
            throw new RuntimeException("Not yet implemented");
        }

        private int getIndex(int n, int n2) {
            return this.offset + this.indicesMajor[n] * this.dimMajorFull + this.indicesMinor[n2];
        }
    }

    public static final class MatrixParameter
    extends Abstract {
        private final MatrixParameterInterface matrix;

        public MatrixParameter(MatrixParameterInterface matrixParameterInterface) {
            super(null, 0, matrixParameterInterface.getRowDimension(), matrixParameterInterface.getColumnDimension());
            this.matrix = matrixParameterInterface;
        }

        @Override
        public void set(int n, int n2, double d) {
            this.matrix.setParameterValue(n, n2, d);
        }

        @Override
        public double get(int n, int n2) {
            return this.matrix.getParameterValue(n, n2);
        }

        @Override
        public double get(int n) {
            return this.matrix.getParameterValue(n);
        }

        @Override
        public void set(int n, double d) {
            this.matrix.setParameterValue(n, d);
        }
    }

    public static final class Parameter
    extends Abstract {
        private final Variable<Double> variable;

        public Parameter(Variable<Double> variable, int n, int n2, int n3) {
            super(null, n, n2, n3);
            assert (variable.getSize() == n2 * n3);
            this.variable = variable;
        }

        @Override
        public final double get(int n, int n2) {
            return this.variable.getValue(this.offset + n * this.dimMajor + n2);
        }

        @Override
        public final void set(int n, double d) {
            this.variable.setValue(this.offset + n, d);
        }

        @Override
        public void set(int n, int n2, double d) {
            this.variable.setValue(this.offset + n * this.dimMajor + n2, d);
        }

        @Override
        public double get(int n) {
            return this.variable.getValue(n);
        }
    }

    public static final class Raw
    extends Abstract {
        public Raw(double[] dArray, int n, int n2, int n3) {
            super(dArray, n, n2, n3);
        }

        @Override
        public final double get(int n) {
            return this.buffer[this.offset + n];
        }

        @Override
        public final void set(int n, double d) {
            this.buffer[this.offset + n] = d;
        }

        @Override
        public final double get(int n, int n2) {
            return this.buffer[this.offset + n * this.dimMajor + n2];
        }

        @Override
        public final void set(int n, int n2, double d) {
            this.buffer[this.offset + n * this.dimMajor + n2] = d;
        }
    }

    public static final class ArrayOfArray
    extends Base {
        private final double[][] arrays;
        private final int dimMajor;
        private final int dimMinor;

        public ArrayOfArray(double[][] dArray) {
            this.arrays = dArray;
            this.dimMajor = dArray.length;
            this.dimMinor = dArray[0].length;
        }

        @Override
        public double get(int n) {
            return this.arrays[n / this.dimMajor][n % this.dimMajor];
        }

        @Override
        public void set(int n, double d) {
            this.arrays[n / this.dimMajor][n % this.dimMajor] = d;
        }

        @Override
        public double get(int n, int n2) {
            return this.arrays[n][n2];
        }

        @Override
        public void set(int n, int n2, double d) {
            this.arrays[n][n2] = d;
        }

        @Override
        public int getMajorDim() {
            return this.dimMajor;
        }

        @Override
        public int getMinorDim() {
            return this.dimMinor;
        }

        @Override
        public int getDim() {
            return this.getMajorDim() * this.getMinorDim();
        }

        @Override
        public double[] getBuffer() {
            throw new RuntimeException("Not yet implemented");
        }

        public double[][] getArrays() {
            return this.arrays;
        }

        @Override
        public int getOffset() {
            return 0;
        }
    }

    public static final class WrappedDenseMatrix
    extends Base {
        private final DenseMatrix64F matrix;

        public WrappedDenseMatrix(DenseMatrix64F denseMatrix64F) {
            this.matrix = denseMatrix64F;
        }

        @Override
        public void set(int n, double d) {
            this.matrix.data[n] = d;
        }

        @Override
        public double get(int n) {
            return this.matrix.data[n];
        }

        @Override
        public int getDim() {
            return this.matrix.getNumElements();
        }

        @Override
        public double get(int n, int n2) {
            return this.matrix.unsafe_get(n, n2);
        }

        @Override
        public int getMajorDim() {
            return this.matrix.getNumRows();
        }

        @Override
        public int getMinorDim() {
            return this.matrix.getNumCols();
        }

        @Override
        public void set(int n, int n2, double d) {
            this.matrix.unsafe_set(n, n2, d);
        }

        @Override
        public double[] getBuffer() {
            return this.matrix.data;
        }

        @Override
        public int getOffset() {
            return 0;
        }
    }

    public static abstract class Abstract
    extends Base {
        final double[] buffer;
        final int offset;
        final int dimMajor;
        final int dimMinor;

        public Abstract(double[] dArray, int n, int n2, int n3) {
            this.buffer = dArray;
            this.offset = n;
            this.dimMajor = n2;
            this.dimMinor = n3;
        }

        @Override
        public final double[] getBuffer() {
            return this.buffer;
        }

        @Override
        public final int getOffset() {
            return this.offset;
        }

        @Override
        public final int getMajorDim() {
            return this.dimMajor;
        }

        @Override
        public final int getMinorDim() {
            return this.dimMinor;
        }

        @Override
        public int getDim() {
            return this.getMajorDim() * this.getMinorDim();
        }
    }

    public static abstract class Base
    implements WrappedMatrix {
        @Override
        public final String toString() {
            return Utils.makeString(this);
        }
    }
}

