/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.indel;

import dr.evolution.alignment.Alignment;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.oldevomodel.indel.HomologyRecursion;
import dr.oldevomodel.indel.TKF91Model;
import dr.oldevomodel.sitemodel.GammaSiteModel;

public class TKF91Likelihood
extends AbstractModelLikelihood {
    private String id = null;
    private final TreeModel treeModel;
    private Alignment alignment;
    private final GammaSiteModel siteModel;
    private final TKF91Model tkfModel;
    private HomologyRecursion recursion = null;

    public TKF91Likelihood(TreeModel treeModel, Alignment alignment, GammaSiteModel gammaSiteModel, TKF91Model tKF91Model) {
        super("tkf91Likelihood");
        if (gammaSiteModel.getAlphaParameter() != null) {
            throw new IllegalArgumentException("TKF91 model cannot handle gamma-distributed rates");
        }
        if (gammaSiteModel.getPInvParameter() != null) {
            throw new IllegalArgumentException("TKF91 model cannot handle invariant sites");
        }
        this.addModel(gammaSiteModel);
        this.addModel(tKF91Model);
        this.addModel(treeModel);
        this.treeModel = treeModel;
        this.alignment = alignment;
        this.siteModel = gammaSiteModel;
        this.tkfModel = tKF91Model;
        this.recursion = new HomologyRecursion();
        this.recursion.init(treeModel, alignment, gammaSiteModel.getSubstitutionModel(), gammaSiteModel.getMutationRateParameter().getParameterValue(0), tKF91Model.getLengthDistributionValue(), tKF91Model.getDeathRate(1));
        this.addStatistic(new AlignmentLengthStatistic());
    }

    @Override
    public void acceptState() {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public GammaSiteModel getSiteModel() {
        return this.siteModel;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        this.recursion.init(this.treeModel, this.alignment, this.siteModel.getSubstitutionModel(), this.siteModel.getMutationRateParameter().getParameterValue(0), this.tkfModel.getLengthDistributionValue(), this.tkfModel.getDeathRate(1));
        double d = this.recursion.recursion();
        return d;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        return super.toString();
    }

    protected boolean getLikelihoodKnown() {
        return false;
    }

    public class AlignmentLengthStatistic
    extends Statistic.Abstract {
        @Override
        public double getStatisticValue(int n) {
            return TKF91Likelihood.this.alignment.getSiteCount();
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public String getStatisticName() {
            return "alignmentLength";
        }
    }
}

