/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.mem;

import com.amazon.dsi.core.impl.DSIDriverSingleton;
import com.amazon.dsi.core.interfaces.IDriver;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.support.ILogger;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryManager {
    private static final int MEM_CONSTANT = 3;
    private static final long DEFAULT_BYTES = 0x6400000L;
    private static final String PKG_NAME = MemoryManager.class.getPackage().toString();
    private static final String CLS_NAME = "MemoryManager";
    private final long m_totalPoolBytes;
    private final AtomicLong m_freePool;
    private final AtomicInteger m_nextUsageId = new AtomicInteger(0);
    private final ConcurrentHashMap<Integer, MemoryUsage> m_currentUsage = new ConcurrentHashMap();
    private final ILogger m_logger;

    MemoryManager(long l) {
        this(l, null);
    }

    MemoryManager(long l, ILogger iLogger) {
        if (0L >= l) {
            throw new IllegalArgumentException("MemoryManager allocated with " + l + " to use. Please check your JVM configuration.");
        }
        this.m_totalPoolBytes = l;
        this.m_freePool = new AtomicLong(l);
        this.m_logger = iLogger;
    }

    public boolean allocate(int n, long l) {
        MemoryUsage memoryUsage;
        ILogger iLogger = this.m_logger;
        if (MemoryManager.shouldLog(LogLevel.TRACE, iLogger)) {
            LogUtilities.logFunctionEntrance(iLogger, l);
        }
        if (this.m_totalPoolBytes < l) {
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logAllocate(iLogger, n, l, 0L, this.m_freePool.get());
            }
            return false;
        }
        MemoryUsage memoryUsage2 = memoryUsage = this.getUsage(n);
        synchronized (memoryUsage2) {
            long l2;
            long l3 = memoryUsage.getReservePool();
            if (l3 >= l) {
                memoryUsage.allocate(l);
                if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                    this.logAllocate(iLogger, n, l, l, this.m_freePool.get());
                    this.logUsage(iLogger, n, "allocate", memoryUsage);
                }
                return true;
            }
            long l4 = l - l3;
            do {
                if ((l2 = this.m_freePool.get()) / 3L >= l4) continue;
                if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                    this.logAllocate(iLogger, n, l, 0L, l2);
                    this.logUsage(iLogger, n, "allocate", memoryUsage);
                }
                return false;
            } while (!this.m_freePool.compareAndSet(l2, l2 - l4));
            memoryUsage.allocate(l);
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logAllocate(iLogger, n, l, l, l2 - l4);
                this.logUsage(iLogger, n, "allocate", memoryUsage);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateMax(int n) {
        long l;
        MemoryUsage memoryUsage;
        long l2;
        long l3;
        ILogger iLogger = this.m_logger;
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, n);
        }
        while (0L != (l3 = (l2 = this.m_freePool.get()) / 3L) && !this.m_freePool.compareAndSet(l2, l2 - l3)) {
        }
        MemoryUsage memoryUsage2 = memoryUsage = this.getUsage(n);
        synchronized (memoryUsage2) {
            l = memoryUsage.getReservePool() + l3;
            memoryUsage.allocate(l);
        }
        if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
            this.logAllocateMax(iLogger, n, l, l2 - l3);
            this.logUsage(iLogger, n, "allocateMax", memoryUsage);
        }
        return l;
    }

    public int createUsageId() {
        ILogger iLogger = this.m_logger;
        if (MemoryManager.shouldLog(LogLevel.TRACE, iLogger)) {
            LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        }
        int n = this.m_nextUsageId.getAndIncrement();
        assert (-1 != n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(int n, long l) {
        long l2;
        Integer n2;
        MemoryUsage memoryUsage;
        ILogger iLogger = this.m_logger;
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, n, l);
        }
        if (null == (memoryUsage = this.m_currentUsage.get(n2 = Integer.valueOf(n)))) {
            throw new NoSuchElementException("No usage for usageId: " + n);
        }
        MemoryUsage memoryUsage2 = memoryUsage;
        synchronized (memoryUsage2) {
            if (l > memoryUsage.getAllocated()) {
                throw new IllegalArgumentException("Dealloc failed.");
            }
            l2 = memoryUsage.deallocate(l);
        }
        if (0L < l2) {
            long l3 = this.m_freePool.addAndGet(l2);
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logDeallocate(iLogger, n, l, l2, l3);
                this.logUsage(iLogger, n, "deallocate", memoryUsage);
            }
        } else if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
            this.logDeallocate(iLogger, n, l, l2, this.m_freePool.get());
            this.logUsage(iLogger, n, "deallocate", memoryUsage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(int n) {
        long l;
        MemoryUsage memoryUsage;
        ILogger iLogger = this.m_logger;
        if (MemoryManager.shouldLog(LogLevel.TRACE, iLogger)) {
            LogUtilities.logFunctionEntrance(iLogger, n);
        }
        if (null == (memoryUsage = this.m_currentUsage.remove(n))) {
            return;
        }
        MemoryUsage memoryUsage2 = memoryUsage;
        synchronized (memoryUsage2) {
            l = memoryUsage.free();
        }
        long l2 = -1L;
        if (0L < l) {
            l2 = this.m_freePool.addAndGet(l);
        }
        if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
            if (0L > l2) {
                l2 = this.m_freePool.get();
            }
            this.logFree(iLogger, n, l, l2);
        }
    }

    public long getAvailableMemory() {
        return this.m_freePool.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAllocated(int n) {
        MemoryUsage memoryUsage = this.m_currentUsage.get(n);
        if (null == memoryUsage) {
            return 0L;
        }
        MemoryUsage memoryUsage2 = memoryUsage;
        synchronized (memoryUsage2) {
            return memoryUsage.getAllocated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReserved(int n) {
        MemoryUsage memoryUsage = this.m_currentUsage.get(n);
        if (null == memoryUsage) {
            return 0L;
        }
        MemoryUsage memoryUsage2 = memoryUsage;
        synchronized (memoryUsage2) {
            return memoryUsage.getReserveMax();
        }
    }

    public long getTotalMemory() {
        return this.m_totalPoolBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserve(int n, long l) {
        MemoryUsage memoryUsage;
        Integer n2;
        MemoryUsage memoryUsage2;
        long l2;
        ILogger iLogger = this.m_logger;
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, n, l);
        }
        if (0L > l) {
            throw new IllegalArgumentException("Negative amount: " + l);
        }
        if (this.m_totalPoolBytes < l) {
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logReserve(iLogger, n, l, 0L, this.m_freePool.get());
            }
            return false;
        }
        if (0L == l) {
            this.m_currentUsage.putIfAbsent(n, new MemoryUsage(0L));
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logReserve(iLogger, n, l, 0L, this.m_freePool.get());
                this.logUsage(iLogger, n, "reserve", this.m_currentUsage.get(n));
            }
            return true;
        }
        do {
            if (l <= (l2 = this.m_freePool.get())) continue;
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logReserve(iLogger, n, l, 0L, l2);
            }
            return false;
        } while (!this.m_freePool.compareAndSet(l2, l2 - l));
        if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
            this.logReserve(iLogger, n, l, l, l2 - l);
        }
        if (null == (memoryUsage2 = this.m_currentUsage.get(n2 = Integer.valueOf(n))) && null == (memoryUsage2 = this.m_currentUsage.putIfAbsent(n2, memoryUsage = new MemoryUsage(l)))) {
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logUsage(iLogger, n, "reserve", memoryUsage);
            }
            return true;
        }
        memoryUsage = memoryUsage2;
        synchronized (memoryUsage) {
            memoryUsage2.reserve(l);
            if (MemoryManager.shouldLog(LogLevel.DEBUG, iLogger)) {
                this.logUsage(iLogger, n, "reserve", memoryUsage2);
            }
        }
        return true;
    }

    public static MemoryManager getInstance() {
        return Holder.INSTANCE;
    }

    private void logAllocate(ILogger iLogger, int n, long l, long l2, long l3) {
        String string = String.format("[%d] ALLOC   %d -> %d (free: %d)", n, l, l2, l3);
        iLogger.logDebug(PKG_NAME, CLS_NAME, "allocate", string);
    }

    private void logAllocateMax(ILogger iLogger, int n, long l, long l2) {
        String string = String.format("[%d] ALOCMAX MAX -> %d (free: %d)", n, l, l2);
        iLogger.logDebug(PKG_NAME, CLS_NAME, "allocateMax", string);
    }

    private void logDeallocate(ILogger iLogger, int n, long l, long l2, long l3) {
        String string = String.format("[%d] DEALLOC %d (free +%d : %d)", n, l, l2, l3);
        iLogger.logDebug(PKG_NAME, CLS_NAME, "deallocate", string);
    }

    private void logFree(ILogger iLogger, int n, long l, long l2) {
        String string = String.format("[%d] FREE    %d (free: %d)", n, l, l2);
        iLogger.logDebug(PKG_NAME, CLS_NAME, "free", string);
    }

    private void logReserve(ILogger iLogger, int n, long l, long l2, long l3) {
        String string = String.format("[%d] RESERVE %d -> %d (free: %d)", n, l, l2, l3);
        iLogger.logDebug(PKG_NAME, CLS_NAME, "reserve", string);
    }

    private void logUsage(ILogger iLogger, int n, String string, MemoryUsage memoryUsage) {
        String string2 = String.format("[%d]         R: %d (MAX: %d) A: %d", n, memoryUsage.getReservePool(), memoryUsage.getReserveMax(), memoryUsage.getAllocated());
        iLogger.logDebug(PKG_NAME, CLS_NAME, string, string2);
    }

    private MemoryUsage getUsage(Integer n) {
        MemoryUsage memoryUsage;
        MemoryUsage memoryUsage2 = this.m_currentUsage.get(n);
        if (null == memoryUsage2 && null == (memoryUsage2 = this.m_currentUsage.putIfAbsent(n, memoryUsage = new MemoryUsage(0L)))) {
            memoryUsage2 = memoryUsage;
        }
        return memoryUsage2;
    }

    private static boolean shouldLog(LogLevel logLevel, ILogger iLogger) {
        return null != iLogger && LogUtilities.shouldLogLevel(logLevel, iLogger);
    }

    private static final class Holder {
        public static final MemoryManager INSTANCE;

        private Holder() {
        }

        static {
            long l = 0L;
            IDriver iDriver = DSIDriverSingleton.getInstance();
            ILogger iLogger = null;
            if (null != iDriver) {
                iLogger = iDriver.getDriverLog();
                try {
                    long l2;
                    Variant variant = iDriver.getProperty(19);
                    BigInteger bigInteger = variant.getBigInteger();
                    if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && (l2 = bigInteger.longValue()) > 0L) {
                        l = l2 * 1024L * 1024L;
                    }
                }
                catch (Exception exception) {
                    LogUtilities.logWarning("Exception suppressed getting memory manager limit.", iLogger);
                }
            }
            if (0L >= l) {
                LogUtilities.logWarning(String.format("Memory manager memory limit clamped to %d bytes", 0x6400000L), iLogger);
                l = 0x6400000L;
            }
            long l3 = Runtime.getRuntime().maxMemory() / 2L;
            l = Math.min(l3, l);
            INSTANCE = new MemoryManager(l, iLogger);
        }
    }

    private static final class MemoryUsage {
        private boolean m_isClosed = false;
        private long m_reserveMax;
        private long m_reservePool;
        private long m_allocated = 0L;

        public MemoryUsage(long l) {
            this.m_reservePool = l;
            this.m_reserveMax = l;
        }

        public void allocate(long l) {
            if (this.m_isClosed) {
                throw new IllegalStateException();
            }
            this.m_allocated += l;
            this.m_reservePool = Math.max(this.m_reservePool - l, 0L);
        }

        public long deallocate(long l) {
            assert (!this.m_isClosed);
            assert (this.m_allocated >= l);
            this.m_allocated -= l;
            long l2 = Math.min(this.m_reserveMax - this.m_reservePool, l);
            this.m_reservePool += l2;
            return l - l2;
        }

        public long free() {
            this.m_isClosed = true;
            long l = this.m_reservePool + this.m_allocated;
            this.m_reservePool = 0L;
            this.m_allocated = 0L;
            return l;
        }

        public long getAllocated() {
            return this.m_allocated;
        }

        public long getReservePool() {
            return this.m_reservePool;
        }

        public long getReserveMax() {
            return this.m_reserveMax;
        }

        public void reserve(long l) {
            if (this.m_isClosed) {
                throw new IllegalStateException();
            }
            this.m_reservePool += l;
            this.m_reserveMax += l;
        }
    }
}

