/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation.join;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.etree.relation.join.IHasher;
import com.amazon.sqlengine.executor.etree.temptable.IRowView;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;

public class DefaultHasher
implements IHasher {
    private final long m_modulus;
    private final long m_seed;

    public DefaultHasher(long l, long l2) {
        this.m_modulus = l;
        this.m_seed = l2;
    }

    @Override
    public long hash(IRowView iRowView, int[] nArray) {
        long l;
        int n;
        long l2 = -8663945395140668459L;
        long l3 = 5545529020109919103L;
        long l4 = this.m_seed;
        long l5 = this.m_seed;
        for (n = 0; n < nArray.length; ++n) {
            l = DefaultHasher.getColumnHash(iRowView, nArray[n], iRowView.getColumn(nArray[n]));
            long l6 = (int)l;
            l6 *= l2;
            l6 = l6 << 31 | l6 >>> 33;
            l4 ^= (l6 *= l3);
            l4 = l4 << 31 | l4 >>> 33;
            l4 += l5;
            l4 = l4 * 5L + 1390208809L;
            long l7 = l >>> 32;
            l7 *= l3;
            l7 = l7 << 33 | l7 >>> 31;
            l5 ^= (l7 *= l2);
            l5 = l5 << 31 | l5 >>> 33;
            l5 += l4;
            l5 = l5 * 5L + 944331445L;
        }
        l = n * 8;
        l4 ^= l;
        l4 += (l5 ^= l);
        l5 += l4;
        l4 = DefaultHasher.mix64(l4);
        l5 = DefaultHasher.mix64(l5);
        l4 += l5;
        l5 += l4;
        if (l4 < 0L) {
            l4 = -l4;
        }
        return l4 % this.m_modulus;
    }

    private static long getColumnHash(IRowView iRowView, int n, IColumn iColumn) {
        if (iRowView.isNull(n)) {
            return 0L;
        }
        switch (iColumn.getTypeMetadata().getType()) {
            case 4: {
                return iRowView.getInteger(n);
            }
            case -5: {
                return iRowView.getBigInt(n);
            }
            case 5: {
                return iRowView.getSmallInt(n);
            }
            case -6: {
                return iRowView.getTinyInt(n);
            }
            case 6: 
            case 8: {
                return DefaultHasher.hash(iRowView.getDouble(n));
            }
            case 7: {
                return DefaultHasher.hash(iRowView.getReal(n));
            }
            case -7: 
            case 16: {
                return DefaultHasher.hash(iRowView.getBoolean(n));
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return DataRetrievalUtil.rtrim(iRowView.getString(n)).hashCode();
            }
            case 92: {
                return iRowView.getTime(n).hashCode();
            }
            case 93: {
                return iRowView.getTimestamp(n).hashCode();
            }
            case 91: {
                return iRowView.getDate(n).hashCode();
            }
            case -11: {
                return iRowView.getGuid(n).hashCode();
            }
            case 2: 
            case 3: {
                return iRowView.getExactNumber(n).hashCode();
            }
        }
        throw new IllegalStateException(String.format("Attempt to hash on type %s.", iColumn.getTypeMetadata().getTypeName()));
    }

    private static long hash(boolean bl) {
        long l = bl ? 0L : 1L;
        return l;
    }

    private static long hash(float f) {
        return Float.floatToIntBits(f);
    }

    private static long hash(double d) {
        if (0.0 == d) {
            return 0L;
        }
        return Double.doubleToLongBits(d);
    }

    private static long mix64(long l) {
        l ^= l >>> 33;
        l *= -49064778989728563L;
        l ^= l >>> 33;
        l *= -4265267296055464877L;
        l ^= l >>> 33;
        return l;
    }
}

