/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix2DProcedure;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;

public abstract class IntMatrix3DTest
extends TestCase {
    protected IntMatrix3D A;
    protected IntMatrix3D B;
    protected int NSLICES = 5;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected Random rand = new Random(0L);

    public IntMatrix3DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        int n3;
        ConcurrencyUtils.setThreadsBeginN_3D(1);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    this.A.setQuick(n3, n2, n, Math.max(1, this.rand.nextInt() % this.A.rows()));
                }
            }
        }
        for (n3 = 0; n3 < this.B.slices(); ++n3) {
            for (n2 = 0; n2 < this.B.rows(); ++n2) {
                for (n = 0; n < this.B.columns(); ++n) {
                    this.B.setQuick(n3, n2, n, Math.max(1, this.rand.nextInt() % this.B.rows()));
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateIntIntFunctionIntFunction() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.A.slices(); ++n) {
            for (int i = 0; i < this.A.rows(); ++i) {
                for (int j = 0; j < this.A.columns(); ++j) {
                    int n3 = this.A.getQuick(n, i, j);
                    n2 += n3 * n3;
                }
            }
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square);
        IntMatrix3DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntIntFunctionIntFunctionIntProcedure() {
        int n;
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return (double)Math.abs(n) > 0.2;
            }
        };
        int n2 = 0;
        for (n = 0; n < this.A.slices(); ++n) {
            for (int i = 0; i < this.A.rows(); ++i) {
                for (int j = 0; j < this.A.columns(); ++j) {
                    int n3 = this.A.getQuick(n, i, j);
                    if (!((double)Math.abs(n3) > 0.2)) continue;
                    n2 += n3 * n3;
                }
            }
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square, intProcedure);
        IntMatrix3DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntIntFunctionIntFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        int n3;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    intArrayList.add(n3);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.A.slices(); ++n2) {
            for (n = 0; n < this.A.rows(); ++n) {
                for (int i = 0; i < this.A.columns(); ++i) {
                    int n4 = this.A.getQuick(n2, n, i);
                    n3 += n4 * n4;
                }
            }
        }
        n2 = this.A.aggregate(IntFunctions.plus, IntFunctions.square, intArrayList, intArrayList2, intArrayList3);
        IntMatrix3DTest.assertEquals((int)n3, (int)n2);
    }

    public void testAggregateIntMatrix2DIntIntFunctionIntIntFunction() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.A.slices(); ++n) {
            for (int i = 0; i < this.A.rows(); ++i) {
                for (int j = 0; j < this.A.columns(); ++j) {
                    int n3 = this.A.getQuick(n, i, j);
                    int n4 = this.B.getQuick(n, i, j);
                    n2 += n3 * n4;
                }
            }
        }
        n = this.A.aggregate(this.B, IntFunctions.plus, IntFunctions.mult);
        IntMatrix3DTest.assertEquals((int)n2, (int)n);
    }

    public void testAssignInt() {
        int n = this.rand.nextInt();
        this.A.assign(n);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)n, (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignIntArray() {
        int[] nArray = new int[(int)this.A.size()];
        int n = 0;
        while ((long)n < this.A.size()) {
            nArray[n] = this.rand.nextInt();
            ++n;
        }
        this.A.assign(nArray);
        n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)nArray[n++], (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignIntArrayArrayArray() {
        int n;
        int n2;
        int n3;
        int[][][] nArray = new int[this.A.slices()][this.A.rows()][this.A.columns()];
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    nArray[n3][n2][n] = this.rand.nextInt();
                }
            }
        }
        this.A.assign(nArray);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            IntMatrix3DTest.assertTrue((this.A.rows() == nArray[n3].length ? 1 : 0) != 0);
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                IntMatrix3DTest.assertTrue((this.A.columns() == nArray[n3][n2].length ? 1 : 0) != 0);
                for (n = 0; n < this.A.columns(); ++n) {
                    IntMatrix3DTest.assertEquals((int)nArray[n3][n2][n], (int)this.A.getQuick(n3, n2, n));
                }
            }
        }
    }

    public void testAssignIntFunction() {
        IntMatrix3D intMatrix3D = this.A.copy();
        this.A.assign(IntFunctions.neg);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    int n = -intMatrix3D.getQuick(i, j, k);
                    IntMatrix3DTest.assertEquals((int)n, (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignIntMatrix3D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.B.getQuick(i, j, k), (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignIntMatrix3DIntIntFunction() {
        IntMatrix3D intMatrix3D = this.A.copy();
        this.A.assign(this.B, IntFunctions.plus);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)(intMatrix3D.getQuick(i, j, k) + this.B.getQuick(i, j, k)), (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignIntMatrix3DIntIntFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        IntMatrix3D intMatrix3D = this.A.copy();
        this.A.assign(this.B, IntFunctions.plus, intArrayList, intArrayList2, intArrayList3);
        for (n2 = 0; n2 < this.A.slices(); ++n2) {
            for (n = 0; n < this.A.rows(); ++n) {
                for (int i = 0; i < this.A.columns(); ++i) {
                    IntMatrix3DTest.assertEquals((int)(intMatrix3D.getQuick(n2, n, i) + this.B.getQuick(n2, n, i)), (int)this.A.getQuick(n2, n, i));
                }
            }
        }
    }

    public void testAssignIntProcedureInt() {
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return Math.abs(n) > 1;
            }
        };
        IntMatrix3D intMatrix3D = this.A.copy();
        this.A.assign(intProcedure, -1);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (Math.abs(intMatrix3D.getQuick(i, j, k)) > 1) {
                        IntMatrix3DTest.assertEquals((int)-1, (int)this.A.getQuick(i, j, k));
                        continue;
                    }
                    IntMatrix3DTest.assertEquals((int)intMatrix3D.getQuick(i, j, k), (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignIntProcedureIntFunction() {
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return Math.abs(n) > 1;
            }
        };
        IntMatrix3D intMatrix3D = this.A.copy();
        this.A.assign(intProcedure, IntFunctions.neg);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (Math.abs(intMatrix3D.getQuick(i, j, k)) > 1) {
                        IntMatrix3DTest.assertEquals((int)(-intMatrix3D.getQuick(i, j, k)), (int)this.A.getQuick(i, j, k));
                        continue;
                    }
                    IntMatrix3DTest.assertEquals((int)intMatrix3D.getQuick(i, j, k), (int)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        int n2 = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (this.A.getQuick(i, j, k) == 0) continue;
                    ++n2;
                }
            }
        }
        IntMatrix3DTest.assertEquals((int)n2, (int)n);
    }

    public void testEqualsInt() {
        int n = 1;
        this.A.assign(n);
        boolean bl = this.A.equals(n);
        IntMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2);
        IntMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        IntMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        IntMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, 7);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 2, this.A.columns() / 2, 1);
        int[] nArray = this.A.getMaxLocation();
        IntMatrix3DTest.assertEquals((int)7, (int)nArray[0]);
        IntMatrix3DTest.assertEquals((int)(this.A.slices() / 3), (int)nArray[1]);
        IntMatrix3DTest.assertEquals((int)(this.A.rows() / 3), (int)nArray[2]);
        IntMatrix3DTest.assertEquals((int)(this.A.columns() / 3), (int)nArray[3]);
    }

    public void testMinLocation() {
        this.A.assign(0);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, -7);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 2, this.A.columns() / 2, -1);
        int[] nArray = this.A.getMinLocation();
        IntMatrix3DTest.assertEquals((int)-7, (int)nArray[0]);
        IntMatrix3DTest.assertEquals((int)(this.A.slices() / 3), (int)nArray[1]);
        IntMatrix3DTest.assertEquals((int)(this.A.rows() / 3), (int)nArray[2]);
        IntMatrix3DTest.assertEquals((int)(this.A.columns() / 3), (int)nArray[3]);
    }

    public void testGetNegativeValues() {
        this.A.assign(0);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, -7);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, -1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        IntArrayList intArrayList4 = new IntArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, intArrayList3, intArrayList4);
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList4.size());
        IntMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList4.contains(-7));
        IntMatrix3DTest.assertTrue((boolean)intArrayList4.contains(-1));
    }

    public void testGetNonZeros() {
        this.A.assign(0);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, 7);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, 1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        IntArrayList intArrayList4 = new IntArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3, intArrayList4);
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList4.size());
        IntMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList4.contains(7));
        IntMatrix3DTest.assertTrue((boolean)intArrayList4.contains(1));
    }

    public void testGetPositiveValues() {
        this.A.assign(0);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, 7);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, 1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        IntArrayList intArrayList4 = new IntArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, intArrayList3, intArrayList4);
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        IntMatrix3DTest.assertEquals((int)2, (int)intArrayList4.size());
        IntMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 3));
        IntMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 2));
        IntMatrix3DTest.assertTrue((boolean)intArrayList4.contains(7));
        IntMatrix3DTest.assertTrue((boolean)intArrayList4.contains(1));
    }

    public void testToArray() {
        int[][][] nArray = this.A.toArray();
        for (int i = 0; i < this.A.slices(); ++i) {
            IntMatrix3DTest.assertTrue((this.A.rows() == nArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.A.rows(); ++j) {
                IntMatrix3DTest.assertTrue((this.A.columns() == nArray[i][j].length ? 1 : 0) != 0);
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)0, (int)Math.abs(nArray[i][j][k] - this.A.getQuick(i, j, k)));
                }
            }
        }
    }

    public void testVectorize() {
        IntMatrix1D intMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                for (int k = 0; k < this.A.rows(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(i, k, j), (int)intMatrix1D.getQuick(n++));
                }
            }
        }
    }

    public void testViewColumn() {
        IntMatrix2D intMatrix2D = this.A.viewColumn(this.A.columns() / 2);
        IntMatrix3DTest.assertEquals((int)this.A.slices(), (int)intMatrix2D.rows());
        IntMatrix3DTest.assertEquals((int)this.A.rows(), (int)intMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                IntMatrix3DTest.assertEquals((int)this.A.getQuick(i, j, this.A.columns() / 2), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewColumnFlip() {
        IntMatrix3D intMatrix3D = this.A.viewColumnFlip();
        IntMatrix3DTest.assertEquals((long)this.A.size(), (long)intMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(i, j, this.A.columns() - 1 - k), (int)intMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewDice() {
        IntMatrix3D intMatrix3D = this.A.viewDice(2, 1, 0);
        IntMatrix3DTest.assertEquals((int)this.A.slices(), (int)intMatrix3D.columns());
        IntMatrix3DTest.assertEquals((int)this.A.rows(), (int)intMatrix3D.rows());
        IntMatrix3DTest.assertEquals((int)this.A.columns(), (int)intMatrix3D.slices());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(i, j, k), (int)intMatrix3D.getQuick(k, j, i));
                }
            }
        }
    }

    public void testViewPart() {
        IntMatrix3D intMatrix3D = this.A.viewPart(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3);
        for (int i = 0; i < this.A.slices() / 3; ++i) {
            for (int j = 0; j < this.A.rows() / 3; ++j) {
                for (int k = 0; k < this.A.columns() / 3; ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(this.A.slices() / 2 + i, this.A.rows() / 2 + j, this.A.columns() / 2 + k), (int)intMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewRow() {
        IntMatrix2D intMatrix2D = this.A.viewRow(this.A.rows() / 2);
        IntMatrix3DTest.assertEquals((int)this.A.slices(), (int)intMatrix2D.rows());
        IntMatrix3DTest.assertEquals((int)this.A.columns(), (int)intMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix3DTest.assertEquals((int)this.A.getQuick(i, this.A.rows() / 2, j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewRowFlip() {
        IntMatrix3D intMatrix3D = this.A.viewRowFlip();
        IntMatrix3DTest.assertEquals((long)this.A.size(), (long)intMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(i, this.A.rows() - 1 - j, k), (int)intMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewSelectionIntMatrix2DProcedure() {
        this.A.assign(0);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 4, 0, 2);
        IntMatrix3D intMatrix3D = this.A.viewSelection(new IntMatrix2DProcedure(){

            public boolean apply(IntMatrix2D intMatrix2D) {
                return Math.abs(intMatrix2D.getQuick(IntMatrix3DTest.this.A.rows() / 4, 0) - 2) == 0;
            }
        });
        IntMatrix3DTest.assertEquals((int)1, (int)intMatrix3D.slices());
        IntMatrix3DTest.assertEquals((int)this.A.rows(), (int)intMatrix3D.rows());
        IntMatrix3DTest.assertEquals((int)this.A.columns(), (int)intMatrix3D.columns());
        IntMatrix3DTest.assertEquals((int)this.A.getQuick(this.A.slices() / 2, this.A.rows() / 4, 0), (int)intMatrix3D.getQuick(0, this.A.rows() / 4, 0));
    }

    public void testViewSelectionIntArrayIntArrayIntArray() {
        int[] nArray = new int[]{this.A.slices() / 2, this.A.slices() / 3};
        int[] nArray2 = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray3 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        IntMatrix3D intMatrix3D = this.A.viewSelection(nArray, nArray2, nArray3);
        IntMatrix3DTest.assertEquals((int)nArray.length, (int)intMatrix3D.slices());
        IntMatrix3DTest.assertEquals((int)nArray2.length, (int)intMatrix3D.rows());
        IntMatrix3DTest.assertEquals((int)nArray3.length, (int)intMatrix3D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(nArray[i], nArray2[j], nArray3[k]), (int)intMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewSlice() {
        IntMatrix2D intMatrix2D = this.A.viewSlice(this.A.slices() / 2);
        IntMatrix3DTest.assertEquals((int)this.A.rows(), (int)intMatrix2D.rows());
        IntMatrix3DTest.assertEquals((int)this.A.columns(), (int)intMatrix2D.columns());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix3DTest.assertEquals((int)this.A.getQuick(this.A.slices() / 2, i, j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSliceFlip() {
        IntMatrix3D intMatrix3D = this.A.viewSliceFlip();
        IntMatrix3DTest.assertEquals((long)this.A.size(), (long)intMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(this.A.slices() - 1 - i, j, k), (int)intMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewSorted() {
        IntMatrix3D intMatrix3D = this.A.viewSorted(1, 1);
        for (int i = 0; i < this.A.slices() - 1; ++i) {
            IntMatrix3DTest.assertTrue((intMatrix3D.getQuick(i + 1, 1, 1) >= intMatrix3D.getQuick(i, 1, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        IntMatrix3D intMatrix3D = this.A.viewStrides(n, n2, n3);
        for (int i = 0; i < intMatrix3D.slices(); ++i) {
            for (int j = 0; j < intMatrix3D.rows(); ++j) {
                for (int k = 0; k < intMatrix3D.columns(); ++k) {
                    IntMatrix3DTest.assertEquals((int)this.A.getQuick(i * n, j * n2, k * n3), (int)intMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testZSum() {
        int n = this.A.zSum();
        int n2 = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    n2 += this.A.getQuick(i, j, k);
                }
            }
        }
        IntMatrix3DTest.assertEquals((int)n2, (int)n);
    }
}

