/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.ISaSpecification;
import ec.satoolkit.algorithm.implementation.GeneralizedAirlineProcessingFactory;
import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.satoolkit.special.PreprocessingSpecification;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.arima.special.GaSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;

public class GeneralizedAirlineSpecification
implements ISaSpecification,
Cloneable {
    private PreprocessingSpecification preprocessingSpec = new PreprocessingSpecification();
    private GaSpecification decompositionSpec;
    private SaBenchmarkingSpec benchmarkingSpec;

    public GeneralizedAirlineSpecification() {
        this.preprocessingSpec.dtype = TradingDaysType.TradingDays;
        this.preprocessingSpec.ltype = LengthOfPeriodType.LeapYear;
        this.decompositionSpec = new GaSpecification();
        this.benchmarkingSpec = new SaBenchmarkingSpec();
    }

    public PreprocessingSpecification getPreprocessingSpec() {
        return this.preprocessingSpec;
    }

    public GaSpecification getDecompositionSpec() {
        return this.decompositionSpec;
    }

    public SaBenchmarkingSpec getBenchmarkingSpec() {
        return this.benchmarkingSpec;
    }

    public void setPreprocessingSpec(PreprocessingSpecification spec) {
        this.preprocessingSpec = spec;
    }

    public void setDecompositionSpec(GaSpecification spec) {
        this.decompositionSpec = spec;
    }

    public void setBenchmarkingSpec(SaBenchmarkingSpec spec) {
        this.benchmarkingSpec = spec;
    }

    public String toString() {
        return GeneralizedAirlineProcessingFactory.DESCRIPTOR.name;
    }

    @Override
    public GeneralizedAirlineSpecification clone() {
        try {
            GeneralizedAirlineSpecification spec = (GeneralizedAirlineSpecification)super.clone();
            if (this.decompositionSpec != null) {
                spec.decompositionSpec = this.decompositionSpec.clone();
            }
            if (this.preprocessingSpec != null) {
                spec.preprocessingSpec = this.preprocessingSpec.clone();
            }
            if (this.benchmarkingSpec != null) {
                spec.benchmarkingSpec = this.benchmarkingSpec.clone();
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public InformationSet write(boolean verbose) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean read(InformationSet info) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IPreprocessor buildPreprocessor(ProcessingContext context) {
        return this.preprocessingSpec == null ? null : this.preprocessingSpec.build(context);
    }

    @Override
    public String toLongString() {
        return "Generalized Airline";
    }
}

